/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Path;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.shared.ArrayDeque;

public class IndentInfo {
    private final int lineNumber;
    private int tokensSeen;
    private final int indentValue;
    private final ArrayDeque<Frame> stackNodes;
    private PooledPathList indentPathCache = new PooledPathList(512, false);

    public ArrayDeque<Frame> getStackNodes() {
        return this.stackNodes;
    }

    public void fillStackNodes(ArrayDeque<Frame> nodes) {
        this.stackNodes.clear();
        this.stackNodes.addAll(nodes);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getTokensSeen() {
        return this.tokensSeen;
    }

    public void setTokensSeen(int tokenPos) {
        this.tokensSeen = tokenPos;
    }

    public int getIndentValue() {
        return this.indentValue;
    }

    public static IndentInfo cloneIndentInfo(IndentInfo original) {
        IndentInfo cloneResult = new IndentInfo(original.getLineNumber(), original.getTokensSeen(), original.getIndentValue());
        cloneResult.fillStackNodes(original.getStackNodes());
        return cloneResult;
    }

    public IndentInfo(int line, int tok, int indent) {
        this.lineNumber = line;
        this.tokensSeen = tok;
        this.indentValue = indent;
        this.stackNodes = new ArrayDeque();
    }

    public IndentInfo() {
        this(-1, -1, -1);
    }

    public int maxReduceLength() throws InterruptedException {
        int maxPathLength = 0;
        for (Frame activeStack : this.stackNodes) {
            this.indentPathCache.start();
            try {
                activeStack.findAllPaths(this.indentPathCache, 2);
                int i = 0;
                while (i < this.indentPathCache.size()) {
                    int length = this.indentPathCache.get(i).getLength();
                    if (length > maxPathLength) {
                        maxPathLength = length;
                    }
                    ++i;
                }
            }
            finally {
                this.indentPathCache.end();
            }
        }
        return maxPathLength;
    }

    public int structureStartPosition() throws InterruptedException {
        return this.tokensSeen - this.maxReduceLength();
    }

    public Link getReductionLink() throws InterruptedException {
        int maxPathLength = -1;
        Link result = null;
        for (Frame activeStack : this.stackNodes) {
            activeStack.findAllPaths(this.indentPathCache, 3);
            int i = 0;
            while (i < this.indentPathCache.size()) {
                Path p = this.indentPathCache.get(i);
                int length = p.getLength();
                if (length > maxPathLength) {
                    maxPathLength = length;
                    if (p.getParent().getLabel() != null) {
                        result = p.getParent().getLink();
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

