/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import javax.annotation.Nullable;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class Build
extends Strategy {
    private IStrategoAppl pattern;

    public Build(IStrategoAppl pattern) {
        this.pattern = pattern;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        Build.debug("Build.eval() - ", env.current(), " -> !", this.pattern);
        IStrategoTerm newTerm = this.buildTerm(this.pattern, env);
        if (newTerm == null) {
            return this.getHook().pop().onFailure(env);
        }
        env.setCurrent(newTerm);
        return this.getHook().pop().onSuccess(env);
    }

    @Nullable
    public IStrategoTerm buildTerm(IStrategoAppl pattern, IContext env) {
        if (Tools.isAnno(pattern, env)) {
            return this.buildAnno(pattern, env);
        }
        if (Tools.isOp(pattern, env)) {
            return this.buildOp(pattern, env);
        }
        if (Tools.isInt(pattern, env)) {
            return this.buildInt(pattern, env);
        }
        if (Tools.isReal(pattern, env)) {
            return this.buildReal(pattern, env);
        }
        if (Tools.isStr(pattern, env)) {
            return this.buildStr(pattern, env);
        }
        if (Tools.isVar(pattern, env)) {
            return this.buildVar(pattern, env);
        }
        if (Tools.isExplode(pattern, env)) {
            return this.buildExplode(pattern, env);
        }
        throw new IllegalStateException("Unknown build constituent '" + pattern.getConstructor() + "'");
    }

    @Nullable
    private IStrategoTerm buildExplode(IStrategoAppl pattern, IContext env) {
        Build.debug("buildExplode() : ", pattern);
        IStrategoAppl ctorPattern = TermUtils.toApplAt(pattern, 0);
        IStrategoAppl argsPattern = TermUtils.toApplAt(pattern, 1);
        Build.debug(" ctor : ", ctorPattern);
        Build.debug(" args : ", argsPattern);
        IStrategoTerm constructorName = this.buildTerm(ctorPattern, env);
        IStrategoTerm argumentList = this.buildTerm(argsPattern, env);
        if (constructorName == null || argumentList == null) {
            return null;
        }
        Build.debug(" actualCtor : ", constructorName);
        Build.debug(" actualArgs : ", argumentList);
        if (TermUtils.isInt(constructorName) || TermUtils.isReal(constructorName)) {
            return constructorName;
        }
        if (TermUtils.isString(constructorName)) {
            return this.doBuildExplode(constructorName, argumentList, env);
        }
        if (TermUtils.isList(constructorName)) {
            return argumentList;
        }
        return null;
    }

    private IStrategoTerm doBuildExplode(IStrategoTerm constructorName, IStrategoTerm argumentList, IContext env) {
        ITermFactory factory = env.getFactory();
        String name = TermUtils.toJavaString(constructorName);
        IStrategoTerm[] realArgs = TermUtils.toList(argumentList).getAllSubterms();
        if (name.isEmpty()) {
            return factory.makeTuple(realArgs);
        }
        if (name.length() >= 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            name = name.substring(1, name.length() - 1);
            if (realArgs.length == 0) {
                return factory.makeString(name);
            }
        }
        IStrategoConstructor afun = factory.makeConstructor(name, realArgs.length);
        return factory.makeAppl(afun, realArgs);
    }

    @Nullable
    private IStrategoTerm buildVar(IStrategoAppl pattern, IContext env) {
        String name = TermUtils.toJavaStringAt(pattern, 0);
        try {
            return env.lookupVar(name);
        }
        catch (InterpreterException e) {
            throw new RuntimeException(e);
        }
    }

    private IStrategoString buildStr(IStrategoAppl pattern, IContext env) {
        return TermUtils.toStringAt(pattern, 0);
    }

    private IStrategoReal buildReal(IStrategoAppl pattern, IContext env) {
        String x = TermUtils.toJavaStringAt(pattern, 0);
        return env.getFactory().makeReal(new Double(x));
    }

    private IStrategoInt buildInt(IStrategoAppl pattern, IContext env) {
        String x = TermUtils.toJavaStringAt(pattern, 0);
        return env.getFactory().makeInt(new Integer(x));
    }

    @Nullable
    private IStrategoTerm buildOp(IStrategoAppl pattern, IContext env) {
        String ctr = TermUtils.toJavaStringAt(pattern, 0);
        IStrategoList children = TermUtils.toListAt(pattern, 1);
        if (ctr.length() == 0) {
            return this.buildTuple(pattern, env);
        }
        if (this.matchesConstructor(ctr, children.getSubtermCount(), env.getStrategoSignature().CTOR_Nil)) {
            return this.buildNil(pattern, env);
        }
        if (this.matchesConstructor(ctr, children.getSubtermCount(), env.getStrategoSignature().CTOR_Cons)) {
            return this.buildCons(pattern, env);
        }
        return this.doBuildOp(ctr, pattern, env);
    }

    @Nullable
    private IStrategoTerm doBuildOp(String ctr, IStrategoAppl pattern, IContext env) {
        IStrategoList children = TermUtils.toListAt(pattern, 1);
        IStrategoConstructor ctor = env.getFactory().makeConstructor(ctr, children.size());
        IStrategoTerm[] kids = new IStrategoTerm[children.size()];
        int i = children.size() - 1;
        while (i >= 0) {
            IStrategoTerm kid = this.buildTerm(TermUtils.toApplAt(children, i), env);
            if (kid == null) {
                return null;
            }
            kids[i] = kid;
            --i;
        }
        return env.getFactory().makeAppl(ctor, kids);
    }

    private boolean matchesConstructor(String name, int arity, IStrategoConstructor constructor) {
        return constructor.getName().equals(name) && constructor.getArity() == arity;
    }

    private IStrategoList buildNil(IStrategoAppl pattern, IContext env) {
        return env.getFactory().makeList();
    }

    @Nullable
    private IStrategoList buildCons(IStrategoAppl pattern, IContext env) {
        IStrategoList children = TermUtils.toListAt(pattern, 1);
        IStrategoAppl headPattern = TermUtils.toApplAt(children, 0);
        IStrategoAppl tailPattern = TermUtils.toApplAt(children, 1);
        IStrategoTerm head = this.buildTerm(headPattern, env);
        IStrategoList tail = this.buildList(tailPattern, env);
        if (head == null || tail == null) {
            return null;
        }
        return env.getFactory().makeListCons(head, tail);
    }

    @Nullable
    private IStrategoList buildList(IStrategoAppl pattern, IContext env) {
        IStrategoTerm r;
        if (Tools.isAnno(pattern, env)) {
            pattern = TermUtils.toApplAt(pattern, 0);
            String constructorName = TermUtils.toJavaStringAt(pattern, 0);
            if (env.getStrategoSignature().CTOR_Nil.getName().equals(constructorName)) {
                return this.buildNil(pattern, env);
            }
            if (env.getStrategoSignature().CTOR_Cons.getName().equals(constructorName)) {
                return this.buildCons(pattern, env);
            }
        }
        if (Tools.isVar(pattern, env)) {
            r = this.buildVar(pattern, env);
            if (r == null) {
                return null;
            }
            if (TermUtils.isList(r)) {
                return TermUtils.toList(r);
            }
            SSLLibrary.instance(env).getIOAgent().printError("Warning: trying to build list with illegal tail: " + pattern.toString());
            return null;
        }
        r = this.buildTerm(pattern, env);
        SSLLibrary.instance(env).getIOAgent().printError("Warning: trying to build list with illegal tail: " + r);
        return null;
    }

    @Nullable
    private IStrategoTerm buildTuple(IStrategoAppl pattern, IContext env) {
        IStrategoList children = TermUtils.toListAt(pattern, 1);
        IStrategoTerm[] kids = new IStrategoTerm[children.size()];
        int i = 0;
        while (i < children.size()) {
            kids[i] = this.buildTerm(TermUtils.toApplAt(children, i), env);
            IStrategoTerm kid = kids[i];
            if (kid == null) {
                return null;
            }
            ++i;
        }
        return env.getFactory().makeTuple(kids);
    }

    @Nullable
    private IStrategoTerm buildAnno(IStrategoAppl pattern, IContext env) {
        IStrategoTerm term = this.buildTerm(TermUtils.toApplAt(pattern, 0), env);
        if (term == null) {
            return null;
        }
        IStrategoAppl annos = TermUtils.toApplAt(pattern, 1);
        if (term.getAnnotations().size() == 0 && env.getStrategoSignature().CTOR_Op.getName().equals(annos.getConstructor().getName()) && env.getStrategoSignature().CTOR_Nil.getName().equals(TermUtils.toJavaStringAt(annos, 0))) {
            return term;
        }
        IStrategoTerm annoList = this.buildTerm(annos, env);
        if (annoList == null) {
            return null;
        }
        if (!TermUtils.isList(annoList)) {
            annoList = env.getFactory().makeList(annoList);
        }
        if (annoList.equals(term.getAnnotations())) {
            return term;
        }
        return env.getFactory().annotateTerm(term, (IStrategoList)annoList);
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.first(this.toString());
    }

    @Override
    public String toString() {
        return "Build(" + this.pattern + ")";
    }

    @Override
    protected String getTraceName() {
        return String.valueOf(super.getTraceName()) + "(" + this.pattern + ")";
    }
}

