/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import java.util.Arrays;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.jsglr.treediff.AbstractTreeMatcher;
import org.spoofax.interpreter.library.jsglr.treediff.HelperFunctions;
import org.spoofax.interpreter.library.jsglr.treediff.LCSEqualTermsCommand;
import org.spoofax.interpreter.library.jsglr.treediff.TermMatchAttachment;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.ParentAttachment;

public class HeuristicTreeMatcher
extends AbstractTreeMatcher {
    private boolean requireSameSignature;
    private boolean requireSameValue;

    public HeuristicTreeMatcher(boolean requireSameSignature, boolean requireSameValue, boolean tryMatchingMovedTerms) {
        super(new LCSEqualTermsCommand(), tryMatchingMovedTerms);
        this.requireSameSignature = requireSameSignature;
        this.requireSameValue = requireSameValue;
    }

    @Override
    ArrayList<IStrategoTerm> getCandidateMatchTerms(IStrategoTerm root1, IStrategoTerm t2) {
        ArrayList<IStrategoTerm> candidateMatches = new ArrayList<IStrategoTerm>();
        int i = 0;
        while (i < t2.getSubtermCount()) {
            IStrategoTerm parent1;
            IStrategoTerm subTermMatch1 = TermMatchAttachment.getMatchedTerm(t2.getSubterm(i));
            if (subTermMatch1 != null && (parent1 = ParentAttachment.getParent(subTermMatch1)) != null) {
                this.addCandidate(candidateMatches, parent1);
            }
            ++i;
        }
        if (candidateMatches.size() > 1) {
            IStrategoTerm commonAncestor = this.commonAncestor(candidateMatches);
            this.addCandidate(candidateMatches, commonAncestor);
            int i2 = 0;
            while (i2 < candidateMatches.size()) {
                IStrategoTerm ancestorCandidate = candidateMatches.get(i2);
                while (ancestorCandidate != commonAncestor) {
                    assert (ancestorCandidate != null);
                    this.addCandidate(candidateMatches, ancestorCandidate);
                    ancestorCandidate = ParentAttachment.getParent(ancestorCandidate);
                }
                ++i2;
            }
        }
        return candidateMatches;
    }

    private void addCandidate(ArrayList<IStrategoTerm> candidateMatches, IStrategoTerm candidate) {
        if (!this.contains(candidateMatches, candidate)) {
            candidateMatches.add(candidate);
        }
    }

    private IStrategoTerm commonAncestor(ArrayList<IStrategoTerm> terms) {
        ArrayList<IStrategoTerm> ancestors = new ArrayList<IStrategoTerm>();
        IStrategoTerm anc = terms.get(0);
        while (anc != null) {
            ancestors.add(anc);
            anc = ParentAttachment.getParent(anc);
        }
        int index_common_ancestor = -1;
        int i = 0;
        while (i < terms.size()) {
            IStrategoTerm c = terms.get(i);
            while (c != null && !ancestors.contains(c)) {
                c = ParentAttachment.getParent(c);
            }
            assert (c != null) : "at least the root node is a common ancestor";
            index_common_ancestor = Math.max(index_common_ancestor, ancestors.indexOf(c));
            ++i;
        }
        IStrategoTerm commonAncestor = (IStrategoTerm)ancestors.get(index_common_ancestor);
        return commonAncestor;
    }

    @Override
    double matchingScore(IStrategoTerm t1, IStrategoTerm t2) {
        if (!this.meetsMatchingCriteria(t1, t2)) {
            return -1.0;
        }
        if (HelperFunctions.haveTupleOrListType(t1, t2) && this.hasMatchedParents(t1, t2) && this.hasMatchingChildIndex(t1, t2)) {
            return 1.0;
        }
        ArrayList<IStrategoTerm> leafnodes1 = HelperFunctions.collectLeafnodes(t1);
        ArrayList<IStrategoTerm> leafnodes2 = HelperFunctions.collectLeafnodes(t2);
        double maxValue = 8.0 + (double)leafnodes1.size() + (double)leafnodes2.size();
        double value = 0.0;
        if (HelperFunctions.haveSameSignature(t1, t2) || HelperFunctions.isPrimitiveWithSameValue(t1, t2)) {
            value += 2.0;
            if (t1.equals(t2)) {
                value += 2.0;
            }
        }
        for (IStrategoTerm ln2 : leafnodes2) {
            IStrategoTerm ln2Partner = TermMatchAttachment.getMatchedTerm(ln2);
            if (!leafnodes1.contains(ln2Partner)) continue;
            value += 2.0;
        }
        if (this.hasMatchedParents(t1, t2)) {
            value += 2.0;
            if (this.hasMatchingChildIndex(t1, t2)) {
                value += 2.0;
            }
        }
        return 1.0 * value / maxValue;
    }

    private boolean hasMatchingChildIndex(IStrategoTerm t1, IStrategoTerm t2) {
        if (!this.hasMatchedParents(t1, t2)) {
            return false;
        }
        IStrategoTerm parent1 = ParentAttachment.getParent(t1);
        IStrategoTerm parent2 = ParentAttachment.getParent(t2);
        int childIndex1 = this.getChildIndex(parent1, t1);
        int childIndex2 = this.getChildIndex(parent2, t2);
        assert (childIndex1 != -1 && childIndex2 != -1);
        return HelperFunctions.haveSameSignature(parent1, parent2) && Tools.isTermAppl(parent1) && childIndex1 == childIndex2;
    }

    private int getChildIndex(IStrategoTerm parent, IStrategoTerm trm) {
        return Arrays.asList(parent.getAllSubterms()).indexOf(trm);
    }

    private boolean meetsMatchingCriteria(IStrategoTerm t1, IStrategoTerm t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        if (!HelperFunctions.isSameTermType(t1, t2)) {
            return false;
        }
        if (!HelperFunctions.haveSameSignature(t1, t2) && Tools.isTermAppl(t1)) {
            assert (Tools.isTermAppl(t2)) : "Same term type required";
            return !this.requireSameSignature && this.hasMatchedParents(t1, t2) && this.hasMatchingChildIndex(t1, t2);
        }
        if (HelperFunctions.isPrimitiveWithDifferentValues(t1, t2)) {
            return !this.requireSameValue;
        }
        return true;
    }

    private boolean hasMatchedParents(IStrategoTerm t1, IStrategoTerm t2) {
        IStrategoTerm parent1 = ParentAttachment.getParent(t1);
        IStrategoTerm parent2 = ParentAttachment.getParent(t2);
        IStrategoTerm partnerParent1 = TermMatchAttachment.getMatchedTerm(parent1);
        boolean hasMatchingParents = partnerParent1 == parent2 && partnerParent1 != null;
        return hasMatchingParents;
    }
}

