/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr;

import java.io.IOException;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.jsglr.JSGLRPrimitive;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.FilterException;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.jsglr.client.imploder.TreeBuilder;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.terms.TermFactory;

public class STRSGLR_recover_parse_string
extends JSGLRPrimitive {
    private int cursorLocation;

    protected STRSGLR_recover_parse_string() {
        super("STRSGLR_recover_parse_string", 1, 5);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        String startSymbol;
        if (Tools.isTermInt(tvars[4])) {
            this.cursorLocation = Tools.asJavaInt(tvars[4]);
        } else if (tvars[4].getSubtermCount() == 0 && tvars[4].getTermType() == 1 && ((IStrategoAppl)tvars[2]).getConstructor().getName().equals("None")) {
            this.cursorLocation = -1;
        } else {
            return false;
        }
        if (!Tools.isTermString(tvars[0])) {
            return false;
        }
        if (!this.isParseTableTerm(tvars[1])) {
            return false;
        }
        if (!Tools.isTermString(tvars[3])) {
            return false;
        }
        if (Tools.isTermString(tvars[2])) {
            startSymbol = Tools.asJavaString(tvars[2]);
        } else if (tvars[2].getSubtermCount() == 0 && tvars[2].getTermType() == 1 && ((IStrategoAppl)tvars[2]).getConstructor().getName().equals("None")) {
            startSymbol = null;
        } else {
            return false;
        }
        String lastPath = Tools.asJavaString(tvars[3]);
        ParseTable table = this.getParseTable(env, tvars);
        if (table == null) {
            return false;
        }
        try {
            IStrategoTerm result = this.call(env, (IStrategoString)tvars[0], table, startSymbol);
            env.setCurrent(result);
            return result != null;
        }
        catch (IOException e) {
            IOAgent io = SSLLibrary.instance(env).getIOAgent();
            io.printError("JSGLR_recover_parse_string: could not parse " + lastPath + " - " + e.getMessage());
            return false;
        }
        catch (SGLRException e) {
            IStrategoTerm errorTerm = e.toTerm(lastPath);
            if (e instanceof FilterException) {
                e.printStackTrace();
            }
            env.setCurrent(errorTerm);
            return svars[0].evaluate(env);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isParseTableTerm(IStrategoTerm pt) {
        return pt.getTermType() == 1 && ((IStrategoAppl)pt).getConstructor().getName().equals("parse-table");
    }

    protected ParseTable getParseTable(IContext env, IStrategoTerm[] tvars) {
        TermFactory factory = new TermFactory();
        IStrategoTerm tableTerm = tvars[1];
        try {
            return new ParseTable(tableTerm, factory);
        }
        catch (InvalidParseTableException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IStrategoTerm call(IContext env, IStrategoString input, ParseTable table, String startSymbol) throws InterpreterException, IOException, SGLRException, InterruptedException {
        SGLR parser = new SGLR(new TreeBuilder(new TermTreeFactory(env.getFactory())), table);
        parser.setUseStructureRecovery(true);
        parser.setCompletionParse(true, this.cursorLocation);
        IStrategoTerm result = (IStrategoTerm)parser.parse((String)input.stringValue(), null, (String)startSymbol).output;
        parser.setCompletionParse(false, Integer.MAX_VALUE);
        return result;
    }
}

