/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.spoofax.interpreter.library.index.IIndex;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;

public class IndexFactory {
    private final ITermFactory termFactory;
    private final IndexEntryFactory entryFactory;

    public IndexFactory(ITermFactory termFactory, IndexEntryFactory entryFactory) {
        this.termFactory = termFactory;
        this.entryFactory = entryFactory;
    }

    public IStrategoTerm indexToTerm(IIndex index) {
        IStrategoList sourcesTerm = this.termFactory.makeList();
        for (IStrategoTerm source : index.getAllSources()) {
            IStrategoTerm sourceTerm = this.sourceToTerm(index, source);
            sourcesTerm = this.termFactory.makeListCons(sourceTerm, sourcesTerm);
        }
        return sourcesTerm;
    }

    private IStrategoTerm sourceToTerm(IIndex index, IStrategoTerm source) {
        IStrategoList entryList = this.termFactory.makeList();
        for (IndexEntry entry : index.getInSource(source)) {
            entryList = this.termFactory.makeListCons(this.entryFactory.toTerm(entry), entryList);
        }
        return this.termFactory.makeTuple(source, entryList);
    }

    public IIndex indexFromTerm(IIndex index, IStrategoTerm term) throws IOException {
        if (!TermUtils.isList(term)) {
            throw new IOException("Cannot read index; root term is not a list");
        }
        for (IStrategoTerm sourceTerm : term) {
            this.sourceFromTerm(index, sourceTerm);
        }
        return index;
    }

    private void sourceFromTerm(IIndex index, IStrategoTerm term) throws IOException {
        if (!TermUtils.isTuple(term)) {
            throw new IOException("Cannot read index; partition term is not a tuple");
        }
        IStrategoTerm source = term.getSubterm(0);
        IStrategoTerm entryList = term.getSubterm(1);
        ArrayList entries = Lists.newArrayListWithCapacity((int)entryList.getSubtermCount());
        for (IStrategoTerm entryTerm : term.getSubterm(1)) {
            entries.add(this.entryFactory.fromTerm(entryTerm));
        }
        index.addAll(source, entries);
    }
}

