/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ResourceUtils {
    private static final ILogger logger = LoggerUtils.logger(ResourceUtils.class);

    public static FileObject[] expand(FileObject location) {
        try {
            if (location.exists()) {
                FileObject[] files = location.findFiles((FileSelector)new FileTypeSelector(FileType.FILE));
                return files;
            }
        }
        catch (FileSystemException e) {
            String message = logger.format("Failed to get all files at location {}", location);
            throw new RuntimeException(message, e);
        }
        return new FileObject[0];
    }

    public static Collection<FileObject> expand(Iterable<FileObject> locations) {
        HashSet names = Sets.newHashSet();
        ArrayList resources = Lists.newArrayList();
        for (FileObject location : locations) {
            FileObject[] files;
            FileObject[] fileObjectArray = files = ResourceUtils.expand(location);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileObject file = fileObjectArray[n2];
                FileName name = file.getName();
                if (!names.contains(name)) {
                    names.add(name);
                    resources.add(file);
                }
                ++n2;
            }
        }
        return resources;
    }

    public static String relativeName(FileName resource, FileName base, boolean strict) {
        boolean isEqualOrAncestor = resource.equals(base) || resource.isAncestor(base);
        boolean isInSameFilesystem = resource.getRoot().equals(base.getRoot());
        if (isEqualOrAncestor || !strict && isInSameFilesystem) {
            try {
                return base.getRelativeName(resource);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return resource.getURI();
    }

    public static FileObject resolveFile(FileObject baseFile, String name) throws FileSystemException {
        return baseFile.getFileSystem().getFileSystemManager().resolveFile(baseFile, name);
    }
}

