/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import org.metaborg.util.log.AbstractLogger;
import org.metaborg.util.log.Level;
import org.slf4j.helpers.MessageFormatter;

public final class CapturingLogger
extends AbstractLogger {
    private final StringWriter captured = new StringWriter();
    private boolean traceEnabled = true;
    private boolean debugEnabled = true;
    private boolean infoEnabled = true;
    private boolean warnEnabled = true;
    private boolean errorEnabled = true;

    @Override
    public void trace(String msg, @Nullable Throwable cause) {
        if (!this.traceEnabled()) {
            return;
        }
        this.appendLog(Level.Trace, msg, cause);
    }

    @Override
    public boolean traceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    @Override
    public void debug(String msg, @Nullable Throwable cause) {
        if (!this.debugEnabled()) {
            return;
        }
        this.appendLog(Level.Debug, msg, cause);
    }

    @Override
    public boolean debugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    @Override
    public void info(String msg, @Nullable Throwable cause) {
        if (!this.infoEnabled()) {
            return;
        }
        this.appendLog(Level.Info, msg, cause);
    }

    @Override
    public boolean infoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean enabled) {
        this.infoEnabled = enabled;
    }

    @Override
    public void warn(String msg, @Nullable Throwable cause) {
        if (!this.warnEnabled()) {
            return;
        }
        this.appendLog(Level.Warn, msg, cause);
    }

    @Override
    public boolean warnEnabled() {
        return this.warnEnabled;
    }

    public void setWarnEnabled(boolean enabled) {
        this.warnEnabled = enabled;
    }

    @Override
    public void error(String msg, @Nullable Throwable cause) {
        if (!this.errorEnabled()) {
            return;
        }
        this.appendLog(Level.Error, msg, cause);
    }

    @Override
    public boolean errorEnabled() {
        return this.errorEnabled;
    }

    public void setErrorEnabled(boolean enabled) {
        this.errorEnabled = enabled;
    }

    @Override
    public String format(String msg, Object ... args) {
        return MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
    }

    public String toString() {
        return this.captured.toString();
    }

    private void appendLog(Level level, String msg, @Nullable Throwable cause) {
        this.captured.append("[").append(this.levelToString(level)).append("] ").append(msg).append("\n");
        if (cause != null) {
            cause.printStackTrace(new PrintWriter(this.captured));
        }
    }

    private String levelToString(Level level) {
        switch (level) {
            case Trace: {
                return "TRACE";
            }
            case Debug: {
                return "DEBUG";
            }
            case Info: {
                return "INFO ";
            }
            case Warn: {
                return "WARN ";
            }
            case Error: {
                return "ERROR";
            }
        }
        return "?????";
    }
}

