/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.util.Map;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.functions.Predicate1;

public final class CapsuleUtil {
    private static final Set.Immutable EMPTY_SET = Set.Immutable.of();
    private static final Map.Immutable EMPTY_MAP = Map.Immutable.of();

    private CapsuleUtil() {
    }

    public static <K, V> void updateValues(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val == null) continue;
            map.__put(key, val);
        }
    }

    public static <K, V> void updateValuesOrRemove(Map.Transient<K, V> map, Function2<K, V, V> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            V val = mapper.apply(key, entry.getValue());
            if (val != null) {
                map.__put(key, val);
                continue;
            }
            map.__remove(key);
        }
    }

    public static <K, V> void updateKeys(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            if (newKey == null) continue;
            map.__remove(key);
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void filter(Map.Transient<K, V> map, Predicate1<K> filter) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (filter.test(key)) continue;
            map.__remove(key);
        }
    }

    public static <K, V> void updateKeysOrRemove(Map.Transient<K, V> map, Function2<K, V, K> mapper) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            K newKey = mapper.apply(key, entry.getValue());
            map.__remove(key);
            if (newKey == null) continue;
            map.__put(newKey, entry.getValue());
        }
    }

    public static <K, V> void update(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            if (newVal == null) continue;
            set.__remove(val);
            set.__insert(newVal);
        }
    }

    public static <K, V> void updateOrRemove(Set.Transient<V> set, Function1<V, V> mapper) {
        for (Object val : set) {
            V newVal = mapper.apply(val);
            set.__remove(val);
            if (newVal == null) continue;
            set.__insert(newVal);
        }
    }

    public static <V> Set.Immutable<V> toSet(Iterable<? extends V> values) {
        if (values instanceof Set.Immutable) {
            return (Set.Immutable)values;
        }
        Set.Transient set = CapsuleUtil.transientSet();
        for (V v : values) {
            set.__insert(v);
        }
        return set.freeze();
    }

    public static <V> Set.Immutable<V> toSet(V ... values) {
        Set.Transient set = CapsuleUtil.transientSet();
        V[] VArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            set.__insert(v);
            ++n2;
        }
        return set.freeze();
    }

    public static <K, V> Map.Immutable<K, V> toMap(Map<? extends K, ? extends V> map) {
        if (map instanceof Map.Immutable) {
            return (Map.Immutable)map;
        }
        return Map.Immutable.of().__putAll(map);
    }

    public static <K, V> Map.Immutable<K, V> toMap(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Transient map = Map.Transient.of();
        for (Map.Entry<K, V> e : entries) {
            map.__put(e.getKey(), e.getValue());
        }
        return map.freeze();
    }

    public static <K, V> SetMultimap.Immutable<K, V> toSetMultimap(SetMultimap<? extends K, ? extends V> map) {
        if (map instanceof SetMultimap.Immutable) {
            return (SetMultimap.Immutable)map;
        }
        SetMultimap.Transient multimap = SetMultimap.Transient.of();
        for (Map.Entry e : map.entrySet()) {
            multimap.__insert(e.getKey(), e.getValue());
        }
        return multimap.freeze();
    }

    public static <K> Set.Immutable<K> immutableSet() {
        return EMPTY_SET;
    }

    public static <K> Set.Immutable<K> immutableSet(K value) {
        return EMPTY_SET.__insert(value);
    }

    public static <K> Set.Immutable<K> immutableSet(K value1, K value2) {
        return EMPTY_SET.__insert(value1).__insert(value2);
    }

    public static <K> Set.Transient<K> transientSet() {
        return EMPTY_SET.asTransient();
    }

    public static <K> Set.Transient<K> transientSet(K value1) {
        return EMPTY_SET.__insert(value1).asTransient();
    }

    public static <K, V> Map.Immutable<K, V> immutableMap() {
        return EMPTY_MAP;
    }

    public static <K, V> Map.Transient<K, V> transientMap() {
        return EMPTY_MAP.asTransient();
    }
}

