/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.syntax;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.metaborg.core.config.JSGLRVersion;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.syntax.FenceCharacters;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.MultiLineCommentCharacters;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.core.syntax.ParseFacet;
import org.metaborg.core.syntax.SyntaxService;
import org.metaborg.spoofax.core.syntax.ISpoofaxParser;
import org.metaborg.spoofax.core.syntax.ISpoofaxSyntaxService;
import org.metaborg.spoofax.core.syntax.ImploderImplementation;
import org.metaborg.spoofax.core.syntax.SyntaxFacet;
import org.metaborg.spoofax.core.unit.ISpoofaxInputUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class SpoofaxSyntaxService
extends SyntaxService<ISpoofaxInputUnit, ISpoofaxParseUnit>
implements ISpoofaxSyntaxService {
    private static final ILogger logger = LoggerUtils.logger(SpoofaxSyntaxService.class);

    @Inject
    public SpoofaxSyntaxService(Map<String, ISpoofaxParser> parsers) {
        super(parsers);
    }

    @Override
    public Iterable<String> singleLineCommentPrefixes(ILanguageImpl language) {
        Iterable<SyntaxFacet> facets = language.facets(SyntaxFacet.class);
        LinkedHashSet prefixes = Sets.newLinkedHashSet();
        for (SyntaxFacet facet : facets) {
            Iterables.addAll((Collection)prefixes, facet.singleLineCommentPrefixes);
        }
        return prefixes;
    }

    @Override
    public Iterable<MultiLineCommentCharacters> multiLineCommentCharacters(ILanguageImpl language) {
        Iterable<SyntaxFacet> facets = language.facets(SyntaxFacet.class);
        LinkedHashSet chars = Sets.newLinkedHashSet();
        for (SyntaxFacet facet : facets) {
            Iterables.addAll((Collection)chars, facet.multiLineCommentCharacters);
        }
        return chars;
    }

    @Override
    public Iterable<FenceCharacters> fenceCharacters(ILanguageImpl language) {
        Iterable<SyntaxFacet> facets = language.facets(SyntaxFacet.class);
        LinkedHashSet fences = Sets.newLinkedHashSet();
        for (SyntaxFacet facet : facets) {
            Iterables.addAll((Collection)fences, facet.fenceCharacters);
        }
        return fences;
    }

    @Override
    public ISpoofaxParseUnit parse(ISpoofaxInputUnit input, IProgress progress, ICancel cancel, @Nullable JSGLRVersion overrideJSGLRVersion, @Nullable ImploderImplementation overrideImploder) throws ParseException, InterruptedException {
        ILanguageImpl langImpl = input.langImpl();
        ISpoofaxParser parser = this.parser(langImpl);
        if (parser == null) {
            String message = logger.format("Cannot get a parser for {}", langImpl);
            throw new ParseException((IInputUnit)input, message);
        }
        return parser.parse(input, progress, cancel, overrideJSGLRVersion, overrideImploder);
    }

    protected final ISpoofaxParser parser(ILanguageImpl language) {
        ParseFacet facet = language.facet(ParseFacet.class);
        if (facet == null) {
            return null;
        }
        return (ISpoofaxParser)this.parsers.get(facet.type);
    }
}

