/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.style;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.style.IStyle;
import org.metaborg.spoofax.core.style.SortConsCategory;

public class StylerFacet
implements IFacet {
    private final Map<SortConsCategory, IStyle> sortConsToStyle = Maps.newHashMap();
    private final Map<String, IStyle> consToStyle = Maps.newHashMap();
    private final Map<String, IStyle> sortToStyle = Maps.newHashMap();
    private final Map<String, IStyle> tokenToStyle = Maps.newHashMap();

    public boolean hasSortConsStyle(String sort, String cons) {
        return this.sortConsToStyle.containsKey(new SortConsCategory(sort, cons));
    }

    public boolean hasConsStyle(String cons) {
        return this.consToStyle.containsKey(cons);
    }

    public boolean hasSortStyle(String sort) {
        return this.sortToStyle.containsKey(sort);
    }

    public boolean hasTokenStyle(String builtin) {
        return this.tokenToStyle.containsKey(builtin);
    }

    @Nullable
    public IStyle sortConsStyle(String sort, String cons) {
        return this.sortConsToStyle.get(new SortConsCategory(sort, cons));
    }

    @Nullable
    public IStyle consStyle(String cons) {
        return this.consToStyle.get(cons);
    }

    @Nullable
    public IStyle sortStyle(String sort) {
        return this.sortToStyle.get(sort);
    }

    @Nullable
    public IStyle tokenStyle(String builtin) {
        return this.tokenToStyle.get(builtin);
    }

    public void mapSortConsToStyle(String sort, String cons, IStyle style) {
        this.sortConsToStyle.put(new SortConsCategory(sort, cons), style);
    }

    public void mapConsToStyle(String cons, IStyle style) {
        this.consToStyle.put(cons, style);
    }

    public void mapSortToStyle(String sort, IStyle style) {
        this.sortToStyle.put(sort, style);
    }

    public void mapTokenToStyle(String builtin, IStyle style) {
        this.tokenToStyle.put(builtin, style);
    }
}

