/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import java.util.Optional;
import org.metaborg.util.functions.PartialFunction2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.jsglr.client.imploder.Injections;
import org.spoofax.terms.util.TermUtils;

public class ExplicateInjectionsPrimitive
extends AbstractPrimitive {
    public ExplicateInjectionsPrimitive() {
        super("SSL_EXT_explicate_injections", 1, 0);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        IStrategoTerm result;
        Strategy sInjName = svars[0];
        PartialFunction2 injName = (sort, intoSort) -> {
            IStrategoTerm originalTerm = env.current();
            IStrategoString sortTerm = env.getFactory().makeString((String)sort);
            IStrategoString intoSortTerm = env.getFactory().makeString((String)intoSort);
            IStrategoTuple input = env.getFactory().makeTuple(sortTerm, intoSortTerm);
            try {
                env.setCurrent(input);
                if (sInjName.evaluate(env)) {
                    Optional<String> optional = Optional.of(TermUtils.toJavaString(env.current()));
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
            catch (InterpreterException ex) {
                throw new InterpreterRuntimeException(ex);
            }
            finally {
                env.setCurrent(originalTerm);
            }
        };
        try {
            result = Injections.explicate(env.current(), injName, env.getFactory());
        }
        catch (InterpreterRuntimeException ex) {
            throw ex.getCause();
        }
        if (result == null) {
            return false;
        }
        env.setCurrent(result);
        return true;
    }

    private static class InterpreterRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final InterpreterException cause;

        public InterpreterRuntimeException(InterpreterException cause) {
            super(cause);
            this.cause = cause;
        }

        @Override
        public synchronized InterpreterException getCause() {
            return this.cause;
        }
    }
}

