/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.source.ISourceLocation;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.TermVisitor;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class AnalysisCommon {
    private final ISpoofaxTracingService tracingService;

    @Inject
    public AnalysisCommon(ISpoofaxTracingService tracingService) {
        this.tracingService = tracingService;
    }

    public String analysisFailedMessage(HybridInterpreter interpreter) {
        StackTracer stackTracer = interpreter.getContext().getStackTracer();
        return "Analysis failed\nStratego stack trace:\n" + stackTracer.getTraceString();
    }

    public Collection<IMessage> messages(@Nullable FileObject resource, MessageSeverity severity, IStrategoTerm messagesTerm) {
        ArrayList messages = Lists.newArrayListWithExpectedSize((int)messagesTerm.getSubtermCount());
        IStrategoTerm[] iStrategoTermArray = messagesTerm.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message;
            IStrategoTerm originTerm;
            IStrategoTerm term = iStrategoTermArray[n2];
            if (term.getSubtermCount() == 2) {
                originTerm = term.getSubterm(0);
                message = this.toString(term.getSubterm(1));
            } else {
                originTerm = term;
                message = String.valueOf(this.toString(term)) + " (no tree node indicated)";
            }
            if (originTerm != null) {
                ISourceLocation location = this.tracingService.location(originTerm);
                if (location != null) {
                    ISourceRegion region = location.region();
                    messages.add(this.message(resource, region, message, severity));
                } else {
                    messages.add(this.message(resource, message, severity));
                }
            } else {
                messages.add(this.message(resource, message, severity));
            }
            ++n2;
        }
        return messages;
    }

    public Collection<IMessage> messages(MessageSeverity severity, IStrategoTerm messagesTerm) {
        ArrayList messages = Lists.newArrayListWithExpectedSize((int)messagesTerm.getSubtermCount());
        IStrategoTerm[] iStrategoTermArray = messagesTerm.getAllSubterms();
        int n = iStrategoTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message;
            IStrategoTerm originTerm;
            IStrategoTerm term = iStrategoTermArray[n2];
            if (term.getSubtermCount() == 2) {
                originTerm = term.getSubterm(0);
                message = this.toString(term.getSubterm(1));
            } else {
                originTerm = term;
                message = String.valueOf(this.toString(term)) + " (no tree node indicated)";
            }
            if (originTerm != null) {
                ISourceLocation location = this.tracingService.location(originTerm);
                if (location != null) {
                    ISourceRegion region = location.region();
                    messages.add(this.message(location.resource(), region, message, severity));
                } else {
                    messages.add(this.message(null, message, severity));
                }
            } else {
                messages.add(this.message(null, message, severity));
            }
            ++n2;
        }
        return messages;
    }

    public Collection<IMessage> ambiguityMessages(final FileObject resource, IStrategoTerm ast) {
        final LinkedList messages = Lists.newLinkedList();
        TermVisitor termVisitor = new TermVisitor(){
            private IStrategoTerm ambStart;

            @Override
            public void preVisit(IStrategoTerm term) {
                if (this.ambStart == null && "amb".equals(TermUtils.asAppl(term).map(a -> a.getConstructor().getName()).orElse(null))) {
                    String text = "Fragment is ambiguous: " + this.ambToString(term);
                    ISourceLocation location = AnalysisCommon.this.tracingService.location(term);
                    if (location != null) {
                        ISourceRegion region = location.region();
                        messages.add(AnalysisCommon.this.message(resource, region, text, MessageSeverity.WARNING));
                    } else {
                        messages.add(AnalysisCommon.this.message(resource, text, MessageSeverity.WARNING));
                    }
                    this.ambStart = term;
                }
            }

            @Override
            public void postVisit(IStrategoTerm term) {
                if (term == this.ambStart) {
                    this.ambStart = null;
                }
            }

            private String ambToString(IStrategoTerm amb) {
                String result = amb.toString();
                return result.length() > 5000 ? String.valueOf(result.substring(0, 5000)) + "..." : result;
            }
        };
        termVisitor.visit(ast);
        return messages;
    }

    private String toString(IStrategoTerm term) {
        if (TermUtils.isString(term)) {
            IStrategoString messageStringTerm = (IStrategoString)term;
            return messageStringTerm.stringValue();
        }
        if (TermUtils.isList(term)) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (IStrategoTerm subterm : term) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(this.toString(subterm));
                first = false;
            }
            return sb.toString();
        }
        return term.toString();
    }

    private IMessage message(@Nullable FileObject resource, ISourceRegion region, String message, MessageSeverity severity) {
        return MessageFactory.newAnalysisMessage(resource, region, message, severity, null);
    }

    private IMessage message(@Nullable FileObject resource, String message, MessageSeverity severity) {
        return MessageFactory.newAnalysisMessageAtTop(resource, String.valueOf(message) + " (no origin information)", severity, null);
    }
}

