/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.LRItem;
import org.metaborg.sdf2table.parsetable.State;

public class SymbolStatesMapping
implements Serializable {
    private static final long serialVersionUID = 1109889933255986338L;
    public SetMultimap<ISymbol, LRItem> symbolItems = HashMultimap.create();
    public SetMultimap<LRItem, State> itemStates = HashMultimap.create();

    public Set<State> getStatesfromSymbol(Symbol symb) {
        HashSet result = Sets.newHashSet();
        for (LRItem item : this.symbolItems.get((Object)symb)) {
            result.addAll(this.itemStates.get((Object)item));
        }
        return result;
    }

    public Set<State> getStatesfromProduction(IProduction prod, SetMultimap<Priority, Integer> priorities) {
        HashSet result = Sets.newHashSet();
        for (LRItem item : this.symbolItems.get((Object)prod.leftHand())) {
            if (item.isPriorityConflict(prod)) continue;
            result.addAll(this.itemStates.get((Object)item));
        }
        return result;
    }

    public Set<State> getStatesfromItem(LRItem item) {
        return this.itemStates.get((Object)item);
    }

    public Set<LRItem> getItemsfromSymbol(Symbol symb) {
        return this.symbolItems.get((Object)symb);
    }

    public void addLink(Symbol symb, LRItem item, State state) {
        this.symbolItems.put((Object)symb, (Object)item);
        this.itemStates.put((Object)item, (Object)state);
    }
}

