/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualFactory;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class ContextualProduction
implements IProduction,
Serializable {
    private static final long serialVersionUID = -8597347751774753273L;
    private final ContextualFactory cf;
    private final Production originalProduction;
    private final int originalProductionLabel;
    private final ISymbol lhs;
    private final List<ISymbol> rhs;

    public ContextualProduction(Production orig_prod, ISymbol lhs, List<ISymbol> rhs, int originalProductionLabel, ContextualFactory cf) {
        this.originalProduction = orig_prod;
        this.originalProductionLabel = originalProductionLabel;
        this.lhs = lhs;
        this.rhs = rhs;
        this.cf = cf;
    }

    @Override
    public ISymbol leftHand() {
        return this.lhs;
    }

    @Override
    public List<ISymbol> rightHand() {
        return this.rhs;
    }

    public ContextualProduction addContext(Context context, Set<Integer> conflictingArgs) {
        ISymbol newLhs = this.lhs;
        ArrayList newRhs = Lists.newArrayList();
        HashSet contexts = Sets.newHashSet();
        contexts.add(context);
        if (conflictingArgs.contains(-1)) {
            newLhs = this.lhs instanceof ContextualSymbol ? ((ContextualSymbol)this.lhs).addContext(context) : this.cf.createContextualSymbol(this.getOrigProduction().getLhs(), contexts, this.cf);
            int i = 0;
            while (i < this.getOrigProduction().getRhs().size()) {
                if (i == 0 && i == this.getOrigProduction().leftRecursivePosition() || i == this.getOrigProduction().getRhs().size() - 1 && i == this.originalProduction.rightRecursivePosition()) {
                    newRhs.add(((ContextualSymbol)this.rhs.get(i)).addContext(context));
                } else {
                    newRhs.add((ISymbol)this.getOrigProduction().getRhs().get(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.rhs.size()) {
                if (conflictingArgs.contains(i)) {
                    if (this.rhs.get(i) instanceof ContextualSymbol) {
                        newRhs.add(((ContextualSymbol)this.rhs.get(i)).addContext(context));
                    } else {
                        newRhs.add(this.cf.createContextualSymbol((Symbol)this.rhs.get(i), contexts, this.cf));
                    }
                } else {
                    newRhs.add(this.rhs.get(i));
                }
                ++i;
            }
        }
        return this.cf.createContextualProduction(this.getOrigProduction(), newLhs, newRhs, this.getOriginalProductionLabel(), this.cf);
    }

    public ContextualProduction addContexts(Set<Context> contexts, Set<Integer> conflictingArgs) {
        ISymbol newLhs = this.lhs;
        ArrayList newRhs = Lists.newArrayList();
        if (conflictingArgs.contains(-1)) {
            newLhs = this.lhs instanceof ContextualSymbol ? ((ContextualSymbol)this.lhs).addContexts(contexts) : this.cf.createContextualSymbol(this.getOrigProduction().getLhs(), contexts, this.cf);
            int i = 0;
            while (i < this.getOrigProduction().getRhs().size()) {
                if (i == 0 && i == this.getOrigProduction().leftRecursivePosition() || i == this.getOrigProduction().getRhs().size() - 1 && i == this.originalProduction.rightRecursivePosition()) {
                    newRhs.add(((ContextualSymbol)this.rhs.get(i)).addContexts(contexts));
                } else {
                    newRhs.add((ISymbol)this.getOrigProduction().getRhs().get(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.rhs.size()) {
                if (conflictingArgs.contains(i)) {
                    if (this.rhs.get(i) instanceof ContextualSymbol) {
                        newRhs.add(((ContextualSymbol)this.rhs.get(i)).addContexts(contexts));
                    } else {
                        newRhs.add(this.cf.createContextualSymbol((Symbol)this.rhs.get(i), contexts, this.cf));
                    }
                } else {
                    newRhs.add(this.rhs.get(i));
                }
                ++i;
            }
        }
        return this.cf.createContextualProduction(this.getOrigProduction(), newLhs, newRhs, this.getOriginalProductionLabel(), this.cf);
    }

    public ContextualProduction mergeContext(Set<Context> context, Queue<ContextualSymbol> contextualSymbols, Set<ContextualSymbol> processedSymbols, ParseTable pt) {
        ArrayList newRhs = Lists.newArrayList(this.rhs);
        HashSet contexts = Sets.newHashSet();
        contexts.addAll(context);
        ContextualSymbol new_lhs = this.cf.createContextualSymbol(this.getOrigProduction().getLhs(), contexts, this.cf);
        ArrayList rhs = Lists.newArrayList(this.getOrigProduction().getRhs());
        for (Context c : contexts) {
            ContextualSymbol new_symbol;
            int i;
            ISymbol nonTerminalContext = ((IProduction)pt.productionLabels().inverse().get((Object)c.getContext())).leftHand();
            if (c.getType().equals((Object)ContextType.DEEP)) {
                i = 0;
                while (i < this.getOrigProduction().getRhs().size()) {
                    if (i == 0 && c.getPosition().equals((Object)ContextPosition.LEFTMOST) && pt.normalizedGrammar().getLeftDerivable().get((Object)((ISymbol)rhs.get(i))).contains(nonTerminalContext) || i == this.getOrigProduction().arity() - 1 && c.getPosition().equals((Object)ContextPosition.RIGHTMOST) && pt.normalizedGrammar().getRightDerivable().get((Object)((ISymbol)rhs.get(i))).contains(nonTerminalContext)) {
                        new_symbol = newRhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)newRhs.get(i)).addContext(c) : this.cf.createContextualSymbol((Symbol)newRhs.get(i), c, this.cf);
                        newRhs.set(i, new_symbol);
                    }
                    ++i;
                }
                continue;
            }
            if (!c.getType().equals((Object)ContextType.DANGLING)) continue;
            i = 0;
            while (i < this.getOrigProduction().getRhs().size()) {
                if (i == 0 && i == this.getOrigProduction().leftRecursivePosition() || i == this.getOrigProduction().getRhs().size() - 1 && i == this.getOrigProduction().rightRecursivePosition()) {
                    new_symbol = newRhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)newRhs.get(i)).addContext(c) : this.cf.createContextualSymbol((Symbol)newRhs.get(i), c, this.cf);
                    newRhs.set(i, new_symbol);
                }
                ++i;
            }
        }
        for (ISymbol s : newRhs) {
            if (!(s instanceof ContextualSymbol)) continue;
            ContextualSymbol new_symbol = (ContextualSymbol)s;
            if (contextualSymbols == null || processedSymbols == null || processedSymbols.contains(new_symbol) || contextualSymbols.contains(new_symbol)) continue;
            contextualSymbols.add(new_symbol);
        }
        return this.cf.createContextualProduction(this.getOrigProduction(), new_lhs, newRhs, this.getOriginalProductionLabel(), this.cf);
    }

    public Production getOrigProduction() {
        return this.originalProduction;
    }

    public int getOriginalProductionLabel() {
        return this.originalProductionLabel;
    }

    public String toString() {
        String prod = "";
        prod = String.valueOf(prod) + this.lhs.name();
        prod = String.valueOf(prod) + " -> ";
        for (ISymbol s : this.rhs) {
            prod = String.valueOf(prod) + s.name() + " ";
        }
        return prod;
    }

    public IStrategoTerm toSDF3Aterm(SetMultimap<IProduction, IAttribute> prod_attrs, Map<Set<Context>, Integer> ctx_vals, Integer ctx_val) {
        ITermFactory tf = ParseTableIO.getTermfactory();
        IStrategoList.Builder rhs_terms = tf.arrayListBuilder(this.rhs.size());
        for (ISymbol s : this.rhs) {
            if (s instanceof Symbol) {
                rhs_terms.add(((Symbol)s).toSDF3Aterm(tf, ctx_vals, ctx_val));
                continue;
            }
            if (!(s instanceof ContextualSymbol)) continue;
            rhs_terms.add(((ContextualSymbol)s).toSDF3Aterm(tf, ctx_vals, ctx_val));
        }
        Set attributes = prod_attrs.get((Object)this.getOrigProduction());
        IStrategoList.Builder attrs_terms = tf.arrayListBuilder(attributes.size());
        for (IAttribute a : attributes) {
            attrs_terms.add(a.toSDF3Aterm(tf));
        }
        if (this.lhs instanceof Symbol) {
            if (attrs_terms.isEmpty()) {
                return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), ((Symbol)this.lhs).toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("NoAttrs", 0), new IStrategoTerm[0]));
            }
            return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), ((Symbol)this.lhs).toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("Attrs", 1), tf.makeList(attrs_terms)));
        }
        if (this.lhs instanceof ContextualSymbol) {
            if (attrs_terms.isEmpty()) {
                return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), ((ContextualSymbol)this.lhs).toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("NoAttrs", 0), new IStrategoTerm[0]));
            }
            return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), ((ContextualSymbol)this.lhs).toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("Attrs", 1), tf.makeList(attrs_terms)));
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
        result = 31 * result + (this.getOrigProduction() == null ? 0 : this.getOrigProduction().hashCode());
        result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextualProduction other = (ContextualProduction)obj;
        if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
            return false;
        }
        if (this.getOrigProduction() == null ? other.getOrigProduction() != null : !this.getOrigProduction().equals(other.getOrigProduction())) {
            return false;
        }
        return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
    }

    @Override
    public int arity() {
        return this.originalProduction.arity();
    }
}

