/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.deepconflicts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.deepconflicts.ContextPosition;
import org.metaborg.sdf2table.deepconflicts.ContextType;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.ParseTable;

public class ContextualFactory
implements Serializable {
    private static final long serialVersionUID = -5796688665070378982L;
    private final Map<List<Object>, Context> contexts = Maps.newHashMap();
    private final Map<List<Object>, ContextualProduction> contextualProductions = Maps.newHashMap();
    private final Map<Set<Object>, ContextualSymbol> contextualSymbols = Maps.newHashMap();

    public Context createContext(int c, ContextType type, ContextPosition position, Map<Integer, Integer> leftmostContextsMapping, Map<Integer, Integer> rightmostContextsMapping) {
        ArrayList contextFields = Lists.newArrayList((Object[])new Object[]{c, type, position, leftmostContextsMapping, rightmostContextsMapping});
        if (this.contexts.containsKey(contextFields)) {
            return this.contexts.get(contextFields);
        }
        Context context = new Context(c, type, position, leftmostContextsMapping, rightmostContextsMapping);
        this.contexts.put(contextFields, context);
        return context;
    }

    public ContextualProduction createContextualProduction(Production origProduction, ISymbol lhs, List<ISymbol> rhs, int origProductionLabel, ContextualFactory cf) {
        ArrayList contextualProductionFields = Lists.newArrayList((Object[])new Object[]{origProduction, lhs, origProductionLabel, cf});
        contextualProductionFields.addAll(rhs);
        if (this.contextualProductions.containsKey(contextualProductionFields)) {
            return this.contextualProductions.get(contextualProductionFields);
        }
        ContextualProduction cp = new ContextualProduction(origProduction, lhs, rhs, origProductionLabel, cf);
        this.contextualProductions.put(contextualProductionFields, cp);
        return cp;
    }

    public ContextualProduction createContextualProduction(Production origProduction, Set<Context> contexts, Set<Integer> args, int origProductionLabel, ContextualFactory cf) {
        ISymbol lhs = origProduction.leftHand();
        ArrayList rhs = Lists.newArrayList();
        int i = 0;
        while (i < origProduction.arity()) {
            if (args.contains(i)) {
                rhs.add(this.createContextualSymbol(origProduction.getRhs().get(i), contexts, this));
            } else {
                rhs.add(origProduction.rightHand().get(i));
            }
            ++i;
        }
        ArrayList contextualProductionFields = Lists.newArrayList((Object[])new Object[]{origProduction, lhs, origProductionLabel, cf});
        contextualProductionFields.addAll(rhs);
        if (this.contextualProductions.containsKey(contextualProductionFields)) {
            return this.contextualProductions.get(contextualProductionFields);
        }
        ContextualProduction cp = new ContextualProduction(origProduction, lhs, rhs, origProductionLabel, cf);
        this.contextualProductions.put(contextualProductionFields, cp);
        return cp;
    }

    public ContextualProduction createContextualProduction(Production origProduction, Set<Context> contexts, Queue<ContextualSymbol> contextualSymbols, Set<ContextualSymbol> processedSymbols, int origProductionLabel, ParseTable pt) {
        ContextualSymbol lhs = this.createContextualSymbol(origProduction.getLhs(), contexts, this);
        ArrayList rhs = Lists.newArrayList(origProduction.getRhs());
        for (Context c : contexts) {
            if (c.getType() == ContextType.DEEP) {
                ISymbol nonTerminalContext = ((IProduction)pt.productionLabels().inverse().get((Object)c.getContext())).leftHand();
                int i = 0;
                while (i < origProduction.arity()) {
                    if (i == 0 && c.getPosition().equals((Object)ContextPosition.LEFTMOST) && pt.normalizedGrammar().getLeftDerivable().get((Object)origProduction.rightHand().get(i)).contains(nonTerminalContext) || i == origProduction.arity() - 1 && c.getPosition().equals((Object)ContextPosition.RIGHTMOST) && pt.normalizedGrammar().getRightDerivable().get((Object)origProduction.rightHand().get(i)).contains(nonTerminalContext)) {
                        ContextualSymbol newSymbol = rhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)rhs.get(i)).addContext(c) : this.createContextualSymbol((Symbol)rhs.get(i), c, this);
                        rhs.set(i, newSymbol);
                    }
                    ++i;
                }
                continue;
            }
            if (c.getType() != ContextType.DANGLING) continue;
            int i = 0;
            while (i < origProduction.arity()) {
                if (i == 0 && i == origProduction.leftRecursivePosition() || i == origProduction.arity() - 1 && i == origProduction.rightRecursivePosition()) {
                    ContextualSymbol newSymbol = rhs.get(i) instanceof ContextualSymbol ? ((ContextualSymbol)rhs.get(i)).addContext(c) : this.createContextualSymbol((Symbol)rhs.get(i), c, this);
                    rhs.set(i, newSymbol);
                }
                ++i;
            }
        }
        for (ISymbol s : rhs) {
            if (!(s instanceof ContextualSymbol)) continue;
            ContextualSymbol new_symbol = (ContextualSymbol)s;
            if (contextualSymbols == null || processedSymbols == null || processedSymbols.contains(new_symbol) || contextualSymbols.contains(new_symbol)) continue;
            contextualSymbols.add(new_symbol);
        }
        ArrayList contextualProductionFields = Lists.newArrayList((Object[])new Object[]{origProduction, lhs, origProductionLabel, this});
        contextualProductionFields.addAll(rhs);
        if (this.contextualProductions.containsKey(contextualProductionFields)) {
            return this.contextualProductions.get(contextualProductionFields);
        }
        ContextualProduction cp = new ContextualProduction(origProduction, lhs, rhs, origProductionLabel, this);
        this.contextualProductions.put(contextualProductionFields, cp);
        return cp;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Set<Context> contexts, ContextualFactory cf) {
        HashSet contextualSymbolFields = Sets.newHashSet((Object[])new Object[]{s});
        contextualSymbolFields.addAll(contexts);
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            for (Context context : contexts) {
                if (context.getType() != ContextType.DEEP && context.getType() != ContextType.DANGLING) continue;
                cs.setDeepContextBitmap(cs.deepContexts() | context.getContextBitmap());
            }
            return cs;
        }
        ContextualSymbol cs = new ContextualSymbol(s, contexts, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Context context, ContextualFactory cf) {
        HashSet contextualSymbolFields = Sets.newHashSet((Object[])new Object[]{s});
        contextualSymbolFields.add(context);
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            cs.setDeepContextBitmap(cs.deepContexts() | context.getContextBitmap());
            return this.contextualSymbols.get(contextualSymbolFields);
        }
        ContextualSymbol cs = new ContextualSymbol(s, context, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }

    public ContextualSymbol createContextualSymbol(Symbol s, Set<Context> contexts, long deepContextBitmap, ContextualFactory cf) {
        HashSet contextualSymbolFields = Sets.newHashSet((Object[])new Object[]{s});
        contextualSymbolFields.addAll(contexts);
        if (this.contextualSymbols.containsKey(contextualSymbolFields)) {
            ContextualSymbol cs = this.contextualSymbols.get(contextualSymbolFields);
            cs.setDeepContextBitmap(deepContextBitmap);
            return this.contextualSymbols.get(contextualSymbolFields);
        }
        ContextualSymbol cs = new ContextualSymbol(s, contexts, deepContextBitmap, this);
        this.contextualSymbols.put(contextualSymbolFields, cs);
        return cs;
    }
}

