/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.query;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.query.ActionsForRange;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.query.IActionsForCharacter;
import org.metaborg.parsetable.query.ParsingMode;

public final class ActionsForCharacterDisjointSorted
implements IActionsForCharacter,
Serializable {
    private static final long serialVersionUID = -619727965728365810L;
    private final ActionsForRange actionsForEOF;
    private final ActionsForRange[] actionsForSortedDisjointRanges;
    private final ActionsForRange[] recoveryActionsForSortedDisjointRanges;

    public ActionsForCharacterDisjointSorted(ActionsPerCharacterClass[] actionsPerCharacterClasses, Set<Integer> recoveryStateIds) {
        this.actionsForSortedDisjointRanges = ActionsForCharacterDisjointSorted.toDisjointSortedRanges(this.filterNonRecoveryActions(actionsPerCharacterClasses, recoveryStateIds));
        this.recoveryActionsForSortedDisjointRanges = ActionsForCharacterDisjointSorted.toDisjointSortedRanges(actionsPerCharacterClasses);
        this.actionsForEOF = new ActionsForRange(ActionsForCharacterDisjointSorted.getActionsForEOF(actionsPerCharacterClasses).toArray(new IAction[0]), -1, -1);
    }

    public static ActionsForRange[] toDisjointSortedRanges(ActionsPerCharacterClass[] actionsPerCharacterClasses) {
        int minIndex;
        ArrayList<ActionsForRange> actionsForRanges = new ArrayList<ActionsForRange>();
        int[][] ranges = new int[actionsPerCharacterClasses.length][];
        int i = 0;
        while (i < ranges.length) {
            ranges[i] = actionsPerCharacterClasses[i].characterClass.getRanges();
            ++i;
        }
        int[] indices = new int[ranges.length];
        HashMultiset newRangeActions = HashMultiset.create();
        int previous = 0;
        while ((minIndex = ActionsForCharacterDisjointSorted.getMinIndex(ranges, indices)) != -1) {
            int j;
            int n = minIndex;
            indices[n] = indices[n] + 1;
            int currChar = ranges[minIndex][j] + (j & 1);
            assert (currChar >= previous);
            if (currChar > previous) {
                if (!newRangeActions.isEmpty()) {
                    actionsForRanges.add(new ActionsForRange(newRangeActions.elementSet().toArray(new IAction[0]), previous, currChar - 1));
                }
                previous = currChar;
            }
            if ((j & 1) == 0) {
                newRangeActions.addAll(actionsPerCharacterClasses[minIndex].actions);
                continue;
            }
            Multisets.removeOccurrences((Multiset)newRangeActions, actionsPerCharacterClasses[minIndex].actions);
        }
        assert (newRangeActions.isEmpty());
        return actionsForRanges.toArray(new ActionsForRange[0]);
    }

    private static int getMinIndex(int[][] ranges, int[] indices) {
        int min2 = Integer.MAX_VALUE;
        int minIndex = -1;
        int i = 0;
        while (i < ranges.length) {
            int curr;
            int j = indices[i];
            if (j < ranges[i].length && (curr = ranges[i][j] + (j & 1)) < min2) {
                min2 = curr;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    private static Set<IAction> getActionsForEOF(ActionsPerCharacterClass[] actionsPerCharacterClasses) {
        HashSet<IAction> actionsForCharacter = new HashSet<IAction>();
        ActionsPerCharacterClass[] actionsPerCharacterClassArray = actionsPerCharacterClasses;
        int n = actionsPerCharacterClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ActionsPerCharacterClass actionsPerCharacterClass = actionsPerCharacterClassArray[n2];
            if (actionsPerCharacterClass.appliesTo(-1)) {
                actionsForCharacter.addAll(actionsPerCharacterClass.actions);
            }
            ++n2;
        }
        return actionsForCharacter;
    }

    @Override
    public IAction[] getActions() {
        ArrayList res = new ArrayList();
        ActionsForRange[] actionsForRangeArray = this.recoveryActionsForSortedDisjointRanges;
        int n = this.recoveryActionsForSortedDisjointRanges.length;
        int n2 = 0;
        while (n2 < n) {
            ActionsForRange actionsForRange = actionsForRangeArray[n2];
            Collections.addAll(res, actionsForRange.actions);
            ++n2;
        }
        Collections.addAll(res, this.actionsForEOF.actions);
        return res.toArray(new IAction[0]);
    }

    @Override
    public Iterable<IAction> getApplicableActions(IActionQuery actionQuery, ParsingMode parsingMode) {
        ActionsForRange[] actions;
        if (actionQuery.actionQueryCharacter() == -1) {
            return this.actionsForEOF.getApplicableActions(actionQuery);
        }
        ActionsForRange[] actionsForRangeArray = actions = parsingMode == ParsingMode.Recovery ? this.recoveryActionsForSortedDisjointRanges : this.actionsForSortedDisjointRanges;
        if (actions.length > 0) {
            int low = 0;
            int high = actions.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                ActionsForRange actionsForMidRange = actions[mid];
                int currentChar = actionQuery.actionQueryCharacter();
                if (actionsForMidRange.from <= currentChar && currentChar <= actionsForMidRange.to) {
                    return actionsForMidRange.getApplicableActions(actionQuery);
                }
                if (currentChar < actionsForMidRange.from) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<IReduce> getApplicableReduceActions(IActionQuery actionQuery, ParsingMode parsingMode) {
        ActionsForRange[] actions;
        if (actionQuery.actionQueryCharacter() == -1) {
            return this.actionsForEOF.getApplicableReduceActions(actionQuery);
        }
        ActionsForRange[] actionsForRangeArray = actions = parsingMode == ParsingMode.Recovery ? this.recoveryActionsForSortedDisjointRanges : this.actionsForSortedDisjointRanges;
        if (actions.length > 0) {
            int low = 0;
            int high = actions.length - 1;
            int currentChar = actionQuery.actionQueryCharacter();
            while (low <= high) {
                int mid = (low + high) / 2;
                ActionsForRange actionsForMidRange = actions[mid];
                if (actionsForMidRange.from <= currentChar && currentChar <= actionsForMidRange.to) {
                    return actionsForMidRange.getApplicableReduceActions(actionQuery);
                }
                if (currentChar < actionsForMidRange.from) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
        }
        return Collections.emptyList();
    }
}

