/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.syntax;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.syntax.IParser;
import org.metaborg.core.syntax.ISyntaxService;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.core.syntax.ParseFacet;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public abstract class SyntaxService<I extends IInputUnit, P extends IParseUnit>
implements ISyntaxService<I, P> {
    private static final ILogger logger = LoggerUtils.logger(SyntaxService.class);
    protected final Map<String, ? extends IParser<I, P>> parsers;

    @Inject
    public SyntaxService(Map<String, ? extends IParser<I, P>> parsers) {
        this.parsers = parsers;
    }

    @Override
    public boolean available(ILanguageImpl langImpl) {
        return this.parser(langImpl) != null;
    }

    @Override
    public P parse(I input, IProgress progress, ICancel cancel) throws ParseException, InterruptedException {
        ILanguageImpl langImpl = input.langImpl();
        IParser<I, P> parser = this.parser(langImpl);
        if (parser == null) {
            String message = logger.format("Cannot get a parser for {}", langImpl);
            throw new ParseException((IInputUnit)input, message);
        }
        return parser.parse(input, progress, cancel);
    }

    @Override
    public Collection<P> parseAll(Iterable<I> inputs, IProgress progress, ICancel cancel) throws ParseException, InterruptedException {
        ArrayList results = Lists.newArrayList();
        for (IInputUnit input : inputs) {
            results.add(this.parse(input, progress, cancel));
        }
        return results;
    }

    private IParser<I, P> parser(ILanguageImpl language) {
        ParseFacet facet = language.facet(ParseFacet.class);
        if (facet == null) {
            return null;
        }
        return this.parsers.get(facet.type);
    }
}

