/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.core.resource.ResourceChangeKind;
import org.metaborg.util.iterators.Iterables2;

public class ResourceUtils {
    public static Iterable<FileObject> find(FileObject base, FileSelector selector) throws FileSystemException {
        FileObject[] files = base.findFiles(selector);
        if (files == null) {
            return Iterables2.empty();
        }
        return Iterables2.from(files);
    }

    public static Iterable<FileObject> find(FileObject base) throws FileSystemException {
        return ResourceUtils.find(base, (FileSelector)new AllFileSelector());
    }

    public static Iterable<ResourceChange> toChanges(Iterable<FileObject> resources, ResourceChangeKind kind) {
        int size = Iterables.size(resources);
        ArrayList changes = Lists.newArrayListWithCapacity((int)size);
        for (FileObject resource : resources) {
            changes.add(new ResourceChange(resource, kind));
        }
        return changes;
    }
}

