/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.IMessagePrinter;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.source.AffectedSourceHelper;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.source.ISourceTextService;

public class WithLocationStreamMessagePrinter
implements IMessagePrinter {
    private final ISourceTextService sourceTextService;
    private final IProjectService projectService;
    private final PrintStream outputStream;

    public WithLocationStreamMessagePrinter(ISourceTextService sourceTextService, IProjectService projectService, OutputStream outputStream) {
        this.sourceTextService = sourceTextService;
        this.projectService = projectService;
        this.outputStream = new PrintStream(outputStream);
    }

    @Override
    public void print(IMessage message, boolean pardoned) {
        this.print(message.message(), pardoned, message.source(), message.severity(), message.region());
    }

    @Override
    public void print(@Nullable FileObject resource, String message, Throwable e, boolean pardoned) {
        this.print(message, pardoned, resource, null, null);
    }

    @Override
    public void print(IProject project, String message, Throwable e, boolean pardoned) {
        this.print(message, pardoned, null, null, null);
    }

    @Override
    public void printSummary() {
    }

    private void print(String message, boolean pardoned, @Nullable FileObject sourceFile, @Nullable MessageSeverity severity, @Nullable ISourceRegion sourceRegion) {
        if (pardoned) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (sourceFile != null) {
            try {
                IProject project = this.projectService.get(sourceFile);
                String relativeSourceFilename = sourceFile.getName().getBaseName();
                if (project != null && project.location().getName() != sourceFile.getName()) {
                    relativeSourceFilename = project.location().getName().getRelativeName(sourceFile.getName());
                }
                sb.append(relativeSourceFilename);
                sb.append(':');
                if (sourceRegion != null && sourceRegion.startRow() != -1 && sourceRegion.startColumn() != -1) {
                    sb.append(sourceRegion.startRow() + 1);
                    sb.append(':');
                    sb.append(sourceRegion.startColumn() + 1);
                    sb.append(':');
                }
                sb.append(' ');
            }
            catch (FileSystemException project) {
                // empty catch block
            }
        }
        if (severity != null) {
            sb.append(severity.name().toLowerCase());
            sb.append(": ");
        }
        sb.append(message);
        sb.append('\n');
        if (sourceFile != null && sourceRegion != null) {
            try {
                String affectedSource = AffectedSourceHelper.affectedSourceText(sourceRegion, this.sourceTextService.text(sourceFile), " ");
                if (affectedSource != null) {
                    sb.append(affectedSource);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.outputStream.print(sb.toString());
        this.outputStream.flush();
    }
}

