/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build.dependency;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.metaborg.core.build.dependency.IDependencyService;
import org.metaborg.core.build.dependency.MissingDependencies;
import org.metaborg.core.build.dependency.MissingDependencyException;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.LanguageUtils;
import org.metaborg.core.project.IProject;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public final class DefaultDependencyService
implements IDependencyService {
    private static final ILogger logger = LoggerUtils.logger(DefaultDependencyService.class);
    private final ILanguageService languageService;

    @Inject
    public DefaultDependencyService(ILanguageService languageService) {
        this.languageService = languageService;
    }

    @Override
    public Collection<ILanguageComponent> compileDeps(IProject project) throws MissingDependencyException {
        IProjectConfig config = project.config();
        if (config.compileDeps().isEmpty()) {
            logger.trace("No compile dependencies found for project '{}'.Returning all active language components as compile dependencies instead.", project);
            return ImmutableList.copyOf(LanguageUtils.allActiveComponents(this.languageService));
        }
        return this.getLanguages(config.compileDeps());
    }

    @Override
    public Collection<ILanguageComponent> sourceDeps(IProject project) throws MissingDependencyException {
        IProjectConfig config = project.config();
        if (config.sourceDeps().isEmpty()) {
            return Collections.emptyList();
        }
        return this.getLanguages(config.sourceDeps());
    }

    @Override
    public Collection<ILanguageComponent> sourceDeps(ILanguageComponent component) throws MissingDependencyException {
        return this.getLanguages(component.config().sourceDeps());
    }

    @Override
    public MissingDependencies checkDependencies(IProject project) {
        IProjectConfig config = project.config();
        Collection<LanguageIdentifier> compileDeps = config.compileDeps();
        LinkedList missingCompile = Lists.newLinkedList();
        for (LanguageIdentifier identifier : compileDeps) {
            if (this.languageService.getComponent(identifier) != null) continue;
            missingCompile.add(identifier);
        }
        Collection<LanguageIdentifier> sourceDeps = config.sourceDeps();
        LinkedList missingSource = Lists.newLinkedList();
        for (LanguageIdentifier identifier : sourceDeps) {
            if (this.languageService.getComponent(identifier) != null) continue;
            missingSource.add(identifier);
        }
        return new MissingDependencies(missingCompile, missingSource);
    }

    private Collection<ILanguageComponent> getLanguages(Iterable<LanguageIdentifier> ids) throws MissingDependencyException {
        LinkedList components = Lists.newLinkedList();
        for (LanguageIdentifier id : ids) {
            ILanguageComponent component = this.languageService.getComponent(id);
            if (component == null) {
                throw new MissingDependencyException(logger.format("Language for dependency {} does not exist", id));
            }
            components.add(component);
        }
        return components;
    }
}

