/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.solver.ACriticalEdge;

public final class CriticalEdge
extends ACriticalEdge
implements Serializable {
    private final ITerm scope;
    private final EdgeOrData<ITerm> edgeOrData;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private CriticalEdge(ITerm scope, EdgeOrData<ITerm> edgeOrData) {
        this.scope = Objects.requireNonNull(scope, "scope");
        this.edgeOrData = Objects.requireNonNull(edgeOrData, "edgeOrData");
    }

    private CriticalEdge(CriticalEdge original, ITerm scope, EdgeOrData<ITerm> edgeOrData) {
        this.scope = scope;
        this.edgeOrData = edgeOrData;
    }

    @Override
    public ITerm scope() {
        return this.scope;
    }

    @Override
    public EdgeOrData<ITerm> edgeOrData() {
        return this.edgeOrData;
    }

    public final CriticalEdge withScope(ITerm value) {
        if (this.scope == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "scope");
        return new CriticalEdge(this, newValue, this.edgeOrData);
    }

    public final CriticalEdge withEdgeOrData(EdgeOrData<ITerm> value) {
        if (this.edgeOrData == value) {
            return this;
        }
        EdgeOrData<ITerm> newValue = Objects.requireNonNull(value, "edgeOrData");
        return new CriticalEdge(this, this.scope, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CriticalEdge && this.equalTo((CriticalEdge)another);
    }

    private boolean equalTo(CriticalEdge another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.scope.equals(another.scope) && this.edgeOrData.equals(another.edgeOrData);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.edgeOrData.hashCode();
        return h;
    }

    public static CriticalEdge of(ITerm scope, EdgeOrData<ITerm> edgeOrData) {
        return new CriticalEdge(scope, edgeOrData);
    }

    public static CriticalEdge copyOf(ACriticalEdge instance) {
        if (instance instanceof CriticalEdge) {
            return (CriticalEdge)instance;
        }
        return CriticalEdge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CriticalEdge(CriticalEdge criticalEdge, ITerm iTerm, EdgeOrData edgeOrData, CriticalEdge criticalEdge2) {
        this(criticalEdge, iTerm, edgeOrData);
    }

    public static final class Builder {
        private static final long INIT_BIT_SCOPE = 1L;
        private static final long INIT_BIT_EDGE_OR_DATA = 2L;
        private long initBits = 3L;
        private ITerm scope;
        private EdgeOrData<ITerm> edgeOrData;

        private Builder() {
        }

        public final Builder from(ACriticalEdge instance) {
            Objects.requireNonNull(instance, "instance");
            this.scope(instance.scope());
            this.edgeOrData(instance.edgeOrData());
            return this;
        }

        public final Builder scope(ITerm scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder edgeOrData(EdgeOrData<ITerm> edgeOrData) {
            this.edgeOrData = Objects.requireNonNull(edgeOrData, "edgeOrData");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CriticalEdge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CriticalEdge(null, this.scope, this.edgeOrData, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("edgeOrData");
            }
            return "Cannot build CriticalEdge, some of required attributes are not set " + attributes;
        }
    }
}

