/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CNew
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm scopeTerm;
    private final ITerm datumTerm;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final ICompleteness.Immutable ownCriticalEdges;
    private volatile int hashCode;

    public CNew(ITerm scopeTerm, ITerm datumTerm) {
        this(scopeTerm, datumTerm, null, null);
    }

    public CNew(ITerm scopeTerm, ITerm datumTerm, @Nullable IConstraint cause, @Nullable ICompleteness.Immutable ownCriticalEdges) {
        this.scopeTerm = scopeTerm;
        this.datumTerm = datumTerm;
        this.cause = cause;
        this.ownCriticalEdges = ownCriticalEdges;
    }

    public ITerm scopeTerm() {
        return this.scopeTerm;
    }

    public ITerm datumTerm() {
        return this.datumTerm;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseNew(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseNew(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.scopeTerm.getVars(), this.datumTerm.getVars());
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CNew withCause(@Nullable IConstraint cause) {
        return new CNew(this.scopeTerm, this.datumTerm, cause, this.ownCriticalEdges);
    }

    @Override
    public Optional<ICompleteness.Immutable> ownCriticalEdges() {
        return Optional.ofNullable(this.ownCriticalEdges);
    }

    @Override
    public CNew withOwnCriticalEdges(ICompleteness.Immutable criticalEdges) {
        return new CNew(this.scopeTerm, this.datumTerm, this.cause, criticalEdges);
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.scopeTerm.getVars().stream().forEach(onFreeVar::apply);
        this.datumTerm.getVars().stream().forEach(onFreeVar::apply);
    }

    @Override
    public CNew apply(ISubstitution.Immutable subst) {
        return new CNew(subst.apply(this.scopeTerm), subst.apply(this.datumTerm), this.cause, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CNew unsafeApply(ISubstitution.Immutable subst) {
        return new CNew(subst.apply(this.scopeTerm), subst.apply(this.datumTerm), this.cause, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CNew apply(IRenaming subst) {
        return new CNew(subst.apply(this.scopeTerm), subst.apply(this.datumTerm), this.cause, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("new ");
        sb.append(termToString.format(this.scopeTerm));
        sb.append(" : ");
        sb.append(termToString.format(this.datumTerm));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CNew cNew = (CNew)o;
        return Objects.equals(this.scopeTerm, cNew.scopeTerm) && Objects.equals(this.datumTerm, cNew.datumTerm) && Objects.equals(this.cause, cNew.cause);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.scopeTerm, this.datumTerm, this.cause);
        }
        return result;
    }
}

