/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.scopegraph.resolution.RStep;
import mb.scopegraph.resolution.RVar;

public class State<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<RStep<L>> resolutionSteps;
    private final RVar resultVar;
    private final boolean accepting;
    private final ImmutableMap<L, String> transitions;
    private volatile int hashCode;

    public State(Iterable<RStep<L>> resolutionSteps, RVar resultVar, boolean accepting, Map<L, String> transitions) {
        this.resolutionSteps = ImmutableList.copyOf(resolutionSteps);
        this.resultVar = resultVar;
        this.accepting = accepting;
        this.transitions = ImmutableMap.copyOf(transitions);
    }

    public ImmutableList<RStep<L>> resolutionSteps() {
        return this.resolutionSteps;
    }

    public RVar resultVar() {
        return this.resultVar;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    @Nullable
    public String transitionStateId(L label) {
        return (String)this.transitions.get(label);
    }

    public String toString() {
        return "StateMachine{resolutionSteps=" + this.resolutionSteps + ", resultVar=" + this.resultVar + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        State other = (State)obj;
        return Objects.equals(this.resolutionSteps, other.resolutionSteps) && Objects.equals(this.resultVar, other.resultVar);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.resolutionSteps, this.resultVar);
        }
        return result;
    }
}

