/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.patching;

import com.google.common.collect.Sets;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.patching.IdentityMappingEntrySet;
import mb.scopegraph.patching.InvalidPatchCompositionException;
import org.metaborg.util.RefBool;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public abstract class PatchCollection<S>
implements IPatchCollection<S> {
    private static final ILogger logger = LoggerUtils.logger(PatchCollection.class);
    private volatile int hashCode = 0;

    @Override
    public Set<Map.Entry<S, S>> allPatches() {
        return Sets.union(this.patches().entrySet(), new IdentityMappingEntrySet(this.identityPatches()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        PatchCollection other = (PatchCollection)obj;
        return Objects.equals(this.identityPatches(), other.identityPatches()) && Objects.equals(this.patches(), other.patches());
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == -1) {
            result = 11;
            result += 31 * this.identityPatches().hashCode();
            this.hashCode = result += 37 * this.patches().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        RefBool first = new RefBool(true);
        this.patches().asMap().forEach((newScope, oldScope) -> {
            if (!first.get()) {
                sb.append(", ");
            }
            sb.append(newScope);
            sb.append(" <-| ");
            sb.append(oldScope);
            first.set(false);
        });
        this.identityPatches().forEach(scope -> {
            if (!first.get()) {
                sb.append(", ");
            }
            sb.append(scope);
            sb.append(" <-| ");
            sb.append(scope);
            first.set(false);
        });
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void assertConsistent() throws InvalidPatchCompositionException {
        PatchCollection.checkInvalidIdentities(this.identityPatches(), this.patchDomain());
        PatchCollection.checkInvalidIdentities(this.identityPatches(), this.patchRange());
    }

    private static <S> void throwInvalidNewPatch(S newScope, S oldScope, S existingOldScope) throws InvalidPatchCompositionException {
        throw new InvalidPatchCompositionException("Cannot insert patch " + oldScope + " |-> " + newScope + ". " + newScope + " already patched by " + existingOldScope + ".");
    }

    private static <S> void throwInvalidOldPatch(S newScope, S oldScope, S existingNewScope) throws InvalidPatchCompositionException {
        throw new InvalidPatchCompositionException("Cannot insert patch " + oldScope + " |-> " + newScope + ". " + oldScope + " already patching to " + existingNewScope + ".");
    }

    private static <S> void checkInvalidIdentities(Set<S> identities, Set<S> nonIdentities) throws InvalidPatchCompositionException {
        Sets.SetView conflicts = Sets.intersection(nonIdentities, identities);
        if (!conflicts.isEmpty()) {
            throw new InvalidPatchCompositionException("Match conflict for " + conflicts + ".");
        }
    }

    public static class Immutable<S>
    extends PatchCollection<S>
    implements IPatchCollection.Immutable<S> {
        private static final Immutable EMPTY = new Immutable(BiMap.Immutable.of(), Set.Immutable.of());
        private final BiMap.Immutable<S> patches;
        private final Set.Immutable<S> identityPatches;

        public Immutable(BiMap.Immutable<S> patches, Set.Immutable<S> identityPatches) {
            this.patches = patches;
            this.identityPatches = identityPatches;
        }

        @Override
        public boolean isEmpty() {
            return this.patches.isEmpty() && this.identityPatches.isEmpty();
        }

        @Override
        public boolean isIdentity() {
            return this.patches.isEmpty();
        }

        @Override
        public boolean isIdentity(S oldScope) {
            return !this.patches.containsValue(oldScope);
        }

        @Override
        public S patch(S oldScope) {
            if (this.isIdentity()) {
                return oldScope;
            }
            S result = this.patches.getValue(oldScope);
            if (result != null) {
                return result;
            }
            S otherSrc = this.patches.getKey(oldScope);
            if (otherSrc != null) {
                logger.warn("Suspicious patch application. Applying implicit identity match to {}, but that scope is also matched to by {}.", oldScope, otherSrc);
            }
            return oldScope;
        }

        @Override
        public Transient<S> melt() {
            return new Transient<S>(this.patches.melt(), this.identityPatches.asTransient());
        }

        @Override
        public BiMap.Immutable<S> patches() {
            return this.patches;
        }

        @Override
        public Set<S> identityPatches() {
            return this.identityPatches;
        }

        @Override
        public Immutable<S> put(S newScope, S oldScope) throws InvalidPatchCompositionException {
            IPatchCollection.Transient _patches = this.melt();
            if (!((Transient)_patches).put(newScope, oldScope)) {
                return this;
            }
            return ((Transient)_patches).freeze();
        }

        @Override
        public Immutable<S> putAll(Map<S, S> patches) throws InvalidPatchCompositionException {
            return this.putAll(patches.entrySet());
        }

        @Override
        public Immutable<S> putAll(Collection<? extends Map.Entry<S, S>> patches) throws InvalidPatchCompositionException {
            if (patches.isEmpty()) {
                return this;
            }
            IPatchCollection.Transient _patches = this.melt();
            if (!((Transient)_patches).putAll(patches)) {
                return this;
            }
            return ((Transient)_patches).freeze();
        }

        private Immutable<S> putAllUnchecked(Collection<Map.Entry<S, S>> patches) throws InvalidPatchCompositionException {
            if (patches.isEmpty()) {
                return this;
            }
            IPatchCollection.Transient _patches = this.melt();
            if (!((Transient)_patches).putAllUnchecked(patches)) {
                return this;
            }
            return ((Transient)_patches).freeze();
        }

        @Override
        public Immutable<S> putAll(IPatchCollection<S> patches) throws InvalidPatchCompositionException {
            if (patches.isEmpty()) {
                return this;
            }
            IPatchCollection.Transient _patches = this.melt();
            if (!((Transient)_patches).putAll(patches)) {
                return this;
            }
            return ((Transient)_patches).freeze();
        }

        @Override
        public Set<S> patchDomain() {
            return this.patches.valueSet();
        }

        @Override
        public Set<S> patchRange() {
            return this.patches.keySet();
        }

        public static <S> Immutable<S> of() {
            return EMPTY;
        }

        public static <S> Immutable<S> of(BiMap<S> patches) {
            return EMPTY.putAllUnchecked(patches.entrySet());
        }
    }

    public static class Transient<S>
    extends PatchCollection<S>
    implements IPatchCollection.Transient<S> {
        private BiMap.Transient<S> patches;
        private final Set.Transient<S> identityPatches;

        public Transient(BiMap.Transient<S> patches, Set.Transient<S> identityPatches) {
            this.identityPatches = identityPatches;
            this.patches = patches;
        }

        @Override
        public boolean isEmpty() {
            return this.patches.isEmpty() && this.identityPatches.isEmpty();
        }

        @Override
        public boolean isIdentity() {
            return this.patches.isEmpty();
        }

        @Override
        public boolean isIdentity(S oldScope) {
            return !this.patches.containsValue(oldScope);
        }

        @Override
        public S patch(S oldScope) {
            if (this.isIdentity()) {
                return oldScope;
            }
            S result = this.patches.getValue(oldScope);
            if (result != null) {
                return result;
            }
            S otherSrc = this.patches.getKey(oldScope);
            if (otherSrc != null) {
                logger.warn("Suspicious patch application. Applying implicit identity match to {}, but that scope is also matched to by {}.", oldScope, otherSrc);
            }
            return oldScope;
        }

        @Override
        public Immutable<S> freeze() {
            return new Immutable<S>(this.patches(), this.identityPatches.freeze());
        }

        @Override
        public BiMap.Immutable<S> patches() {
            BiMap.Immutable<S> currentPatches = this.patches.freeze();
            this.patches = currentPatches.melt();
            return currentPatches;
        }

        @Override
        public Set<S> identityPatches() {
            return this.identityPatches;
        }

        @Override
        public boolean put(S newScope, S oldScope) throws InvalidPatchCompositionException {
            if (this.patches.containsEntry(newScope, oldScope)) {
                return false;
            }
            if (this.patches.containsKey(newScope)) {
                PatchCollection.throwInvalidNewPatch(newScope, oldScope, this.patches.getKey(newScope));
            }
            if (this.patches.containsValue(oldScope)) {
                PatchCollection.throwInvalidOldPatch(newScope, oldScope, this.patches.getValue(oldScope));
            }
            if (oldScope.equals(newScope)) {
                return this.identityPatches.__insert(newScope);
            }
            if (this.identityPatches.contains(newScope)) {
                PatchCollection.throwInvalidNewPatch(newScope, oldScope, this.identityPatches.get(newScope));
            }
            if (this.identityPatches.contains(oldScope)) {
                PatchCollection.throwInvalidOldPatch(newScope, oldScope, this.identityPatches.get(oldScope));
            }
            return this.patches.put(newScope, oldScope);
        }

        private boolean putUnchecked(S oldScope, S newScope) {
            if (oldScope.equals(newScope)) {
                return this.identityPatches.__insert(oldScope);
            }
            return this.patches.put(newScope, oldScope);
        }

        @Override
        public boolean putAll(Map<S, S> patches) throws InvalidPatchCompositionException {
            return this.putAll(patches.entrySet());
        }

        @Override
        public boolean putAll(Collection<? extends Map.Entry<S, S>> patches) throws InvalidPatchCompositionException {
            boolean changed = false;
            for (Map.Entry<S, S> entry : patches) {
                changed |= this.put(entry.getKey(), entry.getValue());
            }
            return changed;
        }

        private boolean putAllUnchecked(Collection<Map.Entry<S, S>> patches) throws InvalidPatchCompositionException {
            boolean changed = false;
            for (Map.Entry<S, S> entry : patches) {
                changed |= this.putUnchecked(entry.getValue(), entry.getKey());
            }
            return changed;
        }

        @Override
        public boolean putAll(IPatchCollection<S> patches) throws InvalidPatchCompositionException {
            boolean changed = this.identityPatches.__insertAll(patches.identityPatches());
            return changed |= this.patches.putAll(patches.patches().entrySet());
        }

        @Override
        public Set<S> patchDomain() {
            return this.patches.valueSet();
        }

        @Override
        public Set<S> patchRange() {
            return this.patches.keySet();
        }

        public static <S> Transient<S> of() {
            return new Transient(BiMap.Transient.of(), Set.Transient.of());
        }
    }
}

