/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.stamp.resource;

import java.io.IOException;
import java.util.Objects;
import mb.pie.api.stamp.ResourceStamper;
import mb.pie.api.stamp.resource.ByteArrayResourceStamp;
import mb.pie.api.stamp.resource.Hash;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.match.ResourceMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HashMatchResourceStamper
implements ResourceStamper<HierarchicalResource> {
    private final @Nullable ResourceMatcher matcher;

    public HashMatchResourceStamper(ResourceMatcher matcher) {
        this.matcher = matcher;
    }

    public HashMatchResourceStamper() {
        this.matcher = null;
    }

    @Override
    public ByteArrayResourceStamp<HierarchicalResource> stamp(HierarchicalResource resource) throws IOException {
        Hash hasher = new Hash();
        hasher.update(resource, this.matcher);
        byte[] bytes = hasher.getHashBytesAndReset();
        return new ByteArrayResourceStamp<HierarchicalResource>(bytes, this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashMatchResourceStamper that = (HashMatchResourceStamper)o;
        return Objects.equals(this.matcher, that.matcher);
    }

    public int hashCode() {
        return this.matcher != null ? this.matcher.hashCode() : 0;
    }

    public String toString() {
        return "HashMatchResourceStamper(" + this.matcher + ")";
    }
}

