/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import java.util.Objects;
import mb.pie.api.OutTransientEquatable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OutTransientEquatableImpl<T, E extends @Nullable Serializable>
implements OutTransientEquatable<T, E> {
    private final transient T value;
    private final E equatable;
    private final transient boolean consistent;

    public OutTransientEquatableImpl(T value, E equatable, boolean consistent) {
        this.value = value;
        this.equatable = equatable;
        this.consistent = consistent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public E getEquatableValue() {
        return this.equatable;
    }

    @Override
    public boolean isConsistent() {
        return this.consistent;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutTransientEquatableImpl that = (OutTransientEquatableImpl)o;
        if (this.consistent != that.consistent) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.equatable, that.equatable);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.equatable != null ? this.equatable.hashCode() : 0);
        result = 31 * result + (this.consistent ? 1 : 0);
        return result;
    }

    public String toString() {
        return "OutTransientEquatableImpl{value=" + this.value + ", equatable=" + this.equatable + ", consistent=" + this.consistent + '}';
    }
}

