/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.AUnitAdd;
import org.metaborg.util.future.ICompletableFuture;

public final class UnitAdd<S, L, D>
extends AUnitAdd<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final String unitId;
    private final ICompletableFuture<?> future;

    private UnitAdd(IActorRef<? extends IUnit<S, L, D, ?>> origin, String unitId, ICompletableFuture<?> future) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.unitId = Objects.requireNonNull(unitId, "unitId");
        this.future = Objects.requireNonNull(future, "future");
    }

    private UnitAdd(UnitAdd<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, String unitId, ICompletableFuture<?> future) {
        this.origin = origin;
        this.unitId = unitId;
        this.future = future;
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public String unitId() {
        return this.unitId;
    }

    @Override
    public ICompletableFuture<?> future() {
        return this.future;
    }

    public final UnitAdd<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new UnitAdd<S, L, D>(this, newValue, this.unitId, this.future);
    }

    public final UnitAdd<S, L, D> withUnitId(String value) {
        String newValue = Objects.requireNonNull(value, "unitId");
        if (this.unitId.equals(newValue)) {
            return this;
        }
        return new UnitAdd<S, L, D>(this, this.origin, newValue, this.future);
    }

    public final UnitAdd<S, L, D> withFuture(ICompletableFuture<?> value) {
        if (this.future == value) {
            return this;
        }
        ICompletableFuture<?> newValue = Objects.requireNonNull(value, "future");
        return new UnitAdd<S, L, D>(this, this.origin, this.unitId, newValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnitAdd").omitNullValues().add("origin", this.origin).add("unitId", (Object)this.unitId).add("future", this.future).toString();
    }

    public static <S, L, D> UnitAdd<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, String unitId, ICompletableFuture<?> future) {
        return new UnitAdd<S, L, D>(origin, unitId, future);
    }

    public static <S, L, D> UnitAdd<S, L, D> copyOf(AUnitAdd<S, L, D> instance) {
        if (instance instanceof UnitAdd) {
            return (UnitAdd)instance;
        }
        return UnitAdd.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ UnitAdd(UnitAdd unitAdd, IActorRef iActorRef, String string, ICompletableFuture iCompletableFuture, UnitAdd unitAdd2) {
        this(unitAdd, iActorRef, string, iCompletableFuture);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_UNIT_ID = 2L;
        private static final long INIT_BIT_FUTURE = 4L;
        private long initBits = 7L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private String unitId;
        private ICompletableFuture<?> future;

        private Builder() {
        }

        public final Builder<S, L, D> from(AUnitAdd<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.unitId(instance.unitId());
            this.future(instance.future());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> unitId(String unitId) {
            this.unitId = Objects.requireNonNull(unitId, "unitId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L, D> future(ICompletableFuture<?> future) {
            this.future = Objects.requireNonNull(future, "future");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public UnitAdd<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UnitAdd(null, this.origin, this.unitId, this.future, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("unitId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("future");
            }
            return "Cannot build UnitAdd, some of required attributes are not set " + attributes;
        }
    }
}

