/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.primitives;

import com.google.common.collect.ImmutableList;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mb.nabl2.constraints.Constraints;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.solvers.BaseSolution;
import mb.nabl2.solver.solvers.GraphSolution;
import mb.nabl2.solver.solvers.SemiIncrementalMultiFileSolver;
import mb.nabl2.spoofax.analysis.MultiInitialResult;
import mb.nabl2.spoofax.primitives.ScopeGraphMultiFileAnalysisPrimitive;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.Transform;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.InterpreterException;

public class SG_solve_multi_initial_constraint
extends ScopeGraphMultiFileAnalysisPrimitive {
    private static ILogger logger = LoggerUtils.logger(SG_solve_multi_initial_constraint.class);

    public SG_solve_multi_initial_constraint() {
        super(SG_solve_multi_initial_constraint.class.getSimpleName(), 1);
    }

    @Override
    protected Optional<? extends ITerm> call(ITerm currentTerm, List<ITerm> argTerms, SemiIncrementalMultiFileSolver solver, ICancel cancel, IProgress progress) throws InterpreterException {
        ISolution solution;
        SolverConfig solverConfig = SolverConfig.matcher().match(argTerms.get(0)).orElseThrow(() -> new InterpreterException("Term argument is not a solver config."));
        Tuple2 input = TermMatch.M.tuple2(TermMatch.M.term(), Constraints.matchConstraintOrList(), (t, params, C2) -> Tuple2.of(params, C2)).match(currentTerm).orElseThrow(() -> new InterpreterException("Current term is not (params, C)."));
        ITerm params2 = (ITerm)input._1();
        ImmutableList constraints = ImmutableList.of((Object)((IConstraint)input._2()));
        Set.Immutable<ITermVar> globalVars = params2.getVars();
        Fresh.Transient globalFresh = Fresh.Transient.of();
        try {
            BaseSolution baseSolution = BaseSolution.of(solverConfig, (Iterable<? extends IConstraint>)constraints, (IUnifier.Immutable)Unifiers.Immutable.of());
            GraphSolution preSolution = solver.solveGraph(baseSolution, globalFresh::fresh, cancel, progress);
            solution = solver.solveIntra(preSolution, (Iterable<ITermVar>)globalVars, null, globalFresh::fresh, cancel, progress);
        }
        catch (InterruptedException | SolverException ex) {
            throw new InterpreterException(ex);
        }
        Collection globalScopes = Transform.T.collecttd(t -> Scope.matcher().match((ITerm)t, solution.unifier())).apply(params2);
        MultiInitialResult result = MultiInitialResult.of((Iterable<? extends IConstraint>)constraints, solution, Optional.empty(), globalVars, globalScopes, globalFresh.freeze());
        return Optional.of(TermBuild.B.newBlob(result));
    }
}

