/*
 * Decompiled with CFR 0.152.
 */
package mb.log.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import mb.log.api.Level;
import mb.log.api.Logger;

public class LoggingOutputStream
extends OutputStream {
    private static final int initialBufferLength = 2048;
    private final Logger logger;
    private final Level level;
    private final Pattern[] excludePatterns;
    private boolean closed = false;
    private byte[] buffer;
    private int count;

    public LoggingOutputStream(Logger logger, Level level, String ... excludePatterns) throws IllegalArgumentException {
        this.level = level;
        this.logger = logger;
        this.excludePatterns = new Pattern[excludePatterns.length];
        for (int i = 0; i < excludePatterns.length; ++i) {
            this.excludePatterns[i] = Pattern.compile(excludePatterns[i], 32);
        }
        this.buffer = new byte[2048];
        this.count = 0;
    }

    @Override
    public void close() {
        this.flush();
        this.closed = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("The stream has been closed");
        }
        switch (b) {
            case 10: {
                this.doFlush();
                return;
            }
            case 0: 
            case 13: {
                return;
            }
        }
        if (this.count == this.buffer.length) {
            int newBufLength = this.buffer.length + 2048;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buffer, 0, newBuf, 0, this.buffer.length);
            this.buffer = newBuf;
        }
        this.buffer[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        try {
            String message = new String(this.buffer, 0, this.count);
            for (Pattern pattern : this.excludePatterns) {
                if (!pattern.matcher(message).matches()) continue;
                return;
            }
            this.logger.log(this.level, message);
        }
        finally {
            this.count = 0;
        }
    }
}

