/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.NotNode;

@GeneratedBy(value=NotNode.class)
public final class NotNodeGen
extends NotNode {
    @Node.Child
    private ExpressionNode expr_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private NotNodeGen(ExpressionNode expr) {
        this.expr_ = expr;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 2) == 0 && state != 0) {
            return this.executeBoolean_boolean0(frameValue, state);
        }
        return this.executeBoolean_generic1(frameValue, state);
    }

    private boolean executeBoolean_boolean0(VirtualFrame frameValue, int state) {
        boolean exprValue_;
        try {
            exprValue_ = this.expr_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.plus(exprValue_);
    }

    private boolean executeBoolean_generic1(VirtualFrame frameValue, int state) {
        Object exprValue_ = this.expr_.executeGeneric(frameValue);
        if ((state & 1) != 0 && exprValue_ instanceof Boolean) {
            boolean exprValue__ = (Boolean)exprValue_;
            return this.plus(exprValue__);
        }
        if ((state & 2) != 0) {
            return this.plus(exprValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(exprValue_);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return this.executeBoolean(frameValue);
    }

    private boolean executeAndSpecialize(Object exprValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (exprValue instanceof Boolean) {
                boolean exprValue_ = (Boolean)exprValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.plus(exprValue_);
                return bl;
            }
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.plus(exprValue);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static NotNode create(ExpressionNode expr) {
        return new NotNodeGen(expr);
    }
}

