/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.Objects;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.TermEqualityUtil;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right")})
public abstract class EqualNode
extends ExpressionNode {
    @Specialization
    protected boolean equal(int left, int right) {
        return left == right;
    }

    @Specialization
    protected boolean equal(boolean left, boolean right) {
        return left == right;
    }

    @Specialization
    protected boolean equal(String left, String right) {
        return Objects.equals(left, right);
    }

    @Specialization
    protected boolean equal(IStrategoTerm left, IStrategoTerm right) {
        return TermEqualityUtil.equalsIgnoreAnnos(left, right, null);
    }

    @Specialization(guards={"left.getClass() != right.getClass()"})
    protected boolean equal(Object left, Object right) {
        assert (!left.equals(right));
        return false;
    }
}

