/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import oracle.pg.rdbms.internal.onprem.GraphRealmClient;
import oracle.pg.rdbms.internal.onprem.GraphServerClient;
import oracle.pg.rdbms.internal.onprem.TokenResponse;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.common.UserContext;
import oracle.pgx.common.VersionInfo;
import oracle.pgx.common.util.StringUtils;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.realm.client.RealmClient;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.classic.HttpClients;

public class GraphServer {
    public static final int DEFAULT_TIME_BEFORE_EXPIRY = 1800;
    public static final int NON_CUSTOM_VALUE_FROM_USER = -1;
    public static final String PRODUCT_DISTRIBUTION_KEY = "distribution";
    public static final String SOMBRERO_VERSION_KEY = "sombrero_version";
    private static final String PRODUCT_VERSION_LOCATION = "classpath:/META-INF/product_version.properties";
    private static final String GVT_VERSION_KEY = "gvt_version";
    private static final String PGQL_VERSION_KEY = "pgql_version";
    private static final String PGQL_ON_RDBMS_VERSION_KEY = "pgql_on_rdbms_version";
    private static GraphServerClient CLIENT = null;

    private static GraphServerClient getClient() {
        if (CLIENT == null) {
            CLIENT = new GraphServerClient((HttpClient)HttpClients.createDefault());
        }
        return CLIENT;
    }

    private GraphServer() {
    }

    public static ServerInstance getEmbeddedInstance() {
        return GraphServer.addVersionInfo(Pgx.getInstance((String)Pgx.EMBEDDED_URL));
    }

    public static ServerInstance getInstance(ClientConfig clientConfig, String username, char[] password) throws IOException {
        return GraphServer.getInstance(clientConfig, username, password, -1);
    }

    @Deprecated
    public static ServerInstance getInstance(ClientConfig clientConfig, String username, char[] password, int refreshTimeBeforeTokenExpiry) throws IOException {
        String baseUrl = clientConfig.getBaseUrl();
        if (StringUtils.isEmpty((String)baseUrl)) {
            throw new IllegalArgumentException("No base URL given");
        }
        TokenResponse response = GraphServer.generateToken(baseUrl, username, password);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        clientConfig.getValues().put(ClientConfig.Field.ACCESS_TOKEN, token);
        return GraphServer.addVersionInfo(Pgx.getInstance((ClientConfig)clientConfig, (RealmClient)realmClient));
    }

    public static ServerInstance getInstance(String baseUrl, String username, char[] password) throws IOException {
        return GraphServer.getInstance(baseUrl, username, password, -1);
    }

    @Deprecated
    public static ServerInstance getInstance(String baseUrl, String username, char[] password, int refreshTimeBeforeTokenExpiry) throws IOException {
        TokenResponse response = GraphServer.generateToken(baseUrl, username, password);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        return GraphServer.addVersionInfo(Pgx.getInstance((String)baseUrl, (RealmClient)realmClient));
    }

    public static ServerInstance getInstance(String baseUrl, String kerberosTicketPath) throws IOException {
        return GraphServer.getInstance(baseUrl, kerberosTicketPath, -1);
    }

    @Deprecated
    public static ServerInstance getInstance(String baseUrl, String kerberosTicketPath, int refreshTimeBeforeTokenExpiry) throws IOException {
        TokenResponse response = GraphServer.generateToken(baseUrl, kerberosTicketPath);
        String token = response.getToken();
        Cookie stickyCookie = response.getCookie();
        GraphRealmClient realmClient = new GraphRealmClient(GraphServer.getClient(), baseUrl, token, refreshTimeBeforeTokenExpiry, stickyCookie);
        return GraphServer.addVersionInfo(Pgx.getInstance((String)baseUrl, (RealmClient)realmClient));
    }

    public static ServerInstance reauthenticate(ServerInstance instance, String username, char[] password) throws IOException {
        TokenResponse response = GraphServer.generateToken(instance.getBaseUrl(), username, password);
        instance.setToken(response.getToken());
        return instance;
    }

    public static TokenResponse generateToken(String baseUrl, String username, char[] password) throws IOException {
        baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be NULL");
        username = Objects.requireNonNull(username, "username must not be NULL");
        password = Objects.requireNonNull(password, "password must not be NULL");
        return GraphServer.getClient().createToken(baseUrl, username, new String(password));
    }

    public static TokenResponse generateToken(String baseUrl, String kerberosTicketPath) throws IOException {
        baseUrl = Objects.requireNonNull(baseUrl, "baseUrl must not be NULL");
        kerberosTicketPath = Objects.requireNonNull(kerberosTicketPath, "kerberosTicket must not be NULL");
        return GraphServer.getClient().createToken(baseUrl, kerberosTicketPath);
    }

    public static ServerInstance addVersionInfo(ServerInstance instance) {
        Properties properties = GraphServer.getProductVersion();
        String distribution = properties.getProperty(PRODUCT_DISTRIBUTION_KEY);
        String sombreroVersion = properties.getProperty(SOMBRERO_VERSION_KEY);
        String gvtVersion = properties.getProperty(GVT_VERSION_KEY);
        String pgqlVersion = properties.getProperty(PGQL_VERSION_KEY);
        String pgqlOnRdbmsVersion = properties.getProperty(PGQL_ON_RDBMS_VERSION_KEY);
        try {
            VersionInfo info = instance.getVersion();
            if (sombreroVersion != null) {
                info.getDisplayFields().put(distribution, sombreroVersion);
            }
            if (info.getReleaseVersion() != null) {
                info.getDisplayFields().put("PGX", info.getReleaseVersion());
            }
            if (pgqlOnRdbmsVersion != null) {
                info.getDisplayFields().put("PGQL on RDBMS", pgqlOnRdbmsVersion);
            }
            if (gvtVersion != null) {
                info.getDisplayFields().put("GVT", gvtVersion);
            }
            if (pgqlVersion != null) {
                info.getDisplayFields().put("PGQL", pgqlVersion);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        return instance;
    }

    public static Properties getProductVersion() {
        Properties properties;
        block8: {
            properties = new Properties();
            try {
                VirtualFile virtualFile = VirtualFileManagerFactory.getInstance().resolve(PRODUCT_VERSION_LOCATION, UserContext.UNAUTHENTICATED_USER_CONTEXT);
                if (!virtualFile.exists()) break block8;
                try (InputStream inputStream = virtualFile.getInputStream();){
                    properties.load(inputStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }
}

