/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class CastToUnion
extends UnaryExpression {
    private UnionType targetType;
    private boolean allowEmpty;
    private NamespaceResolver nsResolver = null;

    public CastToUnion(Expression source, UnionType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.targetType.isNamespaceSensitive()) {
            StaticContext env = visitor.getStaticContext();
            this.nsResolver = env.getNamespaceResolver();
        }
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        RoleLocator role = new RoleLocator(2, "cast as", 0);
        this.operand = TypeChecker.staticTypeCheck(this.operand, atomicType, false, role, visitor);
        if (this.operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)this.operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                GroundedValue av = SequenceTool.toGroundedValue(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(av, this.getContainer());
            }
            if (literalOperand.getLength() == 0) {
                if (this.allowEmpty) {
                    return this.operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.operand.getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        int c = 16384;
        if (this.allowEmpty && Cardinality.allowsZero(this.operand.getCardinality())) {
            c |= 0x2000;
        }
        if (this.targetType.containsListType()) {
            c |= 0x2000;
            c |= 0x8000;
        }
        return c;
    }

    public ItemType getItemType() {
        if (this.targetType instanceof PlainType) {
            return this.targetType;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        CastToUnion c = new CastToUnion(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
        c.nsResolver = this.nsResolver;
        return c;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        AtomicValue value = (AtomicValue)this.operand.evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode("XPTY0004");
            throw e;
        }
        try {
            AtomicSequence result = CastToUnion.cast(value, this.targetType, this.nsResolver, rules);
            return result.iterate();
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this);
            err.setErrorCode("FORG0001");
            throw err;
        }
    }

    public static boolean castable(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, XPathContext context) {
        try {
            CastToUnion.cast(value, targetType, nsResolver, context.getConfiguration().getConversionRules());
            return true;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public static AtomicSequence cast(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, ConversionRules rules) throws XPathException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
            try {
                return targetType.getTypedValue(value.getStringValueCS(), nsResolver, rules);
            }
            catch (ValidationException e) {
                e.setErrorCode("FORG0001");
                throw e;
            }
        }
        AtomicType label = value.getItemType();
        Set<PlainType> memberTypes = targetType.getPlainMemberTypes();
        while (label != null) {
            if (memberTypes.contains(label)) {
                return value;
            }
            label = label.getBaseType() instanceof AtomicType ? (AtomicType)label.getBaseType() : null;
        }
        for (PlainType type : memberTypes) {
            ConversionResult result;
            Converter c;
            if (!(type instanceof AtomicType) || (c = rules.getConverter(value.getItemType(), (AtomicType)type)) == null || !((result = c.convert(value)) instanceof AtomicValue)) continue;
            return (AtomicValue)result;
        }
        throw new XPathException("Cannot convert the supplied value to the required union type", "FORG0001");
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastToUnion && this.targetType == ((CastToUnion)other).targetType && this.allowEmpty == ((CastToUnion)other).allowEmpty && this.nsResolver == ((CastToUnion)other).nsResolver;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.targetType.getEQName() + "(" + this.operand.toString() + ")";
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("castToUnion");
        out.emitAttribute("as", this.targetType.toString());
        this.operand.explain(out);
        out.endElement();
    }
}

