#pragma once

#include "antlr4-runtime.h"

class XPathLexer : public antlr4::Lexer {
public:
    enum {
        TOKEN_REF = 1,
        RULE_REF = 2,
        ANYWHERE = 3,
        ROOT = 4,
        WILDCARD = 5,
        BANG = 6,
        ID = 7,
        STRING = 8
    };

    XPathLexer(antlr4::CharStream* input);
    ~XPathLexer();

    virtual std::string getGrammarFileName() const override;
    virtual const std::vector<std::string>& getRuleNames() const override;

    virtual const std::vector<std::string>& getChannelNames() const override;
    virtual const std::vector<std::string>& getModeNames() const override;
    virtual const std::vector<std::string>&
    getTokenNames() const override; // deprecated, use vocabulary instead
    virtual antlr4::dfa::Vocabulary& getVocabulary() const override;

    virtual const std::vector<uint16_t> getSerializedATN() const override;
    virtual const antlr4::atn::ATN& getATN() const override;

    virtual void action(
        antlr4::RuleContext* context, size_t ruleIndex, size_t actionIndex) override;

private:
    static std::vector<antlr4::dfa::DFA> _decisionToDFA;
    static antlr4::atn::PredictionContextCache _sharedContextCache;
    static std::vector<std::string> _ruleNames;
    static std::vector<std::string> _tokenNames;
    static std::vector<std::string> _channelNames;
    static std::vector<std::string> _modeNames;

    static std::vector<std::string> _literalNames;
    static std::vector<std::string> _symbolicNames;
    static antlr4::dfa::Vocabulary _vocabulary;
    static antlr4::atn::ATN _atn;
    static std::vector<uint16_t> _serializedATN;

    // Individual action functions triggered by action() above.
    void IDAction(antlr4::RuleContext* context, size_t actionIndex);

    // Individual semantic predicate functions triggered by sempred() above.

    struct Initializer {
        Initializer();
    };
    static Initializer _init;
};
