from os.path import normcase, isdir, exists, sep

from aspect import Aspect
from funcs import validnodespec, marklast

try:
    set
except NameError:
    from sets import Set as set

class FSNode(object):
    """
    File system node
    """
    _aspectmap = dict({
        })
    def __init__(self, name, parent, **kwargs):
        self.name = self._checkname(name)
        self._normname = normcase(self.name)
        self.parent = parent

    def absname(self):
        return sep.join((self.parent.absname(), self.name))

    def _checkname(self, s):
        return validnodespec(s)

    def getFileSystem(self):
        from fs import FileSystem
        p = self
        while not isinstance(p, FileSystem):
            p = p.parent
        return p

    def isdir(self):
        return 0

    def __cmp__(self, other):
        return cmp(self._normname, other._normname)


class DirMixin(object):
    def __init__(self):
        self._entries = dict()
        self.normcase_map = dict()

    def _checkentryname(self, s):
        validnodespec(s)

    def _getDir(self, liz):
        """
        consumes the given list
        """
        assert isinstance(liz, list)
        if not liz:
            return self
        first = liz.pop(0)
        self._checkentryname(first)
        # import pdb; pdb.set_trace()
        d = self._entries.get(first, None)
        if d:
            return d._getDir(liz)
        normal = normcase(first)
        if normal != first:
            nk = self.normcase_map.get(normal, None)
            if nk:
                return self._entries[nk]._getDir(liz)
        else:
            nk = 'not None'
        newname = sep.join((self.absname(), first))
        if liz:
            if not isdir(newname):
                raise NotADirectory(newname)
            cls = Directory
        else:
            if not exists(newname):
                raise NotFound(newname)
            cls = isdir(newname) and Directory or FSNode
        ## import pdb; pdb.set_trace()
        d = cls(first, self)
        self._entries[first] = d
        if not nk:
            self.normcase_map[normal] = first
        return d._getDir(liz)

    def getDir(self, dn):
        if isinstance(dn, basestring):
            if not dn:
                liz = list()
            else:
                liz = normpath(dn).split(sep)
                assert liz[0], ('absolute paths not allowed (%s.getDir(%r)'
                                ) % (self.__class__.__name__, dn)
        else:
            liz = list(dn)
        return self._getDir(liz)

    def getDirs(self):
        for k in sorted(self._entries.keys()):
            e = self._entries[k]
            if e.isdir():
                yield self._entries[k]

    def getNondirs(self):
        for k in sorted(self._entries.keys()):
            e = self._entries[k]
            if not e.isdir():
                yield self._entries[k]


class Directory(FSNode, DirMixin):
    def __init__(self, name, parent):
        # import pdb; pdb.set_trace()
        FSNode.__init__(self, name, parent)
        DirMixin.__init__(self)

    def make_available_as(self, do):
        if not hasattr(self, 'aliases'):
            setattr(self, 'aliases', set())
        self.aliases.add(do)

    def available_as(self):
        for item in sorted(getattr(self, 'aliases', list())):
            yield item

    def isdir(self):
        return 1

    def _print_tree(self, prefix, last, isroot):
        if isroot:
            mypart = ''
            inherited = ''
        elif last:
            mypart = '`--'
            inherited = '   '
        else:
            mypart = '|--'
            inherited = '|  '
        print prefix+mypart+self.name
# \ + '\tprefix=%r\tp2=%r' % (prefix, p2)
        # import pdb; pdb.set_trace()
        # prefix += p2
        # prefix = p2 + prefix
        subs = list(self.getDirs())
        p2 = subs and '|  ' or '   '
        prefix += inherited
        for a in self.available_as():
            print '%s%salias %s' % (prefix, p2, a.name)
        for lst, d in marklast(sorted(subs)):
            d._print_tree(prefix, lst, 0)

    def print_tree(self, prefix=''):
        return self._print_tree(prefix, 1, 1)
        
        

# vim: ts=8 sts=4 si et tw=79 sw=4
