from urlparse import urlparse, parse_qs
from pyLibrary.dot import Null, nvl, wrap
from pyLibrary.dot.dicts import Dict


convert = None
Log = None


def _late_import():
    global convert
    global Log
    from pyLibrary import convert
    from pyLibrary.debugs.logs import Log


names = ["path", "query", "fragment"]
indicator = ["/", "?", "#"]


def parse(output, suffix, curr, next):
    if next == len(indicator):
        output.__setattr__(names[curr], suffix)
        return

    e = suffix.find(indicator[next])
    if e == -1:
        parse(output, suffix, curr, next + 1)
    else:
        output.__setattr__(names[curr], suffix[:e:])
        parse(output, suffix[e + 1::], next, next + 1)


class URL(object):

    def __init__(self, value):
        self.scheme = None
        self.host = None
        self.port = None
        self.path = ""
        self.query = ""
        self.fragment = ""

        if value == None:
            return

        if not convert:
            _late_import()
        if value.startswith("file://") or value.startswith("//"):
            # urlparse DOES NOT WORK IN THESE CASES
            scheme, suffix = value.split("//")
            self.scheme = scheme.rstrip(":")
            parse(self, suffix, 0, 1)

            self.query = wrap(convert.url_param2value(self.query))
            self.fragment = self.fragment
        else:
            output = urlparse(value)
            self.scheme = output.scheme
            self.port = output.port
            self.host = output.netloc.split(":")[0]
            self.path = output.path
            self.query = wrap(convert.url_param2value(output.query))
            self.fragment = output.fragment

    def __nonzero__(self):
        if self.scheme or self.host or self.port or self.path or self.query or self.fragment:
            return True
        return False

    def __bool__(self):
        if self.scheme or self.host or self.port or self.path or self.query or self.fragment:
            return True
        return False

    def __str__(self):
        url = b""
        if self.host:
            url = self.host
        if self.scheme:
            url = self.scheme + "://"+url
        if self.port:
            url = url + ":" + str(self.port)
        if self.path:
            url += str(self.path)
        if self.query:
            url = url + '?' + convert.value2url(self.query)
        if self.fragment:
            url = url + '#' + convert.value2url(self.fragment)
        return url


