from distutils.core import setup

setup(
    name='alx',
    version='0.4.5',
    url='https://github.com/gomes-/alx',
    license='Proprietary',
    author='Alex Gomes',
    author_email='gomes@alexgomes.com',
    description='Swiss army knife for Shell, Cloud and DevOps.',

    scripts=['bin/alx.py',
             'bin/alx.bat',
             'bin/alx',
             'bin/alx-server.py',
             'bin/alx-server.bat',
             'bin/alx-server',
             ],
    packages=['alxlib',
              'alxlib.cloud',
              'alxlib.data',
              'alxlib.help',
              'alxlib.node',

              ],
    install_requires=['python-daemon>=2.0.5',
                      'azure>=0.10.2',
                      'requests>=2.7.0',
                      'terminaltables>=1.1.1',
                      'colorclass>=1.2.0',
                      ],

    classifiers=[
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'Intended Audience :: Information Technology',
        'Intended Audience :: System Administrators',
        'License :: Other/Proprietary License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: System :: Distributed Computing',
        'Topic :: System :: Networking ',
        'Topic :: System :: Shells',
        'Topic :: System :: Systems Administration',
    ],
)
