# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError, map_error
from azure.core.async_paging import AsyncItemPaged, AsyncList
from ... import models
import uuid


class ConfigurationClientOperationsMixin:

    def list_configuration_settings(
            self, label=None, key=None, accept_date_time=None, fields=None, *, cls=None, **kwargs):
        """List configuration settings.

        List the configuration settings in the configuration store, optionally
        filtered by label.

        :param label: Filter returned values based on their label. '*' can be
         used as wildcard in the beginning or end of the filter
        :type label: list[str]
        :param key: Filter returned values based on their keys. '*' can be
         used as wildcard in the beginning or end of the filter
        :type key: list[str]
        :param accept_date_time: Obtain representation of the result related
         to past time.
        :type accept_date_time: datetime
        :param fields: Specify which fields to return
        :type fields: list[str]
        :return: An iterator like instance of ConfigurationSetting
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.ConfigurationSetting]
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.list_configuration_settings.metadata['url']
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, '[str]', div=',', max_items=5)
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, '[str]', div=',')
                if fields is not None:
                    query_parameters['fields'] = self._serialize.query("fields", fields, '[str]', div=',')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if accept_date_time is not None:
                header_parameters['Accept-DateTime'] = self._serialize.header("accept_date_time", accept_date_time, 'iso-8601')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('ConfigurationSettingList', response)
            return None, AsyncList(deserialized.items)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    list_configuration_settings.metadata = {'url': '/kv'}

    async def get_configuration_setting(self, key, label="%00", accept_date_time=None, *, cls=None, **kwargs):
        """Get a ConfigurationSetting.

        Get the ConfigurationSetting for the given key and label.

        :param key: string
        :type key: str
        :param label: Label of key to retreive
        :type label: str
        :param accept_date_time: Obtain representation of the result related
         to past time.
        :type accept_date_time: datetime
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ConfigurationSetting or the result of cls(response)
        :rtype: ~appconfiguration.models.ConfigurationSetting
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.get_configuration_setting.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if accept_date_time is not None:
            header_parameters['Accept-DateTime'] = self._serialize.header("accept_date_time", accept_date_time, 'iso-8601')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 304]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ConfigurationSetting', response)
            header_dict = {
                'Last-Modified': self._deserialize('str', response.headers.get('Last-Modified')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    get_configuration_setting.metadata = {'url': '/kv/{key}'}

    async def create_or_update_configuration_setting(self, configuration_setting, key, label="%00", *, cls=None, **kwargs):
        """Create (or update) a ConfigurationSetting.

        Create (or update) a ConfigurationSetting.

        :param configuration_setting:
        :type configuration_setting:
         ~appconfiguration.models.ConfigurationSetting
        :param key: string
        :type key: str
        :param label:
        :type label: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ConfigurationSetting or the result of cls(response)
        :rtype: ~appconfiguration.models.ConfigurationSetting
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.create_or_update_configuration_setting.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct body
        body_content = self._serialize.body(configuration_setting, 'ConfigurationSetting')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ConfigurationSetting', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    create_or_update_configuration_setting.metadata = {'url': '/kv/{key}'}

    async def delete_configuration_setting(self, key, label=None, *, cls=None, **kwargs):
        """Delete a ConfigurationSetting.

        :param key: string
        :type key: str
        :param label:
        :type label: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ConfigurationSetting or the result of cls(response)
        :rtype: ~appconfiguration.models.ConfigurationSetting
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.delete_configuration_setting.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ConfigurationSetting', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    delete_configuration_setting.metadata = {'url': '/kv/{key}'}

    def list_keys(
            self, name=None, accept_date_time=None, *, cls=None, **kwargs):
        """

        :param name:
        :type name: str
        :param accept_date_time: Obtain representation of the result related
         to past time.
        :type accept_date_time: datetime
        :return: An iterator like instance of Key
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.Key]
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.list_keys.metadata['url']
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if accept_date_time is not None:
                header_parameters['Accept-DateTime'] = self._serialize.header("accept_date_time", accept_date_time, 'iso-8601')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('KeyList', response)
            return None, AsyncList(deserialized.items)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    list_keys.metadata = {'url': '/keys'}

    def list_labels(
            self, accept_date_time=None, fields=None, name=None, *, cls=None, **kwargs):
        """List labels.

        :param accept_date_time: Obtain representation of the result related
         to past time.
        :type accept_date_time: datetime
        :param fields: Specify which fields to return
        :type fields: list[str]
        :param name:
        :type name: str
        :return: An iterator like instance of Label
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.Label]
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.list_labels.metadata['url']
                if fields is not None:
                    query_parameters['fields'] = self._serialize.query("fields", fields, '[str]', div=',')
                if name is not None:
                    query_parameters['name'] = self._serialize.query("name", name, 'str')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if accept_date_time is not None:
                header_parameters['Accept-DateTime'] = self._serialize.header("accept_date_time", accept_date_time, 'iso-8601')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('LabelList', response)
            return None, AsyncList(deserialized.items)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    list_labels.metadata = {'url': '/labels'}

    async def lock_configuration_setting(self, key, label=None, *, cls=None, **kwargs):
        """

        :param key:
        :type key: str
        :param label:
        :type label: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ConfigurationSetting or the result of cls(response)
        :rtype: ~appconfiguration.models.ConfigurationSetting
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.lock_configuration_setting.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ConfigurationSetting', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    lock_configuration_setting.metadata = {'url': '/locks/{key}'}

    async def unlock_configuration_setting(self, key, label=None, *, cls=None, **kwargs):
        """

        :param key:
        :type key: str
        :param label:
        :type label: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ConfigurationSetting or the result of cls(response)
        :rtype: ~appconfiguration.models.ConfigurationSetting
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        error_map = kwargs.pop('error_map', None)
        # Construct URL
        url = self.unlock_configuration_setting.metadata['url']
        path_format_arguments = {
            'key': self._serialize.url("key", key, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if label is not None:
            query_parameters['label'] = self._serialize.query("label", label, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self._config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ConfigurationSetting', response)

        if cls:
            return cls(response, deserialized, None)

        return deserialized
    unlock_configuration_setting.metadata = {'url': '/locks/{key}'}

    def list_revisions(
            self, label=None, key=None, fields=None, accept_date_time=None, *, cls=None, **kwargs):
        """

        :param label: Filter returned values based on their label. '*' can be
         used as wildcard in the beginning or end of the filter
        :type label: list[str]
        :param key: Filter returned values based on their keys. '*' can be
         used as wildcard in the beginning or end of the filter
        :type key: list[str]
        :param fields: Specify which fields to return
        :type fields: list[str]
        :param accept_date_time: Obtain representation of the result related
         to past time.
        :type accept_date_time: datetime
        :return: An iterator like instance of ConfigurationSetting
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~appconfiguration.models.ConfigurationSetting]
        :raises: :class:`HttpResponseError<azure.core.HttpResponseError>`
        """
        def prepare_request(next_link=None):
            query_parameters = {}
            if not next_link:
                # Construct URL
                url = self.list_revisions.metadata['url']
                if label is not None:
                    query_parameters['label'] = self._serialize.query("label", label, '[str]', div=',', max_items=5)
                if key is not None:
                    query_parameters['key'] = self._serialize.query("key", key, '[str]', div=',')
                if fields is not None:
                    query_parameters['fields'] = self._serialize.query("fields", fields, '[str]', div=',')

            else:
                url = next_link

            # Construct headers
            header_parameters = {}
            header_parameters['Accept'] = 'application/json'
            if self._config.generate_client_request_id:
                header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
            if accept_date_time is not None:
                header_parameters['Accept-DateTime'] = self._serialize.header("accept_date_time", accept_date_time, 'iso-8601')

            # Construct and send request
            request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data_async(response):
            deserialized = self._deserialize('ConfigurationSettingList', response)
            return None, AsyncList(deserialized.items)

        async def get_next_async(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request)
            response = pipeline_response.http_response

            error_map = kwargs.pop('error_map', None)
            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)
            return response

        # Deserialize response
        return AsyncItemPaged(
            get_next_async, extract_data_async
        )
    list_revisions.metadata = {'url': '/revisions'}
