# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AppliedReservationList(Model):
    """AppliedReservationList.

    :param value:
    :type value: list[str]
    :param next_link: Url to get the next page of reservations
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(AppliedReservationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppliedReservations(Model):
    """AppliedReservations.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Identifier of the applied reservations
    :vartype id: str
    :ivar name: Name of resource
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/AppliedReservations"
    :vartype type: str
    :param reservation_order_ids:
    :type reservation_order_ids:
     ~azure.mgmt.reservations.models.AppliedReservationList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reservation_order_ids': {'key': 'properties.reservationOrderIds', 'type': 'AppliedReservationList'},
    }

    def __init__(self, *, reservation_order_ids=None, **kwargs) -> None:
        super(AppliedReservations, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.reservation_order_ids = reservation_order_ids


class AvailableScopeProperties(Model):
    """AvailableScopeProperties.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.SubscriptionScopeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SubscriptionScopeProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(AvailableScopeProperties, self).__init__(**kwargs)
        self.properties = properties


class AvailableScopeRequest(Model):
    """Available scope.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.AvailableScopeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AvailableScopeRequestProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(AvailableScopeRequest, self).__init__(**kwargs)
        self.properties = properties


class AvailableScopeRequestProperties(Model):
    """Available scope request properties.

    :param scopes:
    :type scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(self, *, scopes=None, **kwargs) -> None:
        super(AvailableScopeRequestProperties, self).__init__(**kwargs)
        self.scopes = scopes


class BillingInformation(Model):
    """billing information.

    :param billing_currency_total_paid_amount:
    :type billing_currency_total_paid_amount:
     ~azure.mgmt.reservations.models.Price
    :param billing_currency_prorated_amount:
    :type billing_currency_prorated_amount:
     ~azure.mgmt.reservations.models.Price
    :param billing_currency_remaining_commitment_amount:
    :type billing_currency_remaining_commitment_amount:
     ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'billing_currency_total_paid_amount': {'key': 'billingCurrencyTotalPaidAmount', 'type': 'Price'},
        'billing_currency_prorated_amount': {'key': 'billingCurrencyProratedAmount', 'type': 'Price'},
        'billing_currency_remaining_commitment_amount': {'key': 'billingCurrencyRemainingCommitmentAmount', 'type': 'Price'},
    }

    def __init__(self, *, billing_currency_total_paid_amount=None, billing_currency_prorated_amount=None, billing_currency_remaining_commitment_amount=None, **kwargs) -> None:
        super(BillingInformation, self).__init__(**kwargs)
        self.billing_currency_total_paid_amount = billing_currency_total_paid_amount
        self.billing_currency_prorated_amount = billing_currency_prorated_amount
        self.billing_currency_remaining_commitment_amount = billing_currency_remaining_commitment_amount


class CalculateExchangeOperationResultResponse(Model):
    """CalculateExchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will
     typically be a GUID / system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include:
     'Succeeded', 'Failed', 'Cancelled', 'Pending'
    :type status: str or
     ~azure.mgmt.reservations.models.CalculateExchangeOperationResultStatus
    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.CalculateExchangeResponseProperties
    :param error:
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CalculateExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(self, *, id: str=None, name: str=None, status=None, properties=None, error=None, **kwargs) -> None:
        super(CalculateExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = error


class CalculateExchangeRequest(Model):
    """Calculate exchange request.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.CalculateExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculateExchangeRequestProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CalculateExchangeRequest, self).__init__(**kwargs)
        self.properties = properties


class CalculateExchangeRequestProperties(Model):
    """Calculate exchange request properties.

    :param reservations_to_purchase: List of reservations that are being
     purchased in this exchange.
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.PurchaseRequest]
    :param reservations_to_exchange: List of reservations that are being
     returned in this exchange.
    :type reservations_to_exchange:
     list[~azure.mgmt.reservations.models.ReservationToReturn]
    """

    _attribute_map = {
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[PurchaseRequest]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturn]'},
    }

    def __init__(self, *, reservations_to_purchase=None, reservations_to_exchange=None, **kwargs) -> None:
        super(CalculateExchangeRequestProperties, self).__init__(**kwargs)
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange


class CalculateExchangeResponseProperties(Model):
    """CalculateExchange response properties.

    :param session_id: Exchange session identifier
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being
     purchased
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseCalculateExchange]
    :param reservations_to_exchange: Details of the reservations being
     returned
    :type reservations_to_exchange:
     list[~azure.mgmt.reservations.models.ReservationToExchange]
    :param policy_result:
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseCalculateExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(self, *, session_id: str=None, net_payable=None, refunds_total=None, purchases_total=None, reservations_to_purchase=None, reservations_to_exchange=None, policy_result=None, **kwargs) -> None:
        super(CalculateExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = session_id
        self.net_payable = net_payable
        self.refunds_total = refunds_total
        self.purchases_total = purchases_total
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange
        self.policy_result = policy_result


class CalculatePriceResponse(Model):
    """CalculatePriceResponse.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.CalculatePriceResponseProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculatePriceResponseProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CalculatePriceResponse, self).__init__(**kwargs)
        self.properties = properties


class CalculatePriceResponseProperties(Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft
     Partner. Used only for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that
     can be placed after calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    :param payment_schedule:
    :type payment_schedule:
     list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
        'payment_schedule': {'key': 'paymentSchedule', 'type': '[PaymentDetail]'},
    }

    def __init__(self, *, billing_currency_total=None, is_billing_partner_managed: bool=None, reservation_order_id: str=None, sku_title: str=None, sku_description: str=None, pricing_currency_total=None, payment_schedule=None, **kwargs) -> None:
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = billing_currency_total
        self.is_billing_partner_managed = is_billing_partner_managed
        self.reservation_order_id = reservation_order_id
        self.sku_title = sku_title
        self.sku_description = sku_description
        self.pricing_currency_total = pricing_currency_total
        self.payment_schedule = payment_schedule


class CalculatePriceResponsePropertiesBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, *, currency_code: str=None, amount: float=None, **kwargs) -> None:
        super(CalculatePriceResponsePropertiesBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class CalculatePriceResponsePropertiesPricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, *, currency_code: str=None, amount: float=None, **kwargs) -> None:
        super(CalculatePriceResponsePropertiesPricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class Catalog(Model):
    """Catalog.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU
    :vartype name: str
    :param billing_plans: The billing plan options available for this SKU.
    :type billing_plans: dict[str, list[str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan]]
    :ivar terms: Available reservation terms for this resource
    :vartype terms: list[str or
     ~azure.mgmt.reservations.models.ReservationTerm]
    :ivar locations:
    :vartype locations: list[str]
    :ivar sku_properties:
    :vartype sku_properties: list[~azure.mgmt.reservations.models.SkuProperty]
    :ivar restrictions:
    :vartype restrictions:
     list[~azure.mgmt.reservations.models.SkuRestriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'terms': {'readonly': True},
        'locations': {'readonly': True},
        'sku_properties': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'billing_plans': {'key': 'billingPlans', 'type': '{[str]}'},
        'terms': {'key': 'terms', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'sku_properties': {'key': 'skuProperties', 'type': '[SkuProperty]'},
        'restrictions': {'key': 'restrictions', 'type': '[SkuRestriction]'},
    }

    def __init__(self, *, billing_plans=None, **kwargs) -> None:
        super(Catalog, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.billing_plans = billing_plans
        self.terms = None
        self.locations = None
        self.sku_properties = None
        self.restrictions = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CreateGenericQuotaRequestParameters(Model):
    """Quota change requests information.

    :param value: Quota change requests.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(CreateGenericQuotaRequestParameters, self).__init__(**kwargs)
        self.value = value


class CurrentQuotaLimit(Model):
    """Current quota limits.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    :ivar provisioning_state: The details of the quota request status.
    :vartype provisioning_state: object
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'quotaInformation.properties', 'type': 'QuotaProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CurrentQuotaLimit, self).__init__(**kwargs)
        self.properties = properties
        self.provisioning_state = None
        self.message = None


class CurrentQuotaLimitBase(Model):
    """Quota properties.

    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'QuotaProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CurrentQuotaLimitBase, self).__init__(**kwargs)
        self.properties = properties


class Error(Model):
    """Error.

    :param error:
    :type error: ~azure.mgmt.reservations.models.ExtendedErrorInfo
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(Error, self).__init__(**kwargs)
        self.error = error


class ErrorException(HttpOperationError):
    """Server responsed with exception of type: 'Error'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorException, self).__init__(deserialize, response, 'Error', *args)


class ExceptionResponse(Model):
    """The API error.

    :param error: The API error details.
    :type error: ~azure.mgmt.reservations.models.ServiceError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ServiceError'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ExceptionResponse, self).__init__(**kwargs)
        self.error = error


class ExceptionResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ExceptionResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ExceptionResponseException, self).__init__(deserialize, response, 'ExceptionResponse', *args)


class ExchangeOperationResultResponse(Model):
    """Exchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will
     typically be a GUID / system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include:
     'Succeeded', 'Failed', 'Cancelled', 'PendingRefunds', 'PendingPurchases'
    :type status: str or
     ~azure.mgmt.reservations.models.ExchangeOperationResultStatus
    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.ExchangeResponseProperties
    :param error:
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(self, *, id: str=None, name: str=None, status=None, properties=None, error=None, **kwargs) -> None:
        super(ExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = error


class ExchangePolicyError(Model):
    """error details.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ExchangePolicyError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ExchangePolicyErrors(Model):
    """Exchange policy errors.

    :param policy_errors: Exchange Policy errors
    :type policy_errors:
     list[~azure.mgmt.reservations.models.ExchangePolicyError]
    """

    _attribute_map = {
        'policy_errors': {'key': 'policyErrors', 'type': '[ExchangePolicyError]'},
    }

    def __init__(self, *, policy_errors=None, **kwargs) -> None:
        super(ExchangePolicyErrors, self).__init__(**kwargs)
        self.policy_errors = policy_errors


class ExchangeRequest(Model):
    """Exchange request.

    :param properties:
    :type properties:
     ~azure.mgmt.reservations.models.ExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ExchangeRequestProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(ExchangeRequest, self).__init__(**kwargs)
        self.properties = properties


class ExchangeRequestProperties(Model):
    """Exchange request properties.

    :param session_id: SessionId that was returned by CalculateExchange API.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(self, *, session_id: str=None, **kwargs) -> None:
        super(ExchangeRequestProperties, self).__init__(**kwargs)
        self.session_id = session_id


class ExchangeResponseProperties(Model):
    """Exchange response properties.

    :param session_id: Exchange session identifier
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being
     purchased
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseExchange]
    :param reservations_to_exchange: Details of the reservations being
     returned
    :type reservations_to_exchange:
     list[~azure.mgmt.reservations.models.ReservationToReturnForExchange]
    :param policy_result:
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturnForExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(self, *, session_id: str=None, net_payable=None, refunds_total=None, purchases_total=None, reservations_to_purchase=None, reservations_to_exchange=None, policy_result=None, **kwargs) -> None:
        super(ExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = session_id
        self.net_payable = net_payable
        self.refunds_total = refunds_total
        self.purchases_total = purchases_total
        self.reservations_to_purchase = reservations_to_purchase
        self.reservations_to_exchange = reservations_to_exchange
        self.policy_result = policy_result


class ExtendedErrorInfo(Model):
    """ExtendedErrorInfo.

    :param code: Possible values include: 'NotSpecified',
     'InternalServerError', 'ServerTimeout', 'AuthorizationFailed',
     'BadRequest', 'ClientCertificateThumbprintNotSet',
     'InvalidRequestContent', 'OperationFailed', 'HttpMethodNotSupported',
     'InvalidRequestUri', 'MissingTenantId', 'InvalidTenantId',
     'InvalidReservationOrderId', 'InvalidReservationId',
     'ReservationIdNotInReservationOrder', 'ReservationOrderNotFound',
     'InvalidSubscriptionId', 'InvalidAccessToken', 'InvalidLocationId',
     'UnauthenticatedRequestsThrottled', 'InvalidHealthCheckType', 'Forbidden',
     'BillingScopeIdCannotBeChanged',
     'AppliedScopesNotAssociatedWithCommerceAccount',
     'PatchValuesSameAsExisting', 'RoleAssignmentCreationFailed',
     'ReservationOrderCreationFailed', 'ReservationOrderNotEnabled',
     'CapacityUpdateScopesFailed', 'UnsupportedReservationTerm',
     'ReservationOrderIdAlreadyExists', 'RiskCheckFailed', 'CreateQuoteFailed',
     'ActivateQuoteFailed', 'NonsupportedAccountId',
     'PaymentInstrumentNotFound', 'MissingAppliedScopesForSingle',
     'NoValidReservationsToReRate', 'ReRateOnlyAllowedForEA',
     'OperationCannotBePerformedInCurrentState',
     'InvalidSingleAppliedScopesCount', 'InvalidFulfillmentRequestParameters',
     'NotSupportedCountry', 'InvalidRefundQuantity', 'PurchaseError',
     'BillingCustomerInputError', 'BillingPaymentInstrumentSoftError',
     'BillingPaymentInstrumentHardError', 'BillingTransientError',
     'BillingError', 'FulfillmentConfigurationError',
     'FulfillmentOutOfStockError', 'FulfillmentTransientError',
     'FulfillmentError', 'CalculatePriceFailed'
    :type code: str or ~azure.mgmt.reservations.models.ErrorResponseCode
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code=None, message: str=None, **kwargs) -> None:
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ExtendedStatusInfo(Model):
    """ExtendedStatusInfo.

    :param status_code: Possible values include: 'None', 'Pending', 'Active',
     'PurchaseError', 'PaymentInstrumentError', 'Split', 'Merged', 'Expired',
     'Succeeded'
    :type status_code: str or
     ~azure.mgmt.reservations.models.ReservationStatusCode
    :param message: The message giving detailed information about the status
     code.
    :type message: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, status_code=None, message: str=None, **kwargs) -> None:
        super(ExtendedStatusInfo, self).__init__(**kwargs)
        self.status_code = status_code
        self.message = message


class MergeRequest(Model):
    """MergeRequest.

    :param sources: Format of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type sources: list[str]
    """

    _attribute_map = {
        'sources': {'key': 'properties.sources', 'type': '[str]'},
    }

    def __init__(self, *, sources=None, **kwargs) -> None:
        super(MergeRequest, self).__init__(**kwargs)
        self.sources = sources


class OperationDisplay(Model):
    """OperationDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationResponse(Model):
    """OperationResponse.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.reservations.models.OperationDisplay
    :param origin:
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, **kwargs) -> None:
        super(OperationResponse, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationResultError(Model):
    """Required if status == failed or status == canceled.

    :param code: Required if status == failed or status == cancelled. If
     status == failed, provide an invariant error code used for error
     troubleshooting, aggregation, and analysis.
    :type code: str
    :param message: Required if status == failed. Localized. If status ==
     failed, provide an actionable error message indicating what error
     occurred, and what the user can do to address the issue.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(OperationResultError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Patch(Model):
    """Patch.

    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param name: Name of the Reservation
    :type name: str
    :param renew:
    :type renew: bool
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.PatchPropertiesRenewProperties
    """

    _attribute_map = {
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'instance_flexibility': {'key': 'properties.instanceFlexibility', 'type': 'str'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'renew_properties': {'key': 'properties.renewProperties', 'type': 'PatchPropertiesRenewProperties'},
    }

    def __init__(self, *, applied_scope_type=None, applied_scopes=None, instance_flexibility=None, name: str=None, renew: bool=None, renew_properties=None, **kwargs) -> None:
        super(Patch, self).__init__(**kwargs)
        self.applied_scope_type = applied_scope_type
        self.applied_scopes = applied_scopes
        self.instance_flexibility = instance_flexibility
        self.name = name
        self.renew = renew
        self.renew_properties = renew_properties


class PatchPropertiesRenewProperties(Model):
    """PatchPropertiesRenewProperties.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
    }

    def __init__(self, *, purchase_properties=None, **kwargs) -> None:
        super(PatchPropertiesRenewProperties, self).__init__(**kwargs)
        self.purchase_properties = purchase_properties


class PaymentDetail(Model):
    """Information about payment related to a reservation order.

    :param due_date: Date when the payment needs to be done.
    :type due_date: date
    :param payment_date: Date when the transaction is completed. Is null when
     it is scheduled.
    :type payment_date: date
    :param pricing_currency_total: Amount in pricing currency. Tax not
     included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_currency_total: Amount charged in Billing currency. Tax not
     included. Is null for future payments
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_account: Shows the Account that is charged for this
     payment.
    :type billing_account: str
    :param status: Possible values include: 'Succeeded', 'Failed',
     'Scheduled', 'Cancelled'
    :type status: str or ~azure.mgmt.reservations.models.PaymentStatus
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    """

    _attribute_map = {
        'due_date': {'key': 'dueDate', 'type': 'date'},
        'payment_date': {'key': 'paymentDate', 'type': 'date'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'billing_account': {'key': 'billingAccount', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
    }

    def __init__(self, *, due_date=None, payment_date=None, pricing_currency_total=None, billing_currency_total=None, billing_account: str=None, status=None, extended_status_info=None, **kwargs) -> None:
        super(PaymentDetail, self).__init__(**kwargs)
        self.due_date = due_date
        self.payment_date = payment_date
        self.pricing_currency_total = pricing_currency_total
        self.billing_currency_total = billing_currency_total
        self.billing_account = billing_account
        self.status = status
        self.extended_status_info = extended_status_info


class Price(Model):
    """Price.

    :param currency_code: The ISO 4217 3-letter currency code for the currency
     used by this purchase record.
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, *, currency_code: str=None, amount: float=None, **kwargs) -> None:
        super(Price, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class PurchaseRequest(Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa', 'Databricks', 'AppService',
     'ManagedDisk', 'BlockBlob', 'RedisCache', 'AzureDataExplorer', 'MySql',
     'MariaDb', 'PostgreSql', 'DedicatedHost', 'SapHana',
     'SqlAzureHybridBenefit'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id:
    :type billing_scope_id: str
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param quantity:
    :type quantity: int
    :param display_name: Friendly name of the Reservation
    :type display_name: str
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param renew:
    :type renew: bool
    :param reserved_resource_properties: Properties specific to each reserved
     resource type. Not required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(self, *, sku=None, location: str=None, reserved_resource_type=None, billing_scope_id: str=None, term=None, billing_plan=None, quantity: int=None, display_name: str=None, applied_scope_type=None, applied_scopes=None, renew: bool=None, reserved_resource_properties=None, **kwargs) -> None:
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.reserved_resource_type = reserved_resource_type
        self.billing_scope_id = billing_scope_id
        self.term = term
        self.billing_plan = billing_plan
        self.quantity = quantity
        self.display_name = display_name
        self.applied_scope_type = applied_scope_type
        self.applied_scopes = applied_scopes
        self.renew = renew
        self.reserved_resource_properties = reserved_resource_properties


class PurchaseRequestPropertiesReservedResourceProperties(Model):
    """Properties specific to each reserved resource type. Not required if not
    applicable.

    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    """

    _attribute_map = {
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
    }

    def __init__(self, *, instance_flexibility=None, **kwargs) -> None:
        super(PurchaseRequestPropertiesReservedResourceProperties, self).__init__(**kwargs)
        self.instance_flexibility = instance_flexibility


class QuotaLimitsResponse(Model):
    """Quotas (service limits) in the request response.

    :param value: List of quotas with the quota request status.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimit]
    :param next_link: The URI for fetching the next page of quota limits. When
     no more pages exist, the value is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(QuotaLimitsResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class QuotaProperties(Model):
    """Quota properties for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param limit: Quota properties.
    :type limit: int
    :ivar current_value: Current usage value for the resource.
    :vartype current_value: int
    :param unit:  The limit units, such as **count** and **bytes**. Use the
     unit field provided in the response of the GET quota operation.
    :type unit: str
    :param name: Name of the resource provide by the resource provider. Use
     this property for quotaRequests resource operations.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :param resource_type: The name of the resource type.
    :type resource_type: object
    :ivar quota_period: The time period over which the quota usage values are
     summarized. For example, P1D (per one day), PT1M (per one minute), and
     PT1S (per one second). This parameter is optional because, for some
     resources such as compute, the time period is irrelevant.
    :vartype quota_period: str
    :param properties: Additional properties for the specified resource
     provider.
    :type properties: object
    """

    _validation = {
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'object'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, limit: int=None, unit: str=None, name=None, resource_type=None, properties=None, **kwargs) -> None:
        super(QuotaProperties, self).__init__(**kwargs)
        self.limit = limit
        self.current_value = None
        self.unit = unit
        self.name = name
        self.resource_type = resource_type
        self.quota_period = None
        self.properties = properties


class QuotaRequestDetails(Model):
    """Quota request details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: Quota request name.
    :vartype name: str
    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted
     using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'properties.value', 'type': '[SubRequest]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, provisioning_state=None, value=None, **kwargs) -> None:
        super(QuotaRequestDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.provisioning_state = provisioning_state
        self.message = None
        self.request_submit_time = None
        self.value = value
        self.type = None


class QuotaRequestOneResourceSubmitResponse(Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/ServiceLimits"
    :vartype type: str
    :ivar provisioning_state: The quota request status.
    :vartype provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted
     using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties.properties.properties', 'type': 'QuotaProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(QuotaRequestOneResourceSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.request_submit_time = None
        self.properties = properties


class QuotaRequestProperties(Model):
    """The details of quota request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted
     using format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'object'},
        'message': {'key': 'message', 'type': 'str'},
        'request_submit_time': {'key': 'requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': '[SubRequest]'},
    }

    def __init__(self, *, provisioning_state=None, value=None, **kwargs) -> None:
        super(QuotaRequestProperties, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.message = None
        self.request_submit_time = None
        self.value = value


class QuotaRequestSubmitResponse(Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :param properties: The quota request details.
    :type properties: ~azure.mgmt.reservations.models.QuotaRequestProperties
    :ivar type: Type of resource. "Microsoft.Capacity/serviceLimits"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'QuotaRequestProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(QuotaRequestSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = properties
        self.type = None


class QuotaRequestSubmitResponse201(Model):
    """Response with request ID that the quota request was accepted.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The quota request ID. Use the requestId parameter to check the
     request status.
    :vartype id: str
    :ivar name: Operation ID
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar provisioning_state: The details of the quota request status.
    :vartype provisioning_state: object
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'object'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(QuotaRequestSubmitResponse201, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None


class RenewPropertiesResponse(Model):
    """RenewPropertiesResponse.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param pricing_currency_total: Amount that Microsoft uses for record. Used
     during refund for calculating refund limit. Tax is not included. This is
     locked price 30 days before expiry.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponsePricingCurrencyTotal
    :param billing_currency_total: Currency and amount that customer will be
     charged in customer's local currency for renewal purchase. Tax is not
     included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponseBillingCurrencyTotal
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'RenewPropertiesResponsePricingCurrencyTotal'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'RenewPropertiesResponseBillingCurrencyTotal'},
    }

    def __init__(self, *, purchase_properties=None, pricing_currency_total=None, billing_currency_total=None, **kwargs) -> None:
        super(RenewPropertiesResponse, self).__init__(**kwargs)
        self.purchase_properties = purchase_properties
        self.pricing_currency_total = pricing_currency_total
        self.billing_currency_total = billing_currency_total


class RenewPropertiesResponseBillingCurrencyTotal(Model):
    """Currency and amount that customer will be charged in customer's local
    currency for renewal purchase. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, *, currency_code: str=None, amount: float=None, **kwargs) -> None:
        super(RenewPropertiesResponseBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class RenewPropertiesResponsePricingCurrencyTotal(Model):
    """Amount that Microsoft uses for record. Used during refund for calculating
    refund limit. Tax is not included. This is locked price 30 days before
    expiry.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(self, *, currency_code: str=None, amount: float=None, **kwargs) -> None:
        super(RenewPropertiesResponsePricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = currency_code
        self.amount = amount


class ReservationMergeProperties(Model):
    """ReservationMergeProperties.

    :param merge_destination: Reservation Resource Id Created due to the
     merge. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_destination: str
    :param merge_sources: Resource Ids of the Source Reservation's merged to
     form this Reservation. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type merge_sources: list[str]
    """

    _attribute_map = {
        'merge_destination': {'key': 'mergeDestination', 'type': 'str'},
        'merge_sources': {'key': 'mergeSources', 'type': '[str]'},
    }

    def __init__(self, *, merge_destination: str=None, merge_sources=None, **kwargs) -> None:
        super(ReservationMergeProperties, self).__init__(**kwargs)
        self.merge_destination = merge_destination
        self.merge_sources = merge_sources


class ReservationOrderBillingPlanInformation(Model):
    """Information describing the type of billing plan for this reservation.

    :param pricing_currency_total: Amount of money to be paid for the Order.
     Tax is not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param start_date: Date when the billing plan has started.
    :type start_date: date
    :param next_payment_due_date: For recurring billing plans, indicates the
     date when next payment will be processed. Null when total is paid off.
    :type next_payment_due_date: date
    :param transactions:
    :type transactions: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'start_date': {'key': 'startDate', 'type': 'date'},
        'next_payment_due_date': {'key': 'nextPaymentDueDate', 'type': 'date'},
        'transactions': {'key': 'transactions', 'type': '[PaymentDetail]'},
    }

    def __init__(self, *, pricing_currency_total=None, start_date=None, next_payment_due_date=None, transactions=None, **kwargs) -> None:
        super(ReservationOrderBillingPlanInformation, self).__init__(**kwargs)
        self.pricing_currency_total = pricing_currency_total
        self.start_date = start_date
        self.next_payment_due_date = next_payment_due_date
        self.transactions = transactions


class ReservationOrderResponse(Model):
    """ReservationOrderResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param display_name: Friendly name for user to easily identified the
     reservation.
    :type display_name: str
    :param request_date_time: This is the DateTime when the reservation was
     initially requested for purchase.
    :type request_date_time: datetime
    :param created_date_time: This is the DateTime when the reservation was
     created.
    :type created_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param original_quantity:
    :type original_quantity: int
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param plan_information:
    :type plan_information:
     ~azure.mgmt.reservations.models.ReservationOrderBillingPlanInformation
    :param reservations:
    :type reservations:
     list[~azure.mgmt.reservations.models.ReservationResponse]
    :ivar type: Type of resource. "Microsoft.Capacity/reservations"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'request_date_time': {'key': 'properties.requestDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'properties.expiryDate', 'type': 'date'},
        'original_quantity': {'key': 'properties.originalQuantity', 'type': 'int'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'plan_information': {'key': 'properties.planInformation', 'type': 'ReservationOrderBillingPlanInformation'},
        'reservations': {'key': 'properties.reservations', 'type': '[ReservationResponse]'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, etag: int=None, display_name: str=None, request_date_time=None, created_date_time=None, expiry_date=None, original_quantity: int=None, term=None, provisioning_state: str=None, billing_plan=None, plan_information=None, reservations=None, **kwargs) -> None:
        super(ReservationOrderResponse, self).__init__(**kwargs)
        self.etag = etag
        self.id = None
        self.name = None
        self.display_name = display_name
        self.request_date_time = request_date_time
        self.created_date_time = created_date_time
        self.expiry_date = expiry_date
        self.original_quantity = original_quantity
        self.term = term
        self.provisioning_state = provisioning_state
        self.billing_plan = billing_plan
        self.plan_information = plan_information
        self.reservations = reservations
        self.type = None


class ReservationProperties(Model):
    """ReservationProperties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param reserved_resource_type: Possible values include: 'VirtualMachines',
     'SqlDatabases', 'SuseLinux', 'CosmosDb', 'RedHat', 'SqlDataWarehouse',
     'VMwareCloudSimple', 'RedHatOsa', 'Databricks', 'AppService',
     'ManagedDisk', 'BlockBlob', 'RedisCache', 'AzureDataExplorer', 'MySql',
     'MariaDb', 'PostgreSql', 'DedicatedHost', 'SapHana',
     'SqlAzureHybridBenefit'
    :type reserved_resource_type: str or
     ~azure.mgmt.reservations.models.ReservedResourceType
    :param instance_flexibility: Possible values include: 'On', 'Off'
    :type instance_flexibility: str or
     ~azure.mgmt.reservations.models.InstanceFlexibility
    :param display_name: Friendly name for user to easily identify the
     reservation
    :type display_name: str
    :param applied_scopes:
    :type applied_scopes: list[str]
    :param applied_scope_type: Possible values include: 'Single', 'Shared'
    :type applied_scope_type: str or
     ~azure.mgmt.reservations.models.AppliedScopeType
    :param quantity:
    :type quantity: int
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param effective_date_time: DateTime of the Reservation starting when this
     version is effective from.
    :type effective_date_time: datetime
    :ivar last_updated_date_time: DateTime of the last time the Reservation
     was updated.
    :vartype last_updated_date_time: datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: date
    :param sku_description: Description of the SKU in english.
    :type sku_description: str
    :param extended_status_info:
    :type extended_status_info:
     ~azure.mgmt.reservations.models.ExtendedStatusInfo
    :param billing_plan: Possible values include: 'Upfront', 'Monthly'
    :type billing_plan: str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param split_properties:
    :type split_properties:
     ~azure.mgmt.reservations.models.ReservationSplitProperties
    :param merge_properties:
    :type merge_properties:
     ~azure.mgmt.reservations.models.ReservationMergeProperties
    :param billing_scope_id:
    :type billing_scope_id: str
    :param renew:
    :type renew: bool
    :param renew_source: Reservation Id of the reservation from which this
     reservation is renewed. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_source: str
    :param renew_destination: Reservation Id of the reservation which is
     purchased because of renew. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_destination: str
    :param renew_properties:
    :type renew_properties:
     ~azure.mgmt.reservations.models.RenewPropertiesResponse
    :param term: Possible values include: 'P1Y', 'P3Y'
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    """

    _validation = {
        'last_updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'reserved_resource_type': {'key': 'reservedResourceType', 'type': 'str'},
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'applied_scope_type': {'key': 'appliedScopeType', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'effective_date_time': {'key': 'effectiveDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'expiryDate', 'type': 'date'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
        'billing_plan': {'key': 'billingPlan', 'type': 'str'},
        'split_properties': {'key': 'splitProperties', 'type': 'ReservationSplitProperties'},
        'merge_properties': {'key': 'mergeProperties', 'type': 'ReservationMergeProperties'},
        'billing_scope_id': {'key': 'billingScopeId', 'type': 'str'},
        'renew': {'key': 'renew', 'type': 'bool'},
        'renew_source': {'key': 'renewSource', 'type': 'str'},
        'renew_destination': {'key': 'renewDestination', 'type': 'str'},
        'renew_properties': {'key': 'renewProperties', 'type': 'RenewPropertiesResponse'},
        'term': {'key': 'term', 'type': 'str'},
    }

    def __init__(self, *, reserved_resource_type=None, instance_flexibility=None, display_name: str=None, applied_scopes=None, applied_scope_type=None, quantity: int=None, provisioning_state: str=None, effective_date_time=None, expiry_date=None, sku_description: str=None, extended_status_info=None, billing_plan=None, split_properties=None, merge_properties=None, billing_scope_id: str=None, renew: bool=None, renew_source: str=None, renew_destination: str=None, renew_properties=None, term=None, **kwargs) -> None:
        super(ReservationProperties, self).__init__(**kwargs)
        self.reserved_resource_type = reserved_resource_type
        self.instance_flexibility = instance_flexibility
        self.display_name = display_name
        self.applied_scopes = applied_scopes
        self.applied_scope_type = applied_scope_type
        self.quantity = quantity
        self.provisioning_state = provisioning_state
        self.effective_date_time = effective_date_time
        self.last_updated_date_time = None
        self.expiry_date = expiry_date
        self.sku_description = sku_description
        self.extended_status_info = extended_status_info
        self.billing_plan = billing_plan
        self.split_properties = split_properties
        self.merge_properties = merge_properties
        self.billing_scope_id = billing_scope_id
        self.renew = renew
        self.renew_source = renew_source
        self.renew_destination = renew_destination
        self.renew_properties = renew_properties
        self.term = term


class ReservationResponse(Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation
    :vartype id: str
    :ivar name: Name of the reservation
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource.
     "Microsoft.Capacity/reservationOrders/reservations"
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, etag: int=None, sku=None, properties=None, **kwargs) -> None:
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = etag
        self.id = None
        self.name = None
        self.sku = sku
        self.properties = properties
        self.type = None


class ReservationSplitProperties(Model):
    """ReservationSplitProperties.

    :param split_destinations: List of destination Resource Id that are
     created due to split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_destinations: list[str]
    :param split_source: Resource Id of the Reservation from which this is
     split. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type split_source: str
    """

    _attribute_map = {
        'split_destinations': {'key': 'splitDestinations', 'type': '[str]'},
        'split_source': {'key': 'splitSource', 'type': 'str'},
    }

    def __init__(self, *, split_destinations=None, split_source: str=None, **kwargs) -> None:
        super(ReservationSplitProperties, self).__init__(**kwargs)
        self.split_destinations = split_destinations
        self.split_source = split_source


class ReservationToExchange(Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being
     returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information:
    :type billing_information:
     ~azure.mgmt.reservations.models.BillingInformation
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
    }

    def __init__(self, *, reservation_id: str=None, quantity: int=None, billing_refund_amount=None, billing_information=None, **kwargs) -> None:
        super(ReservationToExchange, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity
        self.billing_refund_amount = billing_refund_amount
        self.billing_information = billing_information


class ReservationToPurchaseCalculateExchange(Model):
    """Reservation purchase details.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
    }

    def __init__(self, *, properties=None, billing_currency_total=None, **kwargs) -> None:
        super(ReservationToPurchaseCalculateExchange, self).__init__(**kwargs)
        self.properties = properties
        self.billing_currency_total = billing_currency_total


class ReservationToPurchaseExchange(Model):
    """Reservation purchase details.

    :param reservation_order_id: Fully qualified id of the ReservationOrder
     being purchased
    :type reservation_order_id: str
    :param reservation_id: Fully qualified id of the Reservation being
     purchased. This value is only guaranteed to be non-null if the purchase is
     successful.
    :type reservation_id: str
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param status: Possible values include: 'Succeeded', 'Failed',
     'Cancelled', 'Pending'
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, reservation_order_id: str=None, reservation_id: str=None, properties=None, billing_currency_total=None, status=None, **kwargs) -> None:
        super(ReservationToPurchaseExchange, self).__init__(**kwargs)
        self.reservation_order_id = reservation_order_id
        self.reservation_id = reservation_id
        self.properties = properties
        self.billing_currency_total = billing_currency_total
        self.status = status


class ReservationToReturn(Model):
    """Reservation to return.

    :param reservation_id: Fully qualified identifier of the Reservation being
     returned
    :type reservation_id: str
    :param quantity: Quantity to be returned. Must be greater than zero.
    :type quantity: int
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
    }

    def __init__(self, *, reservation_id: str=None, quantity: int=None, **kwargs) -> None:
        super(ReservationToReturn, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity


class ReservationToReturnForExchange(Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being
     returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information:
    :type billing_information:
     ~azure.mgmt.reservations.models.BillingInformation
    :param status: Possible values include: 'Succeeded', 'Failed',
     'Cancelled', 'Pending'
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, reservation_id: str=None, quantity: int=None, billing_refund_amount=None, billing_information=None, status=None, **kwargs) -> None:
        super(ReservationToReturnForExchange, self).__init__(**kwargs)
        self.reservation_id = reservation_id
        self.quantity = quantity
        self.billing_refund_amount = billing_refund_amount
        self.billing_information = billing_information
        self.status = status


class ResourceName(Model):
    """Resource name provided by the resource provider. Use this property for
    quotaRequest parameter.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: Resource name.
    :type value: str
    :ivar localized_value: Resource display localized name.
    :vartype localized_value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, **kwargs) -> None:
        super(ResourceName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = None


class ScopeProperties(Model):
    """ScopeProperties.

    :param scope:
    :type scope: str
    :param valid:
    :type valid: bool
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
    }

    def __init__(self, *, scope: str=None, valid: bool=None, **kwargs) -> None:
        super(ScopeProperties, self).__init__(**kwargs)
        self.scope = scope
        self.valid = valid


class ServiceError(Model):
    """The API error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param code: The error code.
    :type code: str
    :param message: The error message text.
    :type message: str
    :ivar details: The list of error details.
    :vartype details: list[~azure.mgmt.reservations.models.ServiceErrorDetail]
    """

    _validation = {
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ServiceErrorDetail]'},
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(ServiceError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = None


class ServiceErrorDetail(Model):
    """The error details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServiceErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class SkuName(Model):
    """SkuName.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(SkuName, self).__init__(**kwargs)
        self.name = name


class SkuProperty(Model):
    """SkuProperty.

    :param name: An invariant to describe the feature.
    :type name: str
    :param value: An invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, value: str=None, **kwargs) -> None:
        super(SkuProperty, self).__init__(**kwargs)
        self.name = name
        self.value = value


class SkuRestriction(Model):
    """SkuRestriction.

    :param type: The type of restrictions.
    :type type: str
    :param values: The value of restrictions. If the restriction type is set
     to location. This would be different locations where the SKU is
     restricted.
    :type values: list[str]
    :param reason_code: The reason for restriction.
    :type reason_code: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(self, *, type: str=None, values=None, reason_code: str=None, **kwargs) -> None:
        super(SkuRestriction, self).__init__(**kwargs)
        self.type = type
        self.values = values
        self.reason_code = reason_code


class SplitRequest(Model):
    """SplitRequest.

    :param quantities: List of the quantities in the new reservations to
     create.
    :type quantities: list[int]
    :param reservation_id: Resource id of the reservation to be split. Format
     of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}
    :type reservation_id: str
    """

    _attribute_map = {
        'quantities': {'key': 'properties.quantities', 'type': '[int]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
    }

    def __init__(self, *, quantities=None, reservation_id: str=None, **kwargs) -> None:
        super(SplitRequest, self).__init__(**kwargs)
        self.quantities = quantities
        self.reservation_id = reservation_id


class SubRequest(Model):
    """The sub-request submitted with the quota request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: Quota (resource limit).
    :vartype limit: int
    :param name: The resource name.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :ivar resource_type: Resource type for which the quota check was made.
    :vartype resource_type: str
    :param unit:  The limit units, such as **count** and **bytes**. Use the
     unit field provided in the response of the GET quota operation.
    :type unit: str
    :param provisioning_state: The quota request status.
    :type provisioning_state: object
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar sub_request_id: Sub request ID for individual request.
    :vartype sub_request_id: str
    """

    _validation = {
        'limit': {'readonly': True},
        'resource_type': {'readonly': True},
        'message': {'readonly': True},
        'sub_request_id': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'object'},
        'message': {'key': 'message', 'type': 'str'},
        'sub_request_id': {'key': 'subRequestId', 'type': 'str'},
    }

    def __init__(self, *, name=None, unit: str=None, provisioning_state=None, **kwargs) -> None:
        super(SubRequest, self).__init__(**kwargs)
        self.limit = None
        self.name = name
        self.resource_type = None
        self.unit = unit
        self.provisioning_state = provisioning_state
        self.message = None
        self.sub_request_id = None


class SubscriptionScopeProperties(Model):
    """SubscriptionScopeProperties.

    :param scopes:
    :type scopes: list[~azure.mgmt.reservations.models.ScopeProperties]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[ScopeProperties]'},
    }

    def __init__(self, *, scopes=None, **kwargs) -> None:
        super(SubscriptionScopeProperties, self).__init__(**kwargs)
        self.scopes = scopes
