# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdvancedFilter(Model):
    """This is the base type that represents an advanced filter. To configure an
    advanced filter, do not directly instantiate an object of this class.
    Instead, instantiate an object of a derived class such as
    BoolEqualsAdvancedFilter, NumberInAdvancedFilter,
    StringEqualsAdvancedFilter etc. depending on the type of the key based on
    which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: NumberInAdvancedFilter, NumberNotInAdvancedFilter,
    NumberLessThanAdvancedFilter, NumberGreaterThanAdvancedFilter,
    NumberLessThanOrEqualsAdvancedFilter,
    NumberGreaterThanOrEqualsAdvancedFilter, BoolEqualsAdvancedFilter,
    StringInAdvancedFilter, StringNotInAdvancedFilter,
    StringBeginsWithAdvancedFilter, StringEndsWithAdvancedFilter,
    StringContainsAdvancedFilter, NumberInRangeAdvancedFilter,
    NumberNotInRangeAdvancedFilter, StringNotBeginsWithAdvancedFilter,
    StringNotEndsWithAdvancedFilter, StringNotContainsAdvancedFilter,
    IsNullOrUndefinedAdvancedFilter, IsNotNullAdvancedFilter

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
    }

    _subtype_map = {
        'operator_type': {'NumberIn': 'NumberInAdvancedFilter', 'NumberNotIn': 'NumberNotInAdvancedFilter', 'NumberLessThan': 'NumberLessThanAdvancedFilter', 'NumberGreaterThan': 'NumberGreaterThanAdvancedFilter', 'NumberLessThanOrEquals': 'NumberLessThanOrEqualsAdvancedFilter', 'NumberGreaterThanOrEquals': 'NumberGreaterThanOrEqualsAdvancedFilter', 'BoolEquals': 'BoolEqualsAdvancedFilter', 'StringIn': 'StringInAdvancedFilter', 'StringNotIn': 'StringNotInAdvancedFilter', 'StringBeginsWith': 'StringBeginsWithAdvancedFilter', 'StringEndsWith': 'StringEndsWithAdvancedFilter', 'StringContains': 'StringContainsAdvancedFilter', 'NumberInRange': 'NumberInRangeAdvancedFilter', 'NumberNotInRange': 'NumberNotInRangeAdvancedFilter', 'StringNotBeginsWith': 'StringNotBeginsWithAdvancedFilter', 'StringNotEndsWith': 'StringNotEndsWithAdvancedFilter', 'StringNotContains': 'StringNotContainsAdvancedFilter', 'IsNullOrUndefined': 'IsNullOrUndefinedAdvancedFilter', 'IsNotNull': 'IsNotNullAdvancedFilter'}
    }

    def __init__(self, *, key: str=None, **kwargs) -> None:
        super(AdvancedFilter, self).__init__(**kwargs)
        self.key = key
        self.operator_type = None


class EventSubscriptionDestination(Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: WebHookEventSubscriptionDestination,
    EventHubEventSubscriptionDestination,
    StorageQueueEventSubscriptionDestination,
    HybridConnectionEventSubscriptionDestination,
    ServiceBusQueueEventSubscriptionDestination,
    ServiceBusTopicEventSubscriptionDestination,
    AzureFunctionEventSubscriptionDestination

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'WebHook': 'WebHookEventSubscriptionDestination', 'EventHub': 'EventHubEventSubscriptionDestination', 'StorageQueue': 'StorageQueueEventSubscriptionDestination', 'HybridConnection': 'HybridConnectionEventSubscriptionDestination', 'ServiceBusQueue': 'ServiceBusQueueEventSubscriptionDestination', 'ServiceBusTopic': 'ServiceBusTopicEventSubscriptionDestination', 'AzureFunction': 'AzureFunctionEventSubscriptionDestination'}
    }

    def __init__(self, **kwargs) -> None:
        super(EventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = None


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Azure Function destination of an event subscription.
    :type resource_id: str
    :param max_events_per_batch: Maximum number of events per batch. Default
     value: 1 .
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in
     Kilobytes. Default value: 64 .
    :type preferred_batch_size_in_kilobytes: int
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, resource_id: str=None, max_events_per_batch: int=1, preferred_batch_size_in_kilobytes: int=64, delivery_attribute_mappings=None, **kwargs) -> None:
        super(AzureFunctionEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'AzureFunction'


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The boolean filter value.
    :type value: bool
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(self, *, key: str=None, value: bool=None, **kwargs) -> None:
        super(BoolEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.value = value
        self.operator_type = 'BoolEquals'


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConnectionState(Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include:
     'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    :param actions_required: Actions required (if any).
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, actions_required: str=None, **kwargs) -> None:
        super(ConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class DeadLetterDestination(Model):
    """Information about the dead letter destination for an event subscription. To
    configure a deadletter destination, do not directly instantiate an object
    of this class. Instead, instantiate an object of a derived class.
    Currently, StorageBlobDeadLetterDestination is the only class that derives
    from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StorageBlobDeadLetterDestination

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'StorageBlob': 'StorageBlobDeadLetterDestination'}
    }

    def __init__(self, **kwargs) -> None:
        super(DeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = None


class DeadLetterWithResourceIdentity(Model):
    """Information about the deadletter destination with resource identity.

    :param identity: The identity to use when dead-lettering events.
    :type identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :param dead_letter_destination: Information about the destination where
     events have to be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or
     domain) to acquire the authentication tokens being used during delivery /
     dead-lettering.
    :type dead_letter_destination:
     ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'EventSubscriptionIdentity'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(self, *, identity=None, dead_letter_destination=None, **kwargs) -> None:
        super(DeadLetterWithResourceIdentity, self).__init__(**kwargs)
        self.identity = identity
        self.dead_letter_destination = dead_letter_destination


class DeliveryAttributeListResult(Model):
    """Result of the Get delivery attributes operation.

    :param value: A collection of DeliveryAttributeMapping
    :type value: list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(DeliveryAttributeListResult, self).__init__(**kwargs)
        self.value = value


class DeliveryAttributeMapping(Model):
    """Delivery attribute mapping details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StaticDeliveryAttributeMapping,
    DynamicDeliveryAttributeMapping

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Static': 'StaticDeliveryAttributeMapping', 'Dynamic': 'DynamicDeliveryAttributeMapping'}
    }

    def __init__(self, *, name: str=None, **kwargs) -> None:
        super(DeliveryAttributeMapping, self).__init__(**kwargs)
        self.name = name
        self.type = None


class DeliveryWithResourceIdentity(Model):
    """Information about the delivery for an event subscription with resource
    identity.

    :param identity: The identity to use when delivering events.
    :type identity: ~azure.mgmt.eventgrid.models.EventSubscriptionIdentity
    :param destination: Information about the destination where events have to
     be delivered for the event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens
     being used during delivery / dead-lettering.
    :type destination:
     ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'EventSubscriptionIdentity'},
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
    }

    def __init__(self, *, identity=None, destination=None, **kwargs) -> None:
        super(DeliveryWithResourceIdentity, self).__init__(**kwargs)
        self.identity = identity
        self.destination = destination


class Resource(Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections: List of private endpoint connections.
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the domain. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar endpoint: Endpoint for the domain.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should
     expect for incoming events published to the domain. Possible values
     include: 'EventGridSchema', 'CustomEventSchema', 'CloudEventSchemaV1_0'.
     Default value: "EventGridSchema" .
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: Information about the InputSchemaMapping
     which specified the info about mapping event payload.
    :type input_schema_mapping:
     ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the domain.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over
     public network. By default it is enabled.
     You can further restrict to specific IPs by configuring <seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
     />. Possible values include: 'Enabled', 'Disabled'. Default value:
     "Enabled" .
    :type public_network_access: str or
     ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from
     specific IPs instead of all IPs. Note: These are considered only if
     PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :param sku: The Sku pricing tier for the domain.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to Domain resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, private_endpoint_connections=None, input_schema="EventGridSchema", input_schema_mapping=None, public_network_access="Enabled", inbound_ip_rules=None, sku=None, identity=None, **kwargs) -> None:
        super(Domain, self).__init__(location=location, tags=tags, **kwargs)
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.sku = sku
        self.identity = identity
        self.system_data = None


class DomainRegenerateKeyRequest(Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, *, key_name: str, **kwargs) -> None:
        super(DomainRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class DomainSharedAccessKeys(Model):
    """Shared access keys of the Domain.

    :param key1: Shared access key1 for the domain.
    :type key1: str
    :param key2: Shared access key2 for the domain.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(self, *, key1: str=None, key2: str=None, **kwargs) -> None:
        super(DomainSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provisioning_state: Provisioning state of the domain topic.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    :ivar system_data: The system metadata relating to Domain Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, provisioning_state=None, **kwargs) -> None:
        super(DomainTopic, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.system_data = None


class DomainUpdateParameters(Model):
    """Properties of the Domain update.

    :param tags: Tags of the domains resource.
    :type tags: dict[str, str]
    :param public_network_access: This determines if traffic is allowed over
     public network. By default it is enabled.
     You can further restrict to specific IPs by configuring <seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"
     />. Possible values include: 'Enabled', 'Disabled'. Default value:
     "Enabled" .
    :type public_network_access: str or
     ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from
     specific IPs instead of all IPs. Note: These are considered only if
     PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param sku: The Sku pricing tier for the domain.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
    }

    def __init__(self, *, tags=None, public_network_access="Enabled", inbound_ip_rules=None, identity=None, sku=None, **kwargs) -> None:
        super(DomainUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.identity = identity
        self.sku = sku


class DynamicDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Dynamic delivery attribute mapping details.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param source_field: JSON path in the event which contains attribute
     value.
    :type source_field: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'source_field': {'key': 'properties.sourceField', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, source_field: str=None, **kwargs) -> None:
        super(DynamicDeliveryAttributeMapping, self).__init__(name=name, **kwargs)
        self.source_field = source_field
        self.type = 'Dynamic'


class EventChannel(Resource):
    """Event Channel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param source: Source of the event channel. This represents a unique
     resource in the partner's resource model.
    :type source: ~azure.mgmt.eventgrid.models.EventChannelSource
    :param destination: Represents the destination of an event channel.
    :type destination: ~azure.mgmt.eventgrid.models.EventChannelDestination
    :ivar provisioning_state: Provisioning state of the event channel.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventChannelProvisioningState
    :ivar partner_topic_readiness_state: The readiness state of the
     corresponding partner topic. Possible values include:
     'NotActivatedByUserYet', 'ActivatedByUser', 'DeactivatedByUser',
     'DeletedByUser'
    :vartype partner_topic_readiness_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicReadinessState
    :param expiration_time_if_not_activated_utc: Expiration time of the event
     channel. If this timer expires while the corresponding partner topic is
     never activated,
     the event channel and corresponding partner topic are deleted.
    :type expiration_time_if_not_activated_utc: datetime
    :param filter: Information about the filter for the event channel.
    :type filter: ~azure.mgmt.eventgrid.models.EventChannelFilter
    :param partner_topic_friendly_description: Friendly description about the
     topic. This can be set by the publisher/partner to show custom description
     for the customer partner topic.
     This will be helpful to remove any ambiguity of the origin of creation of
     the partner topic for the customer.
    :type partner_topic_friendly_description: str
    :ivar system_data: The system metadata relating to Event Channel resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'partner_topic_readiness_state': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'EventChannelSource'},
        'destination': {'key': 'properties.destination', 'type': 'EventChannelDestination'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_topic_readiness_state': {'key': 'properties.partnerTopicReadinessState', 'type': 'str'},
        'expiration_time_if_not_activated_utc': {'key': 'properties.expirationTimeIfNotActivatedUtc', 'type': 'iso-8601'},
        'filter': {'key': 'properties.filter', 'type': 'EventChannelFilter'},
        'partner_topic_friendly_description': {'key': 'properties.partnerTopicFriendlyDescription', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, source=None, destination=None, expiration_time_if_not_activated_utc=None, filter=None, partner_topic_friendly_description: str=None, **kwargs) -> None:
        super(EventChannel, self).__init__(**kwargs)
        self.source = source
        self.destination = destination
        self.provisioning_state = None
        self.partner_topic_readiness_state = None
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.filter = filter
        self.partner_topic_friendly_description = partner_topic_friendly_description
        self.system_data = None


class EventChannelDestination(Model):
    """Properties of the destination of an event channel.

    :param azure_subscription_id: Azure subscription ID of the customer
     creating the event channel. The partner topic
     associated with the event channel will be created under this Azure
     subscription.
    :type azure_subscription_id: str
    :param resource_group: Azure Resource Group of the customer creating the
     event channel. The partner topic
     associated with the event channel will be created under this resource
     group.
    :type resource_group: str
    :param partner_topic_name: Name of the partner topic associated with the
     event channel.
    :type partner_topic_name: str
    """

    _attribute_map = {
        'azure_subscription_id': {'key': 'azureSubscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'partner_topic_name': {'key': 'partnerTopicName', 'type': 'str'},
    }

    def __init__(self, *, azure_subscription_id: str=None, resource_group: str=None, partner_topic_name: str=None, **kwargs) -> None:
        super(EventChannelDestination, self).__init__(**kwargs)
        self.azure_subscription_id = azure_subscription_id
        self.resource_group = resource_group
        self.partner_topic_name = partner_topic_name


class EventChannelFilter(Model):
    """Filter for the Event Channel.

    :param enable_advanced_filtering_on_arrays: Allows advanced filters to be
     evaluated against an array of values instead of expecting a singular
     value.
    :type enable_advanced_filtering_on_arrays: bool
    :param advanced_filters: An array of advanced filters that are used for
     filtering event channels.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'enable_advanced_filtering_on_arrays': {'key': 'enableAdvancedFilteringOnArrays', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(self, *, enable_advanced_filtering_on_arrays: bool=None, advanced_filters=None, **kwargs) -> None:
        super(EventChannelFilter, self).__init__(**kwargs)
        self.enable_advanced_filtering_on_arrays = enable_advanced_filtering_on_arrays
        self.advanced_filters = advanced_filters


class EventChannelSource(Model):
    """Properties of the source of an event channel.

    :param source: The identifier of the resource that's the source of the
     events.
     This represents a unique resource in the partner's resource model.
    :type source: str
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(self, *, source: str=None, **kwargs) -> None:
        super(EventChannelSource, self).__init__(**kwargs)
        self.source = source


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     an Event Hub destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, resource_id: str=None, delivery_attribute_mappings=None, **kwargs) -> None:
        super(EventHubEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'EventHub'


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed', 'AwaitingManualAction'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :param destination: Information about the destination where events have to
     be delivered for the event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens
     being used during delivery / dead-lettering.
    :type destination:
     ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param delivery_with_resource_identity: Information about the destination
     where events have to be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (namely, topic or
     domain) to acquire the authentication tokens being used during delivery /
     dead-lettering.
    :type delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Expiration time of the event subscription.
    :type expiration_time_utc: datetime
    :param event_delivery_schema: The event delivery schema for the event
     subscription. Possible values include: 'EventGridSchema',
     'CustomInputSchema', 'CloudEventSchemaV1_0'. Default value:
     "EventGridSchema" .
    :type event_delivery_schema: str or
     ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to
     configure maximum number of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is
     sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens
     being used during delivery / dead-lettering.
    :type dead_letter_destination:
     ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :param dead_letter_with_resource_identity: The dead letter destination of
     the event subscription. Any event that cannot be delivered to its'
     destination is sent to the dead letter destination.
     Uses the managed identity setup on the parent resource (namely, topic or
     domain) to acquire the authentication tokens being used during delivery /
     dead-lettering.
    :type dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    :ivar system_data: The system metadata relating to Event Subscription
     resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'topic': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'topic': {'key': 'properties.topic', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'EventSubscriptionDestination'},
        'delivery_with_resource_identity': {'key': 'properties.deliveryWithResourceIdentity', 'type': 'DeliveryWithResourceIdentity'},
        'filter': {'key': 'properties.filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'properties.expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'properties.eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'properties.retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'properties.deadLetterDestination', 'type': 'DeadLetterDestination'},
        'dead_letter_with_resource_identity': {'key': 'properties.deadLetterWithResourceIdentity', 'type': 'DeadLetterWithResourceIdentity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, destination=None, delivery_with_resource_identity=None, filter=None, labels=None, expiration_time_utc=None, event_delivery_schema="EventGridSchema", retry_policy=None, dead_letter_destination=None, dead_letter_with_resource_identity=None, **kwargs) -> None:
        super(EventSubscription, self).__init__(**kwargs)
        self.topic = None
        self.provisioning_state = None
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity
        self.system_data = None


class EventSubscriptionFilter(Model):
    """Filter for the Event Subscription.

    :param subject_begins_with: An optional string to filter events for an
     event subscription based on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :type subject_begins_with: str
    :param subject_ends_with: An optional string to filter events for an event
     subscription based on a resource path suffix.
     Wildcard characters are not supported in this path.
    :type subject_ends_with: str
    :param included_event_types: A list of applicable event types that need to
     be part of the event subscription. If it is desired to subscribe to all
     default event types, set the IncludedEventTypes to null.
    :type included_event_types: list[str]
    :param is_subject_case_sensitive: Specifies if the SubjectBeginsWith and
     SubjectEndsWith properties of the filter
     should be compared in a case sensitive manner. Default value: False .
    :type is_subject_case_sensitive: bool
    :param enable_advanced_filtering_on_arrays: Allows advanced filters to be
     evaluated against an array of values instead of expecting a singular
     value.
    :type enable_advanced_filtering_on_arrays: bool
    :param advanced_filters: An array of advanced filters that are used for
     filtering event subscriptions.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'subject_begins_with': {'key': 'subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'subjectEndsWith', 'type': 'str'},
        'included_event_types': {'key': 'includedEventTypes', 'type': '[str]'},
        'is_subject_case_sensitive': {'key': 'isSubjectCaseSensitive', 'type': 'bool'},
        'enable_advanced_filtering_on_arrays': {'key': 'enableAdvancedFilteringOnArrays', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(self, *, subject_begins_with: str=None, subject_ends_with: str=None, included_event_types=None, is_subject_case_sensitive: bool=False, enable_advanced_filtering_on_arrays: bool=None, advanced_filters=None, **kwargs) -> None:
        super(EventSubscriptionFilter, self).__init__(**kwargs)
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.included_event_types = included_event_types
        self.is_subject_case_sensitive = is_subject_case_sensitive
        self.enable_advanced_filtering_on_arrays = enable_advanced_filtering_on_arrays
        self.advanced_filters = advanced_filters


class EventSubscriptionFullUrl(Model):
    """Full endpoint url of an event subscription.

    :param endpoint_url: The URL that represents the endpoint of the
     destination of an event subscription.
    :type endpoint_url: str
    """

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
    }

    def __init__(self, *, endpoint_url: str=None, **kwargs) -> None:
        super(EventSubscriptionFullUrl, self).__init__(**kwargs)
        self.endpoint_url = endpoint_url


class EventSubscriptionIdentity(Model):
    """The identity information with the event subscription.

    :param type: The type of managed identity used. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of
     user-assigned identities. The type 'None' will remove any identity.
     Possible values include: 'SystemAssigned', 'UserAssigned'
    :type type: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionIdentityType
    :param user_assigned_identity: The user identity associated with the
     resource.
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(self, *, type=None, user_assigned_identity: str=None, **kwargs) -> None:
        super(EventSubscriptionIdentity, self).__init__(**kwargs)
        self.type = type
        self.user_assigned_identity = user_assigned_identity


class EventSubscriptionUpdateParameters(Model):
    """Properties of the Event Subscription update.

    :param destination: Information about the destination where events have to
     be delivered for the event subscription.
     Uses Azure Event Grid's identity to acquire the authentication tokens
     being used during delivery / dead-lettering.
    :type destination:
     ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param delivery_with_resource_identity: Information about the destination
     where events have to be delivered for the event subscription.
     Uses the managed identity setup on the parent resource (topic / domain) to
     acquire the authentication tokens being used during delivery /
     dead-lettering.
    :type delivery_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeliveryWithResourceIdentity
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Information about the expiration time for the
     event subscription.
    :type expiration_time_utc: datetime
    :param event_delivery_schema: The event delivery schema for the event
     subscription. Possible values include: 'EventGridSchema',
     'CustomInputSchema', 'CloudEventSchemaV1_0'
    :type event_delivery_schema: str or
     ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to
     configure maximum number of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The dead letter destination of the event
     subscription. Any event that cannot be delivered to its' destination is
     sent to the dead letter destination.
     Uses Azure Event Grid's identity to acquire the authentication tokens
     being used during delivery / dead-lettering.
    :type dead_letter_destination:
     ~azure.mgmt.eventgrid.models.DeadLetterDestination
    :param dead_letter_with_resource_identity: The dead letter destination of
     the event subscription. Any event that cannot be delivered to its'
     destination is sent to the dead letter destination.
     Uses the managed identity setup on the parent resource (topic / domain) to
     acquire the authentication tokens being used during delivery /
     dead-lettering.
    :type dead_letter_with_resource_identity:
     ~azure.mgmt.eventgrid.models.DeadLetterWithResourceIdentity
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
        'delivery_with_resource_identity': {'key': 'deliveryWithResourceIdentity', 'type': 'DeliveryWithResourceIdentity'},
        'filter': {'key': 'filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
        'dead_letter_with_resource_identity': {'key': 'deadLetterWithResourceIdentity', 'type': 'DeadLetterWithResourceIdentity'},
    }

    def __init__(self, *, destination=None, delivery_with_resource_identity=None, filter=None, labels=None, expiration_time_utc=None, event_delivery_schema=None, retry_policy=None, dead_letter_destination=None, dead_letter_with_resource_identity=None, **kwargs) -> None:
        super(EventSubscriptionUpdateParameters, self).__init__(**kwargs)
        self.destination = destination
        self.delivery_with_resource_identity = delivery_with_resource_identity
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination
        self.dead_letter_with_resource_identity = dead_letter_with_resource_identity


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param display_name: Display name of the event type.
    :type display_name: str
    :param description: Description of the event type.
    :type description: str
    :param schema_url: Url of the schema for this event type.
    :type schema_url: str
    :param is_in_default_set: IsInDefaultSet flag of the event type.
    :type is_in_default_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema_url': {'key': 'properties.schemaUrl', 'type': 'str'},
        'is_in_default_set': {'key': 'properties.isInDefaultSet', 'type': 'bool'},
    }

    def __init__(self, *, display_name: str=None, description: str=None, schema_url: str=None, is_in_default_set: bool=None, **kwargs) -> None:
        super(EventType, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.schema_url = schema_url
        self.is_in_default_set = is_in_default_set


class ExtendedLocation(Model):
    """Definition of an Extended Location.

    :param name: Fully qualified name of the extended location.
    :type name: str
    :param type: Type of the extended location.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, type: str=None, **kwargs) -> None:
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class ExtensionTopic(Resource):
    """Event grid Extension Topic. This is used for getting Event Grid related
    metrics for Azure resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param description: Description of the extension topic.
    :type description: str
    :param system_topic: System topic resource id which is mapped to the
     source.
    :type system_topic: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'system_topic': {'key': 'properties.systemTopic', 'type': 'str'},
    }

    def __init__(self, *, description: str=None, system_topic: str=None, **kwargs) -> None:
        super(ExtensionTopic, self).__init__(**kwargs)
        self.description = description
        self.system_topic = system_topic


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the HybridConnection destination for an event
    subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of an hybrid connection that is
     the destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, resource_id: str=None, delivery_attribute_mappings=None, **kwargs) -> None:
        super(HybridConnectionEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'HybridConnection'


class IdentityInfo(Model):
    """The identity information for the resource.

    :param type: The type of managed identity used. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of
     user-assigned identities. The type 'None' will remove any identity.
     Possible values include: 'None', 'SystemAssigned', 'UserAssigned',
     'SystemAssigned, UserAssigned'
    :type type: str or ~azure.mgmt.eventgrid.models.IdentityType
    :param principal_id: The principal ID of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant ID of resource.
    :type tenant_id: str
    :param user_assigned_identities: The list of user identities associated
     with the resource. The user identity dictionary key references will be ARM
     resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     This property is currently not used and reserved for future usage.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.eventgrid.models.UserIdentityProperties]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserIdentityProperties}'},
    }

    def __init__(self, *, type=None, principal_id: str=None, tenant_id: str=None, user_assigned_identities=None, **kwargs) -> None:
        super(IdentityInfo, self).__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.user_assigned_identities = user_assigned_identities


class InboundIpRule(Model):
    """InboundIpRule.

    :param ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :type ip_mask: str
    :param action: Action to perform based on the match or no match of the
     IpMask. Possible values include: 'Allow'
    :type action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, *, ip_mask: str=None, action=None, **kwargs) -> None:
        super(InboundIpRule, self).__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class InputSchemaMapping(Model):
    """By default, Event Grid expects events to be in the Event Grid event schema.
    Specifying an input schema mapping enables publishing to Event Grid using a
    custom input schema. Currently, the only supported type of
    InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JsonInputSchemaMapping

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Constant filled by server.
    :type input_schema_mapping_type: str
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
    }

    _subtype_map = {
        'input_schema_mapping_type': {'Json': 'JsonInputSchemaMapping'}
    }

    def __init__(self, **kwargs) -> None:
        super(InputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = None


class IsNotNullAdvancedFilter(AdvancedFilter):
    """IsNotNull Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
    }

    def __init__(self, *, key: str=None, **kwargs) -> None:
        super(IsNotNullAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'IsNotNull'


class IsNullOrUndefinedAdvancedFilter(AdvancedFilter):
    """IsNullOrUndefined Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
    }

    def __init__(self, *, key: str=None, **kwargs) -> None:
        super(IsNullOrUndefinedAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'IsNullOrUndefined'


class JsonField(Model):
    """This is used to express the source of an input schema mapping for a single
    target field in the Event Grid Event schema. This is currently used in the
    mappings for the 'id', 'topic' and 'eventtime' properties. This represents
    a field in the input event schema.

    :param source_field: Name of a field in the input event schema that's to
     be used as the source of a mapping.
    :type source_field: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
    }

    def __init__(self, *, source_field: str=None, **kwargs) -> None:
        super(JsonField, self).__init__(**kwargs)
        self.source_field = source_field


class JsonFieldWithDefault(Model):
    """This is used to express the source of an input schema mapping for a single
    target field
    in the Event Grid Event schema. This is currently used in the mappings for
    the 'subject',
    'eventtype' and 'dataversion' properties. This represents a field in the
    input event schema
    along with a default value to be used, and at least one of these two
    properties should be provided.

    :param source_field: Name of a field in the input event schema that's to
     be used as the source of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a
     SourceField is not provided or if there's no property with the specified
     name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(self, *, source_field: str=None, default_value: str=None, **kwargs) -> None:
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = source_field
        self.default_value = default_value


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can
    be used to map properties from a custom input JSON schema to the Event Grid
    event schema.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Constant filled by server.
    :type input_schema_mapping_type: str
    :param id: The mapping information for the Id property of the Event Grid
     Event.
    :type id: ~azure.mgmt.eventgrid.models.JsonField
    :param topic: The mapping information for the Topic property of the Event
     Grid Event.
    :type topic: ~azure.mgmt.eventgrid.models.JsonField
    :param event_time: The mapping information for the EventTime property of
     the Event Grid Event.
    :type event_time: ~azure.mgmt.eventgrid.models.JsonField
    :param event_type: The mapping information for the EventType property of
     the Event Grid Event.
    :type event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param subject: The mapping information for the Subject property of the
     Event Grid Event.
    :type subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param data_version: The mapping information for the DataVersion property
     of the Event Grid Event.
    :type data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'JsonField'},
        'topic': {'key': 'properties.topic', 'type': 'JsonField'},
        'event_time': {'key': 'properties.eventTime', 'type': 'JsonField'},
        'event_type': {'key': 'properties.eventType', 'type': 'JsonFieldWithDefault'},
        'subject': {'key': 'properties.subject', 'type': 'JsonFieldWithDefault'},
        'data_version': {'key': 'properties.dataVersion', 'type': 'JsonFieldWithDefault'},
    }

    def __init__(self, *, id=None, topic=None, event_time=None, event_type=None, subject=None, data_version=None, **kwargs) -> None:
        super(JsonInputSchemaMapping, self).__init__(**kwargs)
        self.id = id
        self.topic = topic
        self.event_time = event_time
        self.event_type = event_type
        self.subject = subject
        self.data_version = data_version
        self.input_schema_mapping_type = 'Json'


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, *, key: str=None, value: float=None, **kwargs) -> None:
        super(NumberGreaterThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.value = value
        self.operator_type = 'NumberGreaterThan'


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, *, key: str=None, value: float=None, **kwargs) -> None:
        super(NumberGreaterThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.value = value
        self.operator_type = 'NumberGreaterThanOrEquals'


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(NumberInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'NumberIn'


class NumberInRangeAdvancedFilter(AdvancedFilter):
    """NumberInRange Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[list[float]]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[[float]]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(NumberInRangeAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'NumberInRange'


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, *, key: str=None, value: float=None, **kwargs) -> None:
        super(NumberLessThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.value = value
        self.operator_type = 'NumberLessThan'


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, *, key: str=None, value: float=None, **kwargs) -> None:
        super(NumberLessThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.value = value
        self.operator_type = 'NumberLessThanOrEquals'


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(NumberNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'NumberNotIn'


class NumberNotInRangeAdvancedFilter(AdvancedFilter):
    """NumberNotInRange Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[list[float]]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[[float]]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(NumberNotInRangeAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'NumberNotInRange'


class Operation(Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation
    :type name: str
    :param display: Display name of the operation
    :type display: ~azure.mgmt.eventgrid.models.OperationInfo
    :param origin: Origin of the operation
    :type origin: str
    :param properties: Properties of the operation
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, name: str=None, display=None, origin: str=None, properties=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationInfo(Model):
    """Information about an operation.

    :param provider: Name of the provider
    :type provider: str
    :param resource: Name of the resource type
    :type resource: str
    :param operation: Name of the operation
    :type operation: str
    :param description: Description of the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class PartnerNamespace(TrackedResource):
    """EventGrid Partner Namespace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the partner namespace.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerNamespaceProvisioningState
    :param partner_registration_fully_qualified_id: The fully qualified ARM Id
     of the partner registration that should be associated with this partner
     namespace. This takes the following format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}.
    :type partner_registration_fully_qualified_id: str
    :ivar endpoint: Endpoint for the partner namespace.
    :vartype endpoint: str
    :ivar system_data: The system metadata relating to Partner Namespace
     resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_registration_fully_qualified_id': {'key': 'properties.partnerRegistrationFullyQualifiedId', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, partner_registration_fully_qualified_id: str=None, **kwargs) -> None:
        super(PartnerNamespace, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.partner_registration_fully_qualified_id = partner_registration_fully_qualified_id
        self.endpoint = None
        self.system_data = None


class PartnerNamespaceRegenerateKeyRequest(Model):
    """PartnerNamespace regenerate shared access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate (key1 or key2).
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, *, key_name: str, **kwargs) -> None:
        super(PartnerNamespaceRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class PartnerNamespaceSharedAccessKeys(Model):
    """Shared access keys of the partner namespace.

    :param key1: Shared access key1 for the partner namespace.
    :type key1: str
    :param key2: Shared access key2 for the partner namespace.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(self, *, key1: str=None, key2: str=None, **kwargs) -> None:
        super(PartnerNamespaceSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class PartnerNamespaceUpdateParameters(Model):
    """Properties of the PartnerNamespace update.

    :param tags: Tags of the partner namespace.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(PartnerNamespaceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class PartnerRegistration(TrackedResource):
    """Information about a partner registration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the partner registration.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerRegistrationProvisioningState
    :param partner_name: Official name of the partner name. For example:
     "Contoso".
    :type partner_name: str
    :param partner_resource_type_name: Name of the partner resource type.
    :type partner_resource_type_name: str
    :param partner_resource_type_display_name: Display name of the partner
     resource type.
    :type partner_resource_type_display_name: str
    :param partner_resource_type_description: Short description of the partner
     resource type. The length of this description should not exceed 256
     characters.
    :type partner_resource_type_description: str
    :param long_description: Long description for the custom scenarios and
     integration to be displayed in the portal if needed.
     Length of this description should not exceed 2048 characters.
    :type long_description: str
    :param partner_customer_service_number: The customer service number of the
     publisher. The expected phone format should start with a '+' sign
     followed by the country code. The remaining digits are then followed. Only
     digits and spaces are allowed and its
     length cannot exceed 16 digits including country code. Examples of valid
     phone numbers are: +1 515 123 4567 and
     +966 7 5115 2471. Examples of invalid phone numbers are: +1 (515)
     123-4567, 1 515 123 4567 and +966 121 5115 24 7 551 1234 43
    :type partner_customer_service_number: str
    :param partner_customer_service_extension: The extension of the customer
     service number of the publisher. Only digits are allowed and number of
     digits should not exceed 10.
    :type partner_customer_service_extension: str
    :param customer_service_uri: The extension of the customer service URI of
     the publisher.
    :type customer_service_uri: str
    :param setup_uri: URI of the partner website that can be used by Azure
     customers to setup Event Grid
     integration on an event source.
    :type setup_uri: str
    :param logo_uri: URI of the logo.
    :type logo_uri: str
    :param visibility_state: Visibility state of the partner registration.
     Possible values include: 'Hidden', 'PublicPreview', 'GenerallyAvailable'
    :type visibility_state: str or
     ~azure.mgmt.eventgrid.models.PartnerRegistrationVisibilityState
    :param authorized_azure_subscription_ids: List of Azure subscription Ids
     that are authorized to create a partner namespace
     associated with this partner registration. This is an optional property.
     Creating
     partner namespaces is always permitted under the same Azure subscription
     as the one used
     for creating the partner registration.
    :type authorized_azure_subscription_ids: list[str]
    :ivar system_data: The system metadata relating to Partner Registration
     resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'partner_name': {'key': 'properties.partnerName', 'type': 'str'},
        'partner_resource_type_name': {'key': 'properties.partnerResourceTypeName', 'type': 'str'},
        'partner_resource_type_display_name': {'key': 'properties.partnerResourceTypeDisplayName', 'type': 'str'},
        'partner_resource_type_description': {'key': 'properties.partnerResourceTypeDescription', 'type': 'str'},
        'long_description': {'key': 'properties.longDescription', 'type': 'str'},
        'partner_customer_service_number': {'key': 'properties.partnerCustomerServiceNumber', 'type': 'str'},
        'partner_customer_service_extension': {'key': 'properties.partnerCustomerServiceExtension', 'type': 'str'},
        'customer_service_uri': {'key': 'properties.customerServiceUri', 'type': 'str'},
        'setup_uri': {'key': 'properties.setupUri', 'type': 'str'},
        'logo_uri': {'key': 'properties.logoUri', 'type': 'str'},
        'visibility_state': {'key': 'properties.visibilityState', 'type': 'str'},
        'authorized_azure_subscription_ids': {'key': 'properties.authorizedAzureSubscriptionIds', 'type': '[str]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, partner_name: str=None, partner_resource_type_name: str=None, partner_resource_type_display_name: str=None, partner_resource_type_description: str=None, long_description: str=None, partner_customer_service_number: str=None, partner_customer_service_extension: str=None, customer_service_uri: str=None, setup_uri: str=None, logo_uri: str=None, visibility_state=None, authorized_azure_subscription_ids=None, **kwargs) -> None:
        super(PartnerRegistration, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.partner_name = partner_name
        self.partner_resource_type_name = partner_resource_type_name
        self.partner_resource_type_display_name = partner_resource_type_display_name
        self.partner_resource_type_description = partner_resource_type_description
        self.long_description = long_description
        self.partner_customer_service_number = partner_customer_service_number
        self.partner_customer_service_extension = partner_customer_service_extension
        self.customer_service_uri = customer_service_uri
        self.setup_uri = setup_uri
        self.logo_uri = logo_uri
        self.visibility_state = visibility_state
        self.authorized_azure_subscription_ids = authorized_azure_subscription_ids
        self.system_data = None


class PartnerRegistrationEventTypesListResult(Model):
    """Result of the List Partner Registration Event Types operation.

    :param value: A collection of partner registration event types.
    :type value: list[~azure.mgmt.eventgrid.models.EventType]
    :param next_link: A link for the next page of partner registration event
     types.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventType]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value=None, next_link: str=None, **kwargs) -> None:
        super(PartnerRegistrationEventTypesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PartnerRegistrationUpdateParameters(Model):
    """Properties of the Partner Registration update.

    :param tags: Tags of the partner registration resource.
    :type tags: dict[str, str]
    :param partner_topic_type_name: Name of the partner topic type.
    :type partner_topic_type_name: str
    :param partner_topic_type_display_name: Display name of the partner topic
     type.
    :type partner_topic_type_display_name: str
    :param partner_topic_type_description: Description of the partner topic
     type.
    :type partner_topic_type_description: str
    :param setup_uri: URI of the partner website that can be used by Azure
     customers to setup Event Grid
     integration on an event source.
    :type setup_uri: str
    :param logo_uri: URI of the partner logo.
    :type logo_uri: str
    :param authorized_azure_subscription_ids: List of IDs of Azure AD
     applications that are authorized to create a partner namespace
     associated with this partner registration. This is an optional property.
     Creating
     partner namespaces is always permitted under the same Azure subscription
     as the one used
     for creating the partner registration.
    :type authorized_azure_subscription_ids: list[str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'partner_topic_type_name': {'key': 'partnerTopicTypeName', 'type': 'str'},
        'partner_topic_type_display_name': {'key': 'partnerTopicTypeDisplayName', 'type': 'str'},
        'partner_topic_type_description': {'key': 'partnerTopicTypeDescription', 'type': 'str'},
        'setup_uri': {'key': 'setupUri', 'type': 'str'},
        'logo_uri': {'key': 'logoUri', 'type': 'str'},
        'authorized_azure_subscription_ids': {'key': 'authorizedAzureSubscriptionIds', 'type': '[str]'},
    }

    def __init__(self, *, tags=None, partner_topic_type_name: str=None, partner_topic_type_display_name: str=None, partner_topic_type_description: str=None, setup_uri: str=None, logo_uri: str=None, authorized_azure_subscription_ids=None, **kwargs) -> None:
        super(PartnerRegistrationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.partner_topic_type_name = partner_topic_type_name
        self.partner_topic_type_display_name = partner_topic_type_display_name
        self.partner_topic_type_description = partner_topic_type_description
        self.setup_uri = setup_uri
        self.logo_uri = logo_uri
        self.authorized_azure_subscription_ids = authorized_azure_subscription_ids


class PartnerTopic(TrackedResource):
    """EventGrid Partner Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :param source: Source associated with this partner topic. This represents
     a unique partner resource.
    :type source: str
    :param expiration_time_if_not_activated_utc: Expiration time of the
     partner topic. If this timer expires while the partner topic is still
     never activated,
     the partner topic and corresponding event channel are deleted.
    :type expiration_time_if_not_activated_utc: datetime
    :ivar provisioning_state: Provisioning state of the partner topic.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicProvisioningState
    :param activation_state: Activation state of the partner topic. Possible
     values include: 'NeverActivated', 'Activated', 'Deactivated'
    :type activation_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicActivationState
    :param partner_topic_friendly_description: Friendly description about the
     topic. This can be set by the publisher/partner to show custom description
     for the customer partner topic.
     This will be helpful to remove any ambiguity of the origin of creation of
     the partner topic for the customer.
    :type partner_topic_friendly_description: str
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to Partner Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'expiration_time_if_not_activated_utc': {'key': 'properties.expirationTimeIfNotActivatedUtc', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'activation_state': {'key': 'properties.activationState', 'type': 'str'},
        'partner_topic_friendly_description': {'key': 'properties.partnerTopicFriendlyDescription', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, source: str=None, expiration_time_if_not_activated_utc=None, activation_state=None, partner_topic_friendly_description: str=None, identity=None, **kwargs) -> None:
        super(PartnerTopic, self).__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.expiration_time_if_not_activated_utc = expiration_time_if_not_activated_utc
        self.provisioning_state = None
        self.activation_state = activation_state
        self.partner_topic_friendly_description = partner_topic_friendly_description
        self.identity = identity
        self.system_data = None


class PartnerTopicType(Resource):
    """Properties of a partner topic type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param partner_name: Official name of the partner.
    :type partner_name: str
    :param topic_type_name: Name of the partner topic type. This name should
     be unique among all partner topic types names.
    :type topic_type_name: str
    :param display_name: Display Name for the partner topic type.
    :type display_name: str
    :param description: Description of the partner topic type.
    :type description: str
    :param setup_uri: URI of the partner website that can be used by Azure
     customers to setup Event Grid
     integration on an event source.
    :type setup_uri: str
    :param authorization_state: Status of whether the customer has authorized
     a partner to create partner topics
     in the customer's subscription. Possible values include: 'NotApplicable',
     'NotAuthorized', 'Authorized'
    :type authorization_state: str or
     ~azure.mgmt.eventgrid.models.PartnerTopicTypeAuthorizationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partner_name': {'key': 'properties.partnerName', 'type': 'str'},
        'topic_type_name': {'key': 'properties.topicTypeName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'setup_uri': {'key': 'properties.setupUri', 'type': 'str'},
        'authorization_state': {'key': 'properties.authorizationState', 'type': 'str'},
    }

    def __init__(self, *, partner_name: str=None, topic_type_name: str=None, display_name: str=None, description: str=None, setup_uri: str=None, authorization_state=None, **kwargs) -> None:
        super(PartnerTopicType, self).__init__(**kwargs)
        self.partner_name = partner_name
        self.topic_type_name = topic_type_name
        self.display_name = display_name
        self.description = description
        self.setup_uri = setup_uri
        self.authorization_state = authorization_state


class PartnerTopicTypesListResult(Model):
    """Result of the List Partner Topic Types operation.

    :param value: A collection of partner topic types.
    :type value: list[~azure.mgmt.eventgrid.models.PartnerTopicType]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PartnerTopicType]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(PartnerTopicTypesListResult, self).__init__(**kwargs)
        self.value = value


class PartnerTopicUpdateParameters(Model):
    """Properties of the Partner Topic update.

    :param tags: Tags of the partner topic.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(PartnerTopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class PrivateEndpoint(Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this
     Connection.
    :type private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
    :param group_ids: GroupIds from the private link service resource.
    :type group_ids: list[str]
    :param private_link_service_connection_state: Details about the state of
     the connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.eventgrid.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint
     Connection. Possible values include: 'Creating', 'Updating', 'Deleting',
     'Succeeded', 'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, group_ids=None, private_link_service_connection_state=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateLinkResource(Model):
    """Information of the private link resource.

    :param group_id:
    :type group_id: str
    :param display_name:
    :type display_name: str
    :param required_members:
    :type required_members: list[str]
    :param required_zone_names:
    :type required_zone_names: list[str]
    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource.
    :type name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, group_id: str=None, display_name: str=None, required_members=None, required_zone_names=None, id: str=None, name: str=None, type: str=None, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = group_id
        self.display_name = display_name
        self.required_members = required_members
        self.required_zone_names = required_zone_names
        self.id = id
        self.name = name
        self.type = type


class ResourceSku(Model):
    """Describes an EventGrid Resource Sku.

    :param name: The Sku name of the resource. The possible values are: Basic
     or Premium. Possible values include: 'Basic', 'Premium'
    :type name: str or ~azure.mgmt.eventgrid.models.Sku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, name=None, **kwargs) -> None:
        super(ResourceSku, self).__init__(**kwargs)
        self.name = name


class RetryPolicy(Model):
    """Information about the retry policy for an event subscription.

    :param max_delivery_attempts: Maximum number of delivery retry attempts
     for events. Default value: 30 .
    :type max_delivery_attempts: int
    :param event_time_to_live_in_minutes: Time To Live (in minutes) for
     events. Default value: 1440 .
    :type event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        'max_delivery_attempts': {'key': 'maxDeliveryAttempts', 'type': 'int'},
        'event_time_to_live_in_minutes': {'key': 'eventTimeToLiveInMinutes', 'type': 'int'},
    }

    def __init__(self, *, max_delivery_attempts: int=30, event_time_to_live_in_minutes: int=1440, **kwargs) -> None:
        super(RetryPolicy, self).__init__(**kwargs)
        self.max_delivery_attempts = max_delivery_attempts
        self.event_time_to_live_in_minutes = event_time_to_live_in_minutes


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Service Bus destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, resource_id: str=None, delivery_attribute_mappings=None, **kwargs) -> None:
        super(ServiceBusQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'ServiceBusQueue'


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus topic destination for an event
    subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource Id that represents the endpoint of
     the Service Bus Topic destination of an event subscription.
    :type resource_id: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, resource_id: str=None, delivery_attribute_mappings=None, **kwargs) -> None:
        super(ServiceBusTopicEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'ServiceBusTopic'


class StaticDeliveryAttributeMapping(DeliveryAttributeMapping):
    """Static delivery attribute mapping details.

    All required parameters must be populated in order to send to Azure.

    :param name: Name of the delivery attribute or header.
    :type name: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param value: Value of the delivery attribute.
    :type value: str
    :param is_secret: Boolean flag to tell if the attribute contains sensitive
     information .
    :type is_secret: bool
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'is_secret': {'key': 'properties.isSecret', 'type': 'bool'},
    }

    def __init__(self, *, name: str=None, value: str=None, is_secret: bool=None, **kwargs) -> None:
        super(StaticDeliveryAttributeMapping, self).__init__(name=name, **kwargs)
        self.value = value
        self.is_secret = is_secret
        self.type = 'Static'


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of the storage account that is
     the destination of the deadletter events
    :type resource_id: str
    :param blob_container_name: The name of the Storage blob container that is
     the destination of the deadletter events
    :type blob_container_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'blob_container_name': {'key': 'properties.blobContainerName', 'type': 'str'},
    }

    def __init__(self, *, resource_id: str=None, blob_container_name: str=None, **kwargs) -> None:
        super(StorageBlobDeadLetterDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.blob_container_name = blob_container_name
        self.endpoint_type = 'StorageBlob'


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param resource_id: The Azure Resource ID of the storage account that
     contains the queue that is the destination of an event subscription.
    :type resource_id: str
    :param queue_name: The name of the Storage queue under a storage account
     that is the destination of an event subscription.
    :type queue_name: str
    :param queue_message_time_to_live_in_seconds: Storage queue message time
     to live in seconds.
    :type queue_message_time_to_live_in_seconds: long
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
        'queue_message_time_to_live_in_seconds': {'key': 'properties.queueMessageTimeToLiveInSeconds', 'type': 'long'},
    }

    def __init__(self, *, resource_id: str=None, queue_name: str=None, queue_message_time_to_live_in_seconds: int=None, **kwargs) -> None:
        super(StorageQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.queue_name = queue_name
        self.queue_message_time_to_live_in_seconds = queue_message_time_to_live_in_seconds
        self.endpoint_type = 'StorageQueue'


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringBeginsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringBeginsWith'


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringContainsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringContains'


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringEndsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringEndsWith'


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringIn'


class StringNotBeginsWithAdvancedFilter(AdvancedFilter):
    """StringNotBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringNotBeginsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringNotBeginsWith'


class StringNotContainsAdvancedFilter(AdvancedFilter):
    """StringNotContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringNotContainsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringNotContains'


class StringNotEndsWithAdvancedFilter(AdvancedFilter):
    """StringNotEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringNotEndsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringNotEndsWith'


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param key: The field/property in the event based on which you want to
     filter.
    :type key: str
    :param operator_type: Required. Constant filled by server.
    :type operator_type: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(self, *, key: str=None, values=None, **kwargs) -> None:
        super(StringNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.values = values
        self.operator_type = 'StringNotIn'


class SystemData(Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
     Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
    :type created_by_type: str or ~azure.mgmt.eventgrid.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the
     resource. Possible values include: 'User', 'Application',
     'ManagedIdentity', 'Key'
    :type last_modified_by_type: str or
     ~azure.mgmt.eventgrid.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC)
    :type last_modified_at: datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(self, *, created_by: str=None, created_by_type=None, created_at=None, last_modified_by: str=None, last_modified_by_type=None, last_modified_at=None, **kwargs) -> None:
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class SystemTopic(TrackedResource):
    """EventGrid System Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the system topic. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    :param source: Source for the system topic.
    :type source: str
    :param topic_type: TopicType for the system topic.
    :type topic_type: str
    :ivar metric_resource_id: Metric resource id for the system topic.
    :vartype metric_resource_id: str
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'metric_resource_id': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'topic_type': {'key': 'properties.topicType', 'type': 'str'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, source: str=None, topic_type: str=None, identity=None, **kwargs) -> None:
        super(SystemTopic, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.source = source
        self.topic_type = topic_type
        self.metric_resource_id = None
        self.identity = identity
        self.system_data = None


class SystemTopicUpdateParameters(Model):
    """Properties of the System Topic update.

    :param tags: Tags of the system topic.
    :type tags: dict[str, str]
    :param identity: Resource identity information.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
    }

    def __init__(self, *, tags=None, identity=None, **kwargs) -> None:
        super(SystemTopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections:
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the topic. Possible values
     include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Canceled',
     'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should
     expect for incoming events published to the topic. Possible values
     include: 'EventGridSchema', 'CustomEventSchema', 'CloudEventSchemaV1_0'.
     Default value: "EventGridSchema" .
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: This enables publishing using custom event
     schemas. An InputSchemaMapping can be specified to map various properties
     of a source schema to various required properties of the EventGridEvent
     schema.
    :type input_schema_mapping:
     ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over
     public network. By default it is enabled.
     You can further restrict to specific IPs by configuring <seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
     />. Possible values include: 'Enabled', 'Disabled'. Default value:
     "Enabled" .
    :type public_network_access: str or
     ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from
     specific IPs instead of all IPs. Note: These are considered only if
     PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :param sku: The Sku pricing tier for the topic.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    :param identity: Identity information for the resource.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param kind: Kind of the resource. Possible values include: 'Azure',
     'AzureArc'
    :type kind: str or ~azure.mgmt.eventgrid.models.ResourceKind
    :param extended_location: Extended location of the resource.
    :type extended_location: ~azure.mgmt.eventgrid.models.ExtendedLocation
    :ivar system_data: The system metadata relating to Topic resource.
    :vartype system_data: ~azure.mgmt.eventgrid.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'kind': {'key': 'kind', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, *, location: str, tags=None, private_endpoint_connections=None, input_schema="EventGridSchema", input_schema_mapping=None, public_network_access="Enabled", inbound_ip_rules=None, sku=None, identity=None, kind=None, extended_location=None, **kwargs) -> None:
        super(Topic, self).__init__(location=location, tags=tags, **kwargs)
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.sku = sku
        self.identity = identity
        self.kind = kind
        self.extended_location = extended_location
        self.system_data = None


class TopicRegenerateKeyRequest(Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, *, key_name: str, **kwargs) -> None:
        super(TopicRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class TopicSharedAccessKeys(Model):
    """Shared access keys of the Topic.

    :param key1: Shared access key1 for the topic.
    :type key1: str
    :param key2: Shared access key2 for the topic.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(self, *, key1: str=None, key2: str=None, **kwargs) -> None:
        super(TopicSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provider: Namespace of the provider of the topic type.
    :type provider: str
    :param display_name: Display Name for the topic type.
    :type display_name: str
    :param description: Description of the topic type.
    :type description: str
    :param resource_region_type: Region type of the resource. Possible values
     include: 'RegionalResource', 'GlobalResource'
    :type resource_region_type: str or
     ~azure.mgmt.eventgrid.models.ResourceRegionType
    :param provisioning_state: Provisioning state of the topic type. Possible
     values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :param supported_locations: List of locations supported by this topic
     type.
    :type supported_locations: list[str]
    :param source_resource_format: Source resource format.
    :type source_resource_format: str
    :param supported_scopes_for_source: Supported source scopes.
    :type supported_scopes_for_source: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_region_type': {'key': 'properties.resourceRegionType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'supported_locations': {'key': 'properties.supportedLocations', 'type': '[str]'},
        'source_resource_format': {'key': 'properties.sourceResourceFormat', 'type': 'str'},
        'supported_scopes_for_source': {'key': 'properties.supportedScopesForSource', 'type': '[str]'},
    }

    def __init__(self, *, provider: str=None, display_name: str=None, description: str=None, resource_region_type=None, provisioning_state=None, supported_locations=None, source_resource_format: str=None, supported_scopes_for_source=None, **kwargs) -> None:
        super(TopicTypeInfo, self).__init__(**kwargs)
        self.provider = provider
        self.display_name = display_name
        self.description = description
        self.resource_region_type = resource_region_type
        self.provisioning_state = provisioning_state
        self.supported_locations = supported_locations
        self.source_resource_format = source_resource_format
        self.supported_scopes_for_source = supported_scopes_for_source


class TopicUpdateParameters(Model):
    """Properties of the Topic update.

    :param tags: Tags of the resource.
    :type tags: dict[str, str]
    :param identity: Resource identity information.
    :type identity: ~azure.mgmt.eventgrid.models.IdentityInfo
    :param public_network_access: This determines if traffic is allowed over
     public network. By default it is enabled.
     You can further restrict to specific IPs by configuring <seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
     />. Possible values include: 'Enabled', 'Disabled'. Default value:
     "Enabled" .
    :type public_network_access: str or
     ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from
     specific IPs instead of all IPs. Note: These are considered only if
     PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    :param sku: The Sku pricing tier for the topic.
    :type sku: ~azure.mgmt.eventgrid.models.ResourceSku
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityInfo'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
        'sku': {'key': 'sku', 'type': 'ResourceSku'},
    }

    def __init__(self, *, tags=None, identity=None, public_network_access="Enabled", inbound_ip_rules=None, sku=None, **kwargs) -> None:
        super(TopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules
        self.sku = sku


class UserIdentityProperties(Model):
    """The information about the user identity.

    :param principal_id: The principal id of user assigned identity.
    :type principal_id: str
    :param client_id: The client id of user assigned identity.
    :type client_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, *, principal_id: str=None, client_id: str=None, **kwargs) -> None:
        super(UserIdentityProperties, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.client_id = client_id


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Constant filled by server.
    :type endpoint_type: str
    :param endpoint_url: The URL that represents the endpoint of the
     destination of an event subscription.
    :type endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the
     destination of an event subscription.
    :vartype endpoint_base_url: str
    :param max_events_per_batch: Maximum number of events per batch. Default
     value: 1 .
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in
     Kilobytes. Default value: 64 .
    :type preferred_batch_size_in_kilobytes: int
    :param azure_active_directory_tenant_id: The Azure Active Directory Tenant
     ID to get the access token that will be included as the bearer token in
     delivery requests.
    :type azure_active_directory_tenant_id: str
    :param azure_active_directory_application_id_or_uri: The Azure Active
     Directory Application ID or URI to get the access token that will be
     included as the bearer token in delivery requests.
    :type azure_active_directory_application_id_or_uri: str
    :param delivery_attribute_mappings: Delivery attribute details.
    :type delivery_attribute_mappings:
     list[~azure.mgmt.eventgrid.models.DeliveryAttributeMapping]
    """

    _validation = {
        'endpoint_type': {'required': True},
        'endpoint_base_url': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_url': {'key': 'properties.endpointUrl', 'type': 'str'},
        'endpoint_base_url': {'key': 'properties.endpointBaseUrl', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'azure_active_directory_tenant_id': {'key': 'properties.azureActiveDirectoryTenantId', 'type': 'str'},
        'azure_active_directory_application_id_or_uri': {'key': 'properties.azureActiveDirectoryApplicationIdOrUri', 'type': 'str'},
        'delivery_attribute_mappings': {'key': 'properties.deliveryAttributeMappings', 'type': '[DeliveryAttributeMapping]'},
    }

    def __init__(self, *, endpoint_url: str=None, max_events_per_batch: int=1, preferred_batch_size_in_kilobytes: int=64, azure_active_directory_tenant_id: str=None, azure_active_directory_application_id_or_uri: str=None, delivery_attribute_mappings=None, **kwargs) -> None:
        super(WebHookEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_url = endpoint_url
        self.endpoint_base_url = None
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.azure_active_directory_tenant_id = azure_active_directory_tenant_id
        self.azure_active_directory_application_id_or_uri = azure_active_directory_application_id_or_uri
        self.delivery_attribute_mappings = delivery_attribute_mappings
        self.endpoint_type = 'WebHook'
