# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .codec import Codec


class Video(Codec):
    """Describes the basic properties for encoding the input video.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Image, H264Video

    All required parameters must be populated in order to send to Azure.

    :param label: An optional label for the codec. The label can be used to
     control muxing behavior.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_frame_interval: The distance between two key frames, thereby
     defining a group of pictures (GOP). The value should be a non-zero integer
     in the range [1, 30] seconds, specified in ISO 8601 format. The default is
     2 seconds (PT2S).
    :type key_frame_interval: timedelta
    :param stretch_mode: The resizing mode - how the input video will be
     resized to fit the desired output resolution(s). Default is AutoSize.
     Possible values include: 'None', 'AutoSize', 'AutoFit'
    :type stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_frame_interval': {'key': 'keyFrameInterval', 'type': 'duration'},
        'stretch_mode': {'key': 'stretchMode', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.Image': 'Image', '#Microsoft.Media.H264Video': 'H264Video'}
    }

    def __init__(self, **kwargs):
        super(Video, self).__init__(**kwargs)
        self.key_frame_interval = kwargs.get('key_frame_interval', None)
        self.stretch_mode = kwargs.get('stretch_mode', None)
        self.odatatype = '#Microsoft.Media.Video'
