# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingPolicyFairPlayConfiguration(Model):
    """Class to specify configurations of FairPlay in Streaming Policy.

    All required parameters must be populated in order to send to Azure.

    :param custom_license_acquisition_url_template: Template for the URL of
     the custom service delivering licenses to end user players.  Not required
     when using Azure Media Services for issuing licenses.  The template
     supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values
     are {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is
     replaced with the value of identifier of the key being requested.
    :type custom_license_acquisition_url_template: str
    :param allow_persistent_license: Required. All license to be persistent or
     not
    :type allow_persistent_license: bool
    """

    _validation = {
        'allow_persistent_license': {'required': True},
    }

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
        'allow_persistent_license': {'key': 'allowPersistentLicense', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StreamingPolicyFairPlayConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = kwargs.get('custom_license_acquisition_url_template', None)
        self.allow_persistent_license = kwargs.get('allow_persistent_license', None)
