# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .preset import Preset


class FaceDetectorPreset(Preset):
    """Describes all the settings to be used when analyzing a video in order to
    detect all the faces present.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param resolution: Specifies the maximum resolution at which your video is
     analyzed. The default behavior is "SourceResolution," which will keep the
     input video at its original resolution when analyzed. Using
     "StandardDefinition" will resize input videos to standard definition while
     preserving the appropriate aspect ratio. It will only resize if the video
     is of higher resolution. For example, a 1920x1080 input would be scaled to
     640x360 before processing. Switching to "StandardDefinition" will reduce
     the time it takes to process high resolution video. It may also reduce the
     cost of using this component (see
     https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics
     for details). However, faces that end up being too small in the resized
     video may not be detected. Possible values include: 'SourceResolution',
     'StandardDefinition'
    :type resolution: str or ~azure.mgmt.media.models.AnalysisResolution
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'resolution': {'key': 'resolution', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FaceDetectorPreset, self).__init__(**kwargs)
        self.resolution = kwargs.get('resolution', None)
        self.odatatype = '#Microsoft.Media.FaceDetectorPreset'
