/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.D3PointBuilder;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ScalePurpose;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.element.ElementStructure;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class D3ElementBuilder {
    private static final String BAR_SPACING = "0.9";
    private static final String CLUSTER_SPACING = "0.75";
    private final ScriptWriter out;
    private final VisSingle vis;
    private final D3ScaleBuilder scales;
    private final D3LabelBuilder labelBuilder;
    private final D3Diagram diagram;
    private final ElementStructure structure;

    public D3ElementBuilder(ElementStructure structure, ScriptWriter out, D3ScaleBuilder scales) {
        this.structure = structure;
        this.vis = structure.vis;
        this.out = out;
        this.scales = scales;
        this.labelBuilder = new D3LabelBuilder(this.vis, out, structure.data);
        this.diagram = D3Diagram.make(structure, out);
    }

    public void generate(int elementIndex) {
        this.out.add("element = elements[" + elementIndex + "]").endStatement();
        if (this.diagram != null) {
            this.out.onNewLine().comment(new Object[]{"Data structures for a", this.vis.tDiagram, "diagram"});
        }
        ElementDetails details = this.makeDetails();
        ElementDefinition elementDef = this.buildElementDefinition();
        if (details.producesPath) {
            this.definePathsAndSplits(elementDef);
        }
        this.labelBuilder.defineLabeling(details, this.vis.itemsLabel, false);
        this.modifyGroupStyleName();
        this.out.add("d3Data =", details.dataSource).endStatement();
        this.out.add("selection = main.selectAll('*').data(d3Data,", this.getKeyFunction(), ")").endStatement();
        this.out.add("selection.enter().append('" + details.elementType + "')");
        this.out.add(".attr('class', ", details.classes, ")");
        if (this.diagram != null) {
            this.diagram.writeDiagramEnter();
        } else {
            this.writeCoordEnter();
        }
        if (this.diagram != null) {
            this.diagram.writePreDefinition(details, elementDef);
            this.out.add("BrunelD3.trans(selection,transitionMillis)");
            this.diagram.writeDefinition(details, elementDef);
        } else {
            this.writeCoordinateDefinition(details, elementDef);
            this.writeCoordinateLabelingAndAesthetics(details);
        }
        this.out.onNewLine().ln().add("BrunelD3.trans(selection.exit(),transitionMillis/3)");
        this.out.addChained("style('opacity', 0.5).each( function() {").indentMore().indentMore().add("this.remove(); if (this.__label__) this.__label__.remove()").indentLess().indentLess().add("})").endStatement();
    }

    public boolean needsDiagramExtras() {
        return this.diagram != null && this.diagram.needsDiagramExtras();
    }

    public boolean needsDiagramLabels() {
        return this.diagram != null && this.diagram.needsDiagramLabels();
    }

    public void writeBuildCommands() {
        if (this.diagram != null) {
            this.diagram.writeBuildCommands();
        }
    }

    public void writePerChartDefinitions() {
        if (this.diagram != null) {
            this.diagram.writePerChartDefinitions();
        }
    }

    private ElementDetails makeDetails() {
        if (this.structure.isGraphEdge()) {
            return ElementDetails.makeForDiagram(this.vis, "graph.links", "line", "edge", "box", false);
        }
        if (this.diagram == null) {
            return ElementDetails.makeForCoordinates(this.vis, this.getSymbol());
        }
        return this.diagram.initializeDiagram();
    }

    private ElementDefinition buildElementDefinition() {
        ElementDefinition e = new ElementDefinition();
        Field[] x = this.structure.chart.coordinates.getX(this.vis);
        Field[] y = this.structure.chart.coordinates.getY(this.vis);
        Field[] keys = new Field[this.vis.fKeys.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.structure.data.field(this.vis.fKeys.get(i).asField());
        }
        ModelUtil.Size sizeWidth = ModelUtil.getElementSize(this.vis, "width");
        ModelUtil.Size sizeHeight = ModelUtil.getElementSize(this.vis, "height");
        if (this.structure.chart.geo != null) {
            if (this.structure.dependent) {
                e.refLocation = keys.length == 1 ? "proj(" + this.structure.referredLocation(keys[0]) + ")" : "[ proj(" + this.structure.referredLocation(keys[0]) + "), proj(" + this.structure.referredLocation(keys[1]) + ") ]";
            }
            if (this.vis.tDiagram != VisTypes.Diagram.map) {
                this.setGeoLocations(e, x, y, keys);
            }
            e.x.size = this.getSize(this.getSizeCall(0), sizeWidth, new Field[0], "geom.default_point_size", null);
            e.y.size = this.getSize(this.getSizeCall(1), sizeHeight, new Field[0], "geom.default_point_size", null);
        } else {
            if (this.structure.dependent && !this.structure.isGraphEdge()) {
                e.refLocation = keys.length == 1 ? this.structure.referredLocation(keys[0]) : "[" + this.structure.referredLocation(keys[0]) + ", " + this.structure.referredLocation(keys[1]) + "]";
            }
            this.setLocations(e.x, "x", x, keys, this.structure.chart.coordinates.xCategorical);
            this.setLocations(e.y, "y", y, keys, this.structure.chart.coordinates.yCategorical);
            e.x.size = this.getSize(this.getSizeCall(0), sizeWidth, x, "geom.inner_width", ScalePurpose.x);
            e.y.size = this.getSize(this.getSizeCall(1), sizeHeight, y, "geom.inner_height", ScalePurpose.y);
            if (x.length > 1) {
                e.x.clusterSize = this.getSize(null, sizeWidth, x, "geom.inner_width", ScalePurpose.inner);
            }
        }
        e.overallSize = D3ElementBuilder.getOverallSize(this.vis, e);
        return e;
    }

    private void definePathsAndSplits(ElementDefinition elementDef) {
        this.defineVerticalExtentFunctions(elementDef, false);
        if (this.vis.tElement == VisTypes.Element.bar && this.vis.coords == VisTypes.Coordinates.polar) {
            this.out.add("var path = d3.svg.arc().outerRadius(geom.inner_radius).innerRadius(0)").ln();
            this.out.addChained("outerRadius(geom.inner_radius).innerRadius(0)").ln();
            if (this.vis.fRange == null && !this.vis.stacked) {
                this.out.addChained("startAngle(0).endAngle(y)");
            } else {
                this.out.addChained("startAngle(y0).endAngle(y1)");
            }
            this.out.endStatement();
            return;
        }
        if (elementDef.x.clusterSize != null) {
            this.out.add("var w1 =", elementDef.x.clusterSize).endStatement();
        }
        this.out.add("var x =", elementDef.x.center).endStatement();
        if (this.vis.tElement == VisTypes.Element.area) {
            if (this.vis.fRange == null && !this.vis.stacked) {
                this.out.add("var path = d3.svg.area().x(x).y1(y).y0(function(d) { return scale_y(0) })");
            } else {
                this.out.add("var path = d3.svg.area().x(x).y1(y1).y0(y0)");
            }
        } else if (this.vis.tElement.producesSingleShape) {
            String yDef;
            String string = yDef = elementDef.y.right == null ? "y" : "y1";
            if (this.vis.fSize.size() == 1) {
                this.out.add("var path = BrunelD3.sizedPath().x(x).y(" + yDef + ")");
                String size = elementDef.y.size != null ? elementDef.y.size : elementDef.overallSize;
                this.out.addChained("r(" + size + ")");
            } else {
                this.out.add("var path = d3.svg.line().x(x).y(" + yDef + ")");
            }
        }
        if (this.vis.tUsing == VisTypes.Using.interpolate) {
            this.out.add(".interpolate('basis')");
        }
        this.out.endStatement();
        this.constructSplitPath();
    }

    private void modifyGroupStyleName() {
        if (this.diagram != null) {
            this.out.add("main.attr('class',", this.diagram.getStyleClasses(), ")").endStatement();
        }
    }

    private String getKeyFunction() {
        String content = this.diagram != null ? this.diagram.getRowKey() : "d.key";
        return "function(d) { return " + content + "}";
    }

    private void writeCoordEnter() {
        ModelUtil.Size size = ModelUtil.getRoundRectangleRadius(this.vis);
        if (size != null) {
            this.out.addChained("attr('rx'," + size.valueInPixels(8.0) + ").attr('ry', " + size.valueInPixels(8.0) + ")").ln();
        }
        this.out.endStatement().onNewLine().ln();
    }

    private void writeCoordinateDefinition(ElementDetails details, ElementDefinition elementDef) {
        String basicDef = "BrunelD3.trans(selection,transitionMillis)";
        if (details.splitIntoShapes) {
            this.out.add(basicDef).addChained("attr('d', function(d) { return d.path })");
        } else if (details.producesPath) {
            this.out.add(basicDef).addChained("attr('d', path)");
        } else {
            if (elementDef.x.clusterSize != null) {
                this.out.add("var w1 =", elementDef.x.clusterSize).endStatement();
            }
            if (this.vis.tElement == VisTypes.Element.bar) {
                this.defineBar(basicDef, elementDef);
            } else if (this.vis.tElement == VisTypes.Element.edge) {
                this.defineEdge(basicDef, elementDef);
            } else {
                D3PointBuilder pointBuilder = new D3PointBuilder(this.out);
                if (pointBuilder.needsExtentFunctions(details)) {
                    this.defineVerticalExtentFunctions(elementDef, true);
                    this.defineHorizontalExtentFunctions(elementDef);
                }
                this.out.add(basicDef);
                pointBuilder.defineShapeGeometry(this.vis, elementDef, details);
            }
        }
    }

    private void defineHorizontalExtentFunctions(ElementDefinition elementDef) {
        if (elementDef.x.left != null) {
            this.out.add("var x0 =", elementDef.x.left).endStatement();
            this.out.add("var x1 =", elementDef.x.right).endStatement();
        } else {
            this.out.add("var x =", elementDef.x.center).endStatement();
            this.out.add("var w =", elementDef.x.size).endStatement();
        }
    }

    private void defineVerticalExtentFunctions(ElementDefinition elementDef, boolean withHeight) {
        if (elementDef.y.left != null) {
            this.out.add("var y0 =", elementDef.y.left).endStatement();
            this.out.add("var y1 =", elementDef.y.right).endStatement();
        } else {
            this.out.add("var y =", elementDef.y.center).endStatement();
            if (withHeight) {
                this.out.add("var h =", elementDef.y.size).endStatement();
            }
        }
    }

    private void writeCoordinateLabelingAndAesthetics(ElementDetails details) {
        if (!this.vis.fColor.isEmpty()) {
            this.out.addChained("style('" + details.colorAttribute + "', color)");
        }
        if (details.needsStrokeSize) {
            this.out.addChained("style('stroke-width', size)");
        }
        if (!this.vis.fOpacity.isEmpty()) {
            this.out.addChained("style('fill-opacity', opacity)").addChained("style('stroke-opacity', opacity)");
        }
        this.out.endStatement();
        this.labelBuilder.addElementLabeling();
        this.labelBuilder.addTooltips(details);
    }

    private String getSymbol() {
        String result = ModelUtil.getElementSymbol(this.vis);
        if (result != null) {
            return result;
        }
        boolean cat = this.allShowExtent(this.structure.chart.coordinates.allXFields) && this.allShowExtent(this.structure.chart.coordinates.allYFields);
        return cat ? "rect" : "point";
    }

    private void setGeoLocations(ElementDefinition def, Field[] x, Field[] y, Field[] keys) {
        int n = x.length;
        if (y.length != n) {
            throw new IllegalStateException("X and Y dimensions do not match in geographic maps");
        }
        if (this.structure.isGraphEdge()) {
            throw new IllegalStateException("Cannot handle edged dependencies in geographic maps");
        }
        if (this.structure.dependent) {
            this.setDependentLocations(def.x, "x", keys, "");
            this.setDependentLocations(def.y, "y", keys, "");
        } else if (n == 0) {
            def.x.center = "null";
            def.y.center = "null";
        } else if (n == 1) {
            String xFunction = D3Util.writeCall(x[0]);
            String yFunction = D3Util.writeCall(y[0]);
            def.x.center = "function(d) { return proj([" + xFunction + "," + yFunction + "])[0] }";
            def.y.center = "function(d) { return proj([" + xFunction + "," + yFunction + "])[1] }";
        } else if (n == 2) {
            String xLow = D3Util.writeCall(x[0]);
            String xHigh = D3Util.writeCall(x[1]);
            if (this.isRange(x[0])) {
                xLow = xLow + ".low";
            }
            if (this.isRange(x[1])) {
                xHigh = xHigh + ".high";
            }
            String yLow = D3Util.writeCall(y[0]);
            String yHigh = D3Util.writeCall(y[1]);
            if (this.isRange(y[0])) {
                yLow = yLow + ".low";
            }
            if (this.isRange(y[1])) {
                yHigh = yHigh + ".high";
            }
            def.x.left = "function(d) { return proj([" + xLow + "," + yLow + "])[0] }";
            def.x.right = "function(d) { return proj([" + xHigh + "," + yHigh + "])[0] }";
            def.y.left = "function(d) { return proj([" + xLow + "," + yLow + "])[1] }";
            def.y.right = "function(d) { return proj([" + xHigh + "," + yHigh + "])[1] }";
        }
    }

    private String getSize(String aestheticFunctionCall, ModelUtil.Size size, Field[] fields, String extent, ScalePurpose purpose) {
        String baseAmount;
        boolean needsFunction;
        boolean bl = needsFunction = aestheticFunctionCall != null;
        if (size != null && !size.isPercent()) {
            baseAmount = "" + size.value();
        } else if (fields.length == 0) {
            baseAmount = this.vis.tDiagram != null ? "geom.default_point_size" : extent;
        } else {
            Object[] cats;
            Field[] baseFields = fields;
            if (purpose == ScalePurpose.x || purpose == ScalePurpose.inner) {
                baseFields = new Field[]{fields[0]};
            }
            int categories = this.scales.getCategories(baseFields).size();
            if (purpose == ScalePurpose.x && fields.length > 1 && (cats = fields[1].categories()) != null) {
                categories *= cats.length;
            }
            Double granularity = this.scales.getGranularitySuitableForSizing(baseFields);
            if (this.vis.tDiagram != null) {
                granularity = null;
                categories = 0;
            }
            if (categories > 0) {
                String string = baseAmount = categories == 1 ? extent : extent + "/" + categories;
                if (purpose == ScalePurpose.inner || purpose == ScalePurpose.x && fields.length > 1) {
                    baseAmount = "0.75 * " + baseAmount;
                } else if (!(size != null && size.isPercent() || this.scales.allNumeric(baseFields))) {
                    baseAmount = "0.9 * " + baseAmount;
                }
            } else if (granularity != null) {
                String scaleName = "scale_" + purpose.name();
                baseAmount = "Math.abs( " + scaleName + "(" + granularity + ") - " + scaleName + "(0) )";
            } else {
                baseAmount = "geom.default_point_size";
            }
        }
        if (size != null && size.isPercent()) {
            baseAmount = size.value() + " * " + baseAmount;
        }
        if (needsFunction) {
            return "function(d) { return " + aestheticFunctionCall + " * " + baseAmount + "}";
        }
        return baseAmount;
    }

    private String getSizeCall(int dim) {
        if (this.vis.fSize.isEmpty()) {
            return null;
        }
        if (this.vis.fSize.size() == 1) {
            return "size(d)";
        }
        return dim == 0 ? "width(d)" : "height(d)";
    }

    private void setLocations(ElementDefinition.ElementDimensionDefinition dim, String dimName, Field[] fields, Field[] keys, boolean categorical) {
        boolean oneMainField;
        String scaleName = "scale_" + dimName;
        if (this.structure.isGraphEdge()) {
            dim.left = "function(d) { return d.source." + dimName + " }";
            dim.right = "function(d) { return d.target." + dimName + " }";
            return;
        }
        if (this.structure.dependent) {
            this.setDependentLocations(dim, dimName, keys, scaleName);
            return;
        }
        if (fields.length == 0) {
            dim.center = "function() { return " + scaleName + "(0.5) }";
            dim.left = "function() { return " + scaleName + "(0) }";
            dim.right = "function() { return " + scaleName + "(1) }";
            return;
        }
        Field main = fields[0];
        boolean numericBins = main.isBinned() && !categorical;
        boolean bl = oneMainField = fields.length == 1 || dimName.equals("x");
        if (oneMainField) {
            Field cluster = fields.length > 1 ? fields[1] : null;
            String dataFunction = D3Util.writeCall(main);
            if (numericBins) {
                if (cluster == null) {
                    dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ".mid) }";
                    dim.left = "function(d) { return " + scaleName + "(" + dataFunction + ".low) }";
                    dim.right = "function(d) { return " + scaleName + "(" + dataFunction + ".high) }";
                } else {
                    String L = scaleName + "(" + dataFunction + ".low)";
                    String R = scaleName + "(" + dataFunction + ".high)";
                    String D = this.isRange(cluster) ? "scale_inner(" + D3Util.writeCall(cluster) + ".mid)" : "scale_inner(" + D3Util.writeCall(cluster) + ")";
                    dim.center = "function(d) { var L=" + L + ", R=" + R + "; return (L+R)/2 + (L-R) * " + CLUSTER_SPACING + " * " + D + " }";
                }
            } else if (this.isRange(main)) {
                dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ".mid)";
                if (cluster != null) {
                    dim.center = dim.center + this.addClusterMultiplier(cluster);
                }
                dim.center = dim.center + " }";
            } else {
                dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ")";
                if (cluster != null) {
                    dim.center = dim.center + this.addClusterMultiplier(cluster);
                }
                dim.center = dim.center + " }";
            }
        } else {
            String lowDataFunc = D3Util.writeCall(main);
            String highDataFunc = D3Util.writeCall(fields[1]);
            if (this.isRange(main)) {
                lowDataFunc = lowDataFunc + ".low";
            }
            if (this.isRange(fields[1])) {
                highDataFunc = highDataFunc + ".high";
            }
            dim.left = "function(d) { return " + scaleName + "(" + lowDataFunc + ") }";
            dim.right = "function(d) { return " + scaleName + "(" + highDataFunc + ") }";
            dim.center = "function(d) { return " + scaleName + "( (" + highDataFunc + " + " + lowDataFunc + " )/2) }";
        }
    }

    private String addClusterMultiplier(Field cluster) {
        if (this.isRange(cluster)) {
            return " + w1 * scale_inner(" + D3Util.writeCall(cluster) + ".mid)";
        }
        return " + w1 * scale_inner(" + D3Util.writeCall(cluster) + ")";
    }

    private void setDependentLocations(ElementDefinition.ElementDimensionDefinition dim, String dimName, Field[] keys, String scaleName) {
        if (keys.length == 1) {
            dim.center = "function(d) { return " + scaleName + "(" + this.structure.keyedLocation(dimName, keys[0]) + ") }";
        } else {
            dim.left = "function(d) { return " + scaleName + "(" + this.structure.keyedLocation(dimName, keys[0]) + ") }";
            dim.right = "function(d) { return " + scaleName + "(" + this.structure.keyedLocation(dimName, keys[1]) + ") }";
            dim.center = "function() { return " + scaleName + "(0.5) }";
        }
    }

    public static String getOverallSize(VisSingle vis, ElementDefinition def) {
        boolean needsFunction;
        ModelUtil.Size size = ModelUtil.getElementSize(vis, "size");
        boolean bl = needsFunction = vis.fSize.size() == 1;
        if (size != null && !size.isPercent()) {
            if (needsFunction) {
                return "function(d) { return size(d) * " + size.value() + " }";
            }
            return "" + size.value();
        }
        String x = def.x.size;
        String y = def.y.size;
        if (x.equals(y)) {
            return x;
        }
        String xBody = D3Util.stripFunction(x);
        String yBody = D3Util.stripFunction(y);
        String content = "Math.min(" + xBody + ", " + yBody + ")";
        if (!xBody.equals(x) || !yBody.equals(y)) {
            return "function(d) { return " + content + " }";
        }
        return content;
    }

    private void constructSplitPath() {
        String params = "data, path";
        if (this.vis.tElement == VisTypes.Element.line || this.vis.tElement == VisTypes.Element.area) {
            params = params + ", x";
        }
        this.out.add("var splits = BrunelD3.makePathSplits(" + params + ");").ln();
    }

    private void defineBar(String basicDef, ElementDefinition elementDef) {
        if (this.vis.fRange != null || this.vis.stacked) {
            this.out.add("var y0 =", elementDef.y.left).endStatement();
            this.out.add("var y1 =", elementDef.y.right).endStatement();
            this.defineHorizontalExtentFunctions(elementDef);
            this.out.add(basicDef);
            this.out.addChained("attr('y', function(d) { return Math.min(y0(d), y1(d)) } )");
            this.out.addChained("attr('height', function(d) {return Math.max(0.001, Math.abs(y0(d) - y1(d))) })");
        } else {
            this.out.add("var y =", elementDef.y.center).endStatement();
            this.defineHorizontalExtentFunctions(elementDef);
            this.out.add(basicDef);
            if (this.vis.coords == VisTypes.Coordinates.transposed) {
                this.out.addChained("attr('y', 0)").addChained("attr('height', function(d) { return Math.max(0,y(d)) })");
            } else {
                this.out.addChained("attr('y', y)").addChained("attr('height', function(d) {return Math.max(0,geom.inner_height - y(d)) }) ");
            }
        }
        new D3PointBuilder(this.out).defineHorizontalExtent(elementDef.x);
    }

    private void defineEdge(String basicDef, ElementDefinition elementDef) {
        this.out.add(basicDef);
        if (elementDef.refLocation != null) {
            this.out.addChained("each(function(d) { this.__edge = " + elementDef.refLocation + "})");
            if (this.structure.chart.geo != null) {
                this.out.addChained("attr('x1', function() { return this.__edge[0][0]})");
                this.out.addChained("attr('y1', function() { return this.__edge[0][1]})");
                this.out.addChained("attr('x2', function() { return this.__edge[1][0]})");
                this.out.addChained("attr('y2', function() { return this.__edge[1][1]})");
            } else {
                this.out.addChained("attr('x1', function() { return this.__edge[0] ? scale_x(this.__edge[0][0]) : null })");
                this.out.addChained("attr('y1', function() { return this.__edge[0] ? scale_y(this.__edge[0][1]) : null })");
                this.out.addChained("attr('x2', function() { return this.__edge[1] ? scale_x(this.__edge[1][0]) : null })");
                this.out.addChained("attr('y2', function() { return this.__edge[1] ? scale_y(this.__edge[1][1]) : null })");
            }
            this.out.addChained("each(function() { if (!this.__edge[0][0] || !this.__edge[1][0]) this.style.visibility = 'hidden'})");
        } else {
            this.out.addChained("attr('x1'," + elementDef.x.left + ")");
            this.out.addChained("attr('y1'," + elementDef.y.left + ")");
            this.out.addChained("attr('x2'," + elementDef.x.right + ")");
            this.out.addChained("attr('y2'," + elementDef.y.right + ")");
        }
    }

    private boolean allShowExtent(Field[] fields) {
        for (Field field : fields) {
            if (!field.isNumeric() || field.isBinned()) continue;
            return false;
        }
        return true;
    }

    private boolean isRange(Field field) {
        if (field.isBinned() && field.isNumeric()) {
            return true;
        }
        String s = field.stringProperty("summary");
        return s != null && (s.equals("iqr") || s.equals("range"));
    }

    public void preBuildDefinitions() {
        if (this.diagram != null) {
            this.diagram.preBuildDefinitions();
        }
    }
}

