/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.brunel.action.Action;
import org.brunel.action.ActionStep;
import org.brunel.action.Param;

public class ActionUtil {
    public static Param[] parameters(Action action) {
        return ActionUtil.parametersByName(action, null);
    }

    public static Param[] dataParameters(Action action) {
        return ActionUtil.parametersByName(action, "data");
    }

    public static String prefixAllDataStatements(Action action, String prefix) {
        for (ActionStep step : action.steps) {
            if (!step.name.equals("data")) continue;
            step.parameters[0] = Param.makeString(prefix + step.parameters[0].asString());
        }
        return action.toString();
    }

    private static Param[] parametersByName(Action action, String actionName) {
        ArrayList parameters = new ArrayList();
        for (ActionStep step : action.steps) {
            if (actionName != null && !step.name.equals(actionName)) continue;
            Collections.addAll(parameters, step.parameters);
        }
        return parameters.toArray(new Param[parameters.size()]);
    }

    public static Action replaceParameters(Action action, Param[] parameters) {
        ActionStep[] replacementSteps = new ActionStep[action.steps.length];
        int at = 0;
        for (int i = 0; i < action.steps.length; ++i) {
            Param[] singleParams = new Param[action.steps[i].parameters.length];
            for (int j = 0; j < singleParams.length; ++j) {
                singleParams[j] = parameters[at++];
            }
            replacementSteps[i] = ActionUtil.replaceParameters(action.steps[i], singleParams);
        }
        return new Action(replacementSteps);
    }

    public static ActionStep replaceParameters(ActionStep step, Param[] parameters) {
        return Arrays.equals(step.parameters, parameters) ? step : new ActionStep(step.name, parameters);
    }

    public static Action replaceDataParameters(Action action, Param ... newData) {
        int dataIndex = 0;
        for (int i = 0; i < action.steps.length; ++i) {
            if (!action.steps[i].name.equals("data")) continue;
            action.steps[i] = ActionUtil.replaceParameters(action.steps[i], new Param[]{newData[dataIndex]});
            dataIndex = Math.min(dataIndex + 1, newData.length - 1);
        }
        return action;
    }
}

