/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.util;

import java.util.ArrayList;
import java.util.Collections;
import org.brunel.data.Data;
import org.brunel.data.util.DateFormat;

public class ItemsList
extends ArrayList<Object>
implements Comparable<ItemsList> {
    private final DateFormat dateFormat;
    private int displayCount = 12;

    public ItemsList(Object[] items, DateFormat df) {
        this.dateFormat = df;
        Collections.addAll(this, items);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ItemsList && this.compareTo((ItemsList)obj) == 0;
    }

    @Override
    public int compareTo(ItemsList o) {
        int n = Math.min(this.size(), o.size());
        for (int i = 0; i < n; ++i) {
            int d = Data.compare(this.get(i), o.get(i));
            if (d == 0) continue;
            return d;
        }
        return this.size() - o.size();
    }

    public void setDisplayCount(int displayCount) {
        this.displayCount = displayCount;
    }

    @Override
    public String toString() {
        String s = "";
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Double d;
            if (i > 0) {
                s = s + ", ";
            }
            if (i == this.displayCount - 1 && n > this.displayCount) {
                return s + "\u2026";
            }
            Object v = this.get(i);
            s = this.dateFormat != null ? s + this.dateFormat.format(Data.asDate(v)) : ((d = Data.asNumeric(v)) != null ? s + Data.formatNumeric(d, false) : s + v.toString());
        }
        return s;
    }
}

