/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.summary.FieldRowComparison;

public class Stack
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        if (command.isEmpty()) {
            return base;
        }
        String[] p = Stack.parts(command);
        String yField = p[0];
        String[] x = Stack.list(p[1]);
        String[] aesthetics = Stack.list(p[2]);
        boolean full = p[3].equalsIgnoreCase("true");
        if (x == null) {
            x = new String[]{};
        }
        if (aesthetics == null) {
            aesthetics = new String[]{};
        }
        Field[] keyFields = Stack.getFields(base.fields, x, aesthetics, {yField});
        Field[] allFields = Stack.orderRows(base, keyFields);
        if (full) {
            Field[] comboFields = Stack.getFields(allFields, x, aesthetics);
            allFields = Stack.addAllCombinations(allFields, comboFields);
        }
        Field[] fields = Stack.makeStackedValues(allFields, Stack.getField(allFields, yField), Stack.getFields(allFields, new String[][]{x}), full);
        return base.replaceFields(fields);
    }

    private static Field[] addAllCombinations(Field[] baseFields, Field[] keys) {
        int[] keyIndices = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            for (int j = 0; j < baseFields.length; ++j) {
                if (baseFields[j] != keys[i]) continue;
                keyIndices[i] = j;
            }
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int currentRowIndex = 0;
        Object[] currentRow = Stack.makeRealRow(baseFields, currentRowIndex);
        int[] index = new int[keys.length];
        while (index != null) {
            Object[] row = Stack.makeGeneratedRow(baseFields, keyIndices, index);
            boolean matched = false;
            while (Stack.matchKeys(row, currentRow, keyIndices)) {
                rows.add(currentRow);
                currentRow = Stack.makeRealRow(baseFields, ++currentRowIndex);
                matched = true;
            }
            if (!matched) {
                rows.add(row);
            }
            index = Stack.nextIndex(keys, index);
        }
        Field[] fields = new Field[baseFields.length];
        for (int i = 0; i < baseFields.length; ++i) {
            fields[i] = Data.makeColumnField(baseFields[i].name, baseFields[i].label, Stack.extractColumn(rows, i));
            Data.copyBaseProperties(fields[i], baseFields[i]);
        }
        return fields;
    }

    private static Object[] extractColumn(List<Object[]> rows, int index) {
        Object[] result = new Object[rows.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = rows.get(i)[index];
        }
        return result;
    }

    private static Field getField(Field[] fields, String name) {
        for (Field f : fields) {
            if (!f.name.equals(name)) continue;
            return f;
        }
        throw new IllegalArgumentException("Could not find field: " + name);
    }

    private static Field[] getFields(Field[] fields, String[] ... namesList) {
        ArrayList<Field> result = new ArrayList<Field>();
        String[][] arr$ = namesList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] s;
            for (String fName : s = arr$[i$]) {
                if ((fName = fName.trim()).isEmpty()) continue;
                result.add(Stack.getField(fields, fName));
            }
        }
        return result.toArray(new Field[result.size()]);
    }

    private static Object[] makeGeneratedRow(Field[] fields, int[] keyIndices, int[] index) {
        int n = fields.length;
        Object[] row = new Object[n];
        for (int i = 0; i < keyIndices.length; ++i) {
            int j = keyIndices[i];
            row[j] = fields[j].categories()[index[i]];
        }
        return row;
    }

    private static Object[] makeRealRow(Field[] fields, int index) {
        if (index >= fields[0].rowCount()) {
            return null;
        }
        int n = fields.length;
        Object[] row = new Object[n];
        for (int i = 0; i < fields.length; ++i) {
            row[i] = fields[i].value(index);
        }
        return row;
    }

    private static Field[] makeStackedValues(Field[] allFields, Field y, Field[] x, boolean full) {
        int N = y.rowCount();
        Object[][] bounds = new Object[2][N];
        double lastPositive = 0.0;
        double lastNegative = 0.0;
        FieldRowComparison rowComparison = new FieldRowComparison(x, null, false);
        for (int i = 0; i < N; ++i) {
            Double v = Data.asNumeric(y.value(i));
            if (v == null) {
                if (!full) continue;
                v = 0.0;
            }
            if (i > 0 && rowComparison.compare(i, i - 1) != 0) {
                lastPositive = 0.0;
                lastNegative = 0.0;
            }
            if (v < 0.0) {
                bounds[0][i] = lastNegative;
                bounds[1][i] = lastNegative += v.doubleValue();
                continue;
            }
            bounds[0][i] = lastPositive;
            bounds[1][i] = lastPositive += v.doubleValue();
        }
        int n = allFields.length;
        Object[] fields = new Field[n + 2];
        for (int i = 0; i < n; ++i) {
            fields[i] = allFields[i];
        }
        fields[n] = Data.makeColumnField(y.name + "$lower", y.label, bounds[0]);
        fields[n + 1] = Data.makeColumnField(y.name + "$upper", y.label, bounds[1]);
        Data.copyBaseProperties(fields[n], y);
        Data.copyBaseProperties(fields[n + 1], y);
        Arrays.sort(fields);
        return fields;
    }

    private static boolean matchKeys(Object[] a, Object[] b, int[] indices) {
        if (a == null || b == null) {
            return false;
        }
        for (int i : indices) {
            if (Data.compare(a[i], b[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static int[] nextIndex(Field[] keys, int[] index) {
        for (int p = index.length - 1; p >= 0; --p) {
            int max = keys[p].categories().length;
            int n = p;
            index[n] = index[n] + 1;
            if (index[n] < max) {
                return index;
            }
            index[p] = 0;
        }
        return null;
    }

    private static Field[] orderRows(Dataset base, Field[] keyFields) {
        Field[] baseFields = base.fields;
        FieldRowComparison comparison = new FieldRowComparison(keyFields, null, true);
        ArrayList<Integer> items = new ArrayList<Integer>();
        int n = base.rowCount();
        for (int i = 0; i < n; ++i) {
            boolean valid = true;
            for (Field f : keyFields) {
                if (f.value(i) != null) continue;
                valid = false;
            }
            if (!valid) continue;
            items.add(i);
        }
        Collections.sort(items, comparison);
        Integer[] rowOrder = items.toArray(new Integer[items.size()]);
        Field[] fields = new Field[baseFields.length];
        for (int i = 0; i < baseFields.length; ++i) {
            fields[i] = Data.permute(baseFields[i], Data.toPrimitive(rowOrder), true);
        }
        return fields;
    }
}

