from shark.base import Raw, Enumeration


def glyph(name):
    if isinstance(name, int):
        name = Glyph.name(name)
    return Raw('<span class="glyphicon glyphicon-' + name.strip('_').replace('_', '-') + '"></span>')


class Glyph(Enumeration):
    none = 0
    asterisk = 1
    plus = 2
    euro = 3
    minus = 4
    cloud = 5
    envelope = 6
    pencil = 7
    glass = 8
    music = 9
    search = 10
    heart = 11
    star = 12
    star_empty = 13
    user = 14
    film = 15
    th_large = 16
    th = 17
    th_list = 18
    ok = 19
    remove = 20
    zoom_in = 21
    zoom_out = 22
    off = 23
    signal = 24
    cog = 25
    trash = 26
    home = 27
    file = 28
    time = 29
    road = 30
    download_alt = 31
    download = 32
    upload = 33
    inbox = 34
    play_circle = 35
    repeat = 36
    refresh = 37
    list_alt = 38
    lock = 39
    flag = 40
    headphones = 41
    volume_off = 42
    volume_down = 43
    volume_up = 44
    qrcode = 45
    barcode = 46
    tag = 47
    tags = 48
    book = 49
    bookmark = 50
    print_ = 51
    camera = 52
    font = 53
    bold = 54
    italic = 55
    text_height = 56
    text_width = 57
    align_left = 58
    align_center = 59
    align_right = 60
    align_justify = 61
    list = 62
    indent_left = 63
    indent_right = 64
    facetime_video = 65
    picture = 66
    map_marker = 67
    adjust = 68
    tint = 69
    edit = 70
    share = 71
    check = 72
    move = 73
    step_backward = 74
    fast_backward = 75
    backward = 76
    play = 77
    pause = 78
    stop = 79
    forward = 80
    fast_forward = 81
    step_forward = 82
    eject = 83
    chevron_left = 84
    chevron_right = 85
    plus_sign = 86
    minus_sign = 87
    remove_sign = 88
    ok_sign = 89
    question_sign = 90
    info_sign = 91
    screenshot = 92
    remove_circle = 93
    ok_circle = 94
    ban_circle = 95
    arrow_left = 96
    arrow_right = 97
    arrow_up = 98
    arrow_down = 99
    share_alt = 100
    resize_full = 101
    resize_small = 102
    exclamation_sign = 103
    gift = 104
    leaf = 105
    fire = 106
    eye_open = 107
    eye_close = 108
    warning_sign = 109
    plane = 110
    calendar = 111
    random = 112
    comment = 113
    magnet = 114
    chevron_up = 115
    chevron_down = 116
    retweet = 117
    shopping_cart = 118
    folder_close = 119
    folder_open = 120
    resize_vertical = 121
    resize_horizontal = 122
    hdd = 123
    bullhorn = 124
    bell = 125
    certificate = 126
    thumbs_up = 127
    thumbs_down = 128
    hand_right = 129
    hand_left = 130
    hand_up = 131
    hand_down = 132
    circle_arrow_right = 133
    circle_arrow_left = 134
    circle_arrow_up = 135
    circle_arrow_down = 136
    globe = 137
    wrench = 138
    tasks = 139
    filter = 140
    briefcase = 141
    fullscreen = 142
    dashboard = 143
    paperclip = 144
    heart_empty = 145
    link = 146
    phone = 147
    pushpin = 148
    usd = 149
    gbp = 150
    sort = 151
    sort_by_alphabet = 152
    sort_by_alphabet_alt = 153
    sort_by_order = 154
    sort_by_order_alt = 155
    sort_by_attributes = 156
    sort_by_attributes_alt = 157
    unchecked = 158
    expand = 159
    collapse_down = 160
    collapse_up = 161
    log_in = 162
    flash = 163
    log_out = 164
    new_window = 165
    record = 166
    save = 167
    open = 168
    saved = 169
    import_ = 170
    export = 171
    send = 172
    floppy_disk = 173
    floppy_saved = 174
    floppy_remove = 175
    floppy_save = 176
    floppy_open = 177
    credit_card = 178
    transfer = 179
    cutlery = 180
    header = 181
    compressed = 182
    earphone = 183
    phone_alt = 184
    tower = 185
    stats = 186
    sd_video = 187
    hd_video = 188
    subtitles = 189
    sound_stereo = 190
    sound_dolby = 191
    sound_5_1 = 192
    sound_6_1 = 193
    sound_7_1 = 194
    copyright_mark = 195
    registration_mark = 196
    cloud_download = 197
    cloud_upload = 198
    tree_conifer = 199
    tree_deciduous = 200

    @classmethod
    def name(cls, value):
        return super(Glyph, cls).name(value).strip('_').replace('_', '-')