# PySNMP SMI module. Autogenerated from smidump -f python CISCO-VTP-MIB
# by libsmi2pysnmp-0.1.3 at Thu May 22 11:57:34 2014,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ciscoMgmt, ) = mibBuilder.importSymbols("CISCO-SMI", "ciscoMgmt")
( Cisco2KVlanList, ) = mibBuilder.importSymbols("CISCO-TC", "Cisco2KVlanList")
( InterfaceIndex, InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero", "ifIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( OwnerString, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32")
( DateAndTime, DisplayString, RowStatus, TextualConvention, TestAndIncr, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "RowStatus", "TextualConvention", "TestAndIncr", "TimeStamp", "TruthValue")

# Types

class ManagementDomainIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,255)
    
class VlanIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,4095)
    
class VlanType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,6,1,5,4,2,)
    namedValues = NamedValues(("ethernet", 1), ("fddi", 2), ("tokenRing", 3), ("fddiNet", 4), ("trNet", 5), ("deprecated", 6), )
    
class VlanTypeExt(Bits):
    namedValues = NamedValues(("vtpmanageable", 0), ("internal", 1), ("reserved", 2), ("rspan", 3), ("dynamicGvrp", 4), )
    

# Objects

ciscoVtpMIB = ModuleIdentity((1, 3, 6, 1, 4, 1, 9, 9, 46)).setRevisions(("2013-10-14 00:00","2010-05-12 00:00","2009-12-03 00:00","2008-03-07 00:00","2007-10-04 00:00","2006-02-17 00:00","2004-02-11 00:00","2003-11-21 00:00","2003-08-08 00:00","2003-07-11 00:00","2003-04-16 00:00","2002-04-10 00:00","2002-02-28 00:00","2001-08-03 00:00","2001-02-26 00:00","2001-02-12 00:00","2000-09-19 00:00","2000-04-10 00:00","2000-01-06 00:00","1999-02-25 11:30","1999-01-05 11:30","1998-05-19 11:30","1997-08-08 11:38","1997-05-09 11:30","1997-02-24 11:15","1997-01-27 17:30","1996-09-16 12:30","1996-07-17 12:30","1996-01-18 18:20",))
if mibBuilder.loadTexts: ciscoVtpMIB.setOrganization("Cisco Systems, Inc.")
if mibBuilder.loadTexts: ciscoVtpMIB.setContactInfo("Cisco Systems\nCustomer Service\n\nPostal: 170 W Tasman Drive\nSan Jose, CA  95134\nUSA\n\nTel: +1 800 553-NETS\n\nE-mail: cs-wbu@cisco.com, \n        cs-lan-switch-snmp@cisco.com")
if mibBuilder.loadTexts: ciscoVtpMIB.setDescription("The MIB module for entities implementing the VTP\nprotocol and Vlan management.")
vtpMIBObjects = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1))
vtpStatus = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1))
vtpVersion = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("one", 1), ("two", 2), ("none", 3), ("three", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVersion.setDescription("The version of VTP in use on the local system.  A device\nwill report its version capability and not any particular\nversion in use on the device. If the device does not support\nvtp, the version is none(3).")
vtpMaxVlanStorage = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 1023))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpMaxVlanStorage.setDescription("An estimate of the maximum number of VLANs about which the\nlocal system can recover complete VTP information after a\nreboot.  If the number of defined VLANs is greater than this\nvalue, then the system can not act as a VTP Server. For a\ndevice which has no means to calculate the estimated number,\nthis value is -1.")
vtpNotificationsEnabled = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1, 3), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpNotificationsEnabled.setDescription("An indication of whether the notifications/traps defined by\nthe vtpConfigNotificationsGroup, vtpConfigNotificationsGroup2,\nand vtpConfigNotificationsGroup8 are enabled.")
vtpVlanCreatedNotifEnabled = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1, 4), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpVlanCreatedNotifEnabled.setDescription("An indication of whether the notification should\nbe generated when a VLAN is created. \n\nIf the value of this object is 'true' then the\nvtpVlanCreated notification will be generated.\n\nIf the value of this object is 'false' then the\nvtpVlanCreated notification will not be generated.")
vtpVlanDeletedNotifEnabled = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpVlanDeletedNotifEnabled.setDescription("An indication of whether the notification should\nbe generated when a VLAN is deleted.  \n\nIf the value of this object is 'true' then the\nvtpVlanDeleted notification will be generated.\n\nIf the value of this object is 'false' then the\nvtpVlanDeleted notification will not be generated.")
vlanManagementDomains = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2))
managementDomainTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1))
if mibBuilder.loadTexts: managementDomainTable.setDescription("The table containing information on the management domains\nin which the local system is participating.  Devices which\nsupport only one management domain will support just one row\nin this table, and will not let it be deleted nor let other\nrows be created.  Devices which support multiple management\ndomains will allow rows to be created and deleted, but will\nnot allow the last row to be deleted. If the device does \nnot support VTP, the table is read-only.")
managementDomainEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"))
if mibBuilder.loadTexts: managementDomainEntry.setDescription("Information about the status of one management domain.")
managementDomainIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 1), ManagementDomainIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: managementDomainIndex.setDescription("An arbitrary value to uniquely identify the management\ndomain on the local system.")
managementDomainName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainName.setDescription("The management name of a domain in which the local system\nis participating.  The zero-length name corresponds to the\n'no management-domain' state which is the initial value at\ninstallation-time if not configured otherwise.  Note that\nthe zero-length name does not correspond to an operational\nmanagement domain, and a device does not send VTP\nadvertisements while in the 'no management-domain' state.  A\ndevice leaves the 'no management-domain' state when it\nobtains a management-domain name, either through\nconfiguration or through inheriting the management-domain\nname from a received VTP advertisement.\n\nWhen the value of an existing instance of this object is\nmodified by network management, the local system should re-\ninitialize its VLAN information (for the given management\ndomain) as if it had just been configured with a management\ndomain name at installation time.")
managementDomainLocalMode = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,)).subtype(namedValues=NamedValues(("client", 1), ("server", 2), ("transparent", 3), ("off", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainLocalMode.setDescription("The local VTP mode in this management domain when\nmanagementDomainVersionInUse is version1(1) or\nversion2(2).\n\nIf managementDomainVersionInUse is version3(4), this \nobject has the same value with vtpDatabaseLocalMode \nof VLAN database type.\n\n- 'client' indicates that the local system is acting\n  as a VTP client.\n\n- 'server' indicates that the local system is acting\n  as a VTP server.\n\n- 'transparent' indicates that the local system does\n  not generate or listen to VTP messages, but forwards\n  messages. This mode can also be set by the device\n  itself when the amount of VLAN information is too\n  large for it to hold in DRAM.\n\n- 'off' indicates that the local system does not\n  generate, listen to or forward any VTP messages.")
managementDomainConfigRevNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainConfigRevNumber.setDescription("The current Configuration Revision Number as known by\nthe local device for this management domain when \nmanagementDomainVersionInUse is version1(1) or \nversion2(2).\n\nIf managementDomainVersionInUse is version3(4), this \nobject has the same value with vtpDatabaseRevisionNumber \nof VLAN database type.\n\nThis value is updated (if necessary) whenever a VTP\nadvertisement is received or generated. When in the\n'no management-domain' state, this value is 0.")
managementDomainLastUpdater = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 5), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainLastUpdater.setDescription("The IP-address (or one of them) of the VTP Server which\nlast updated the Configuration Revision Number, as indicated\nin the most recently received VTP advertisement for this\nmanagement domain, when managementDomainVersionInUse is\nversion1(1) or version2(2). \n\nIf managementDomainVersionInUse is version3(4), this object\nhas the value of 0.0.0.0.\n\nBefore an advertisement has been received, this value is\n0.0.0.0.")
managementDomainLastChange = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainLastChange.setDescription("The time at which the Configuration Revision Number was\n(last) increased to its current value, as indicated in the\nmost recently received VTP advertisement for this management\ndomain when managementDomainVersionInUse is not version3(4)\nor in the most recently received VTP VLAN database \nadvertisement for this management domain when \nmanagementDomainVersionInUse is version3(4).\n\nThe value 0x0000010100000000 indicates that the device which\nlast increased the Configuration Revision Number had no idea\nof the date/time, or that no advertisement has been\nreceived.")
managementDomainRowStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainRowStatus.setDescription("The status of this conceptual row.")
managementDomainTftpServer = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 8), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainTftpServer.setDescription("The IP address of a TFTP Server in/from which VTP VLAN\ninformation for this management domain is to be\nstored/retrieved.  If the information is being locally\nstored in NVRAM, this object should take the value 0.0.0.0.")
managementDomainTftpPathname = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 9), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainTftpPathname.setDescription("The complete pathname of the file at the TFTP Server\nidentified by the value of managementDomainTftpServer\nin/from which VTP VLAN information for this management\ndomain is to be stored/retrieved.  If the value of\ncorresponding instance of managementDomainTftpServer is\n0.0.0.0, the value of this object is ignored.")
managementDomainPruningState = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainPruningState.setDescription("An indication of whether VTP pruning is enabled or disabled\nin this managament domain. \n\nThis object can only be modified, either when the \ncorresponding instance value of managementDomainVersionInUse \nis 'version1' or 'version2' and the corresponding instance \nvalue of managementDomainLocalMode is 'server', or when the \ncorresponding instance value of managementDomainVersionInUse \nis 'version3' and the corresponding instance value of \nmanagementDomainLocalMode is 'server' or 'client'.")
managementDomainVersionInUse = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,)).subtype(namedValues=NamedValues(("version1", 1), ("version2", 2), ("none", 3), ("version3", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainVersionInUse.setDescription("The current version of the VTP that is in use by the\ndesignated management domain. \n\nThis object can be set to none(3) only when \nvtpVersion is none(3).")
managementDomainPruningStateOper = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainPruningStateOper.setDescription("Indicates whether VTP pruning is operationally enabled or\ndisabled in this managament domain.")
managementDomainAdminSrcIf = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 13), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainAdminSrcIf.setDescription("The object specifies the interface to be used as the\npreferred source interface for the VTP IP updater address.\n\nA zero length value indicates that a source interface is not\nspecified.")
managementDomainSourceOnlyMode = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 14), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainSourceOnlyMode.setDescription("The object specifies whether to use only the IP address of\nmanagementDomainAdminSrcIf as the VTP IP updater address. \n\n'true' indicates to only use the IP address of \n       managementDomainAdminSrcIf as the VTP IP \n       updater address. \n\n'false' indicates to use the IP address of \n        managementDomainAdminSrcIf as the VTP IP \n        updater address if managementDomainAdminSrcIf \n        is configured with an IP address.  Otherwise, the \n        first available IP address of the system will\n        be used.")
managementDomainOperSrcIf = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 15), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainOperSrcIf.setDescription("The object indicates the interface used as the\npreferred source interface for the VTP IP updater address.\n\nA zero length string indicates that a source interface is not\navailable.")
managementDomainConfigFile = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 16), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: managementDomainConfigFile.setDescription("The object specifies the file name where VTP configuration\nis stored in the format of <filename> or <devices>:[<filename>].\n\n<device> can be (but not limited to): flash, bootflash,\nslot0, slot1, disk0.")
managementDomainLocalUpdaterType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 17), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainLocalUpdaterType.setDescription("The object indicates the type of the Internet address\nof the preferred source interface for the VTP IP updater.\n\nThe value of this object is 'unknown' if\nmanagementDomainVersionInUse is 'version3' or\nmanagementDomainLocalMode is not 'server'.")
managementDomainLocalUpdater = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 18), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainLocalUpdater.setDescription("The object indicates the Internet address of the\npreferred source interface for the VTP IP updater.")
managementDomainDeviceID = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 2, 1, 1, 19), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: managementDomainDeviceID.setDescription("The object indicates a value that uniquely identifies\nthis device within a VTP Domain.\n\nThe value of this object is zero length string if\nmanagementDomainVersionInUse is not 'version3'.")
vlanInfo = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3))
vtpVlanTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1))
if mibBuilder.loadTexts: vtpVlanTable.setDescription("This table contains information on the VLANs which\ncurrently exist.")
vtpVlanEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpVlanIndex"))
if mibBuilder.loadTexts: vtpVlanEntry.setDescription("Information about one current VLAN.  The\nmanagementDomainIndex value in the INDEX clause indicates\nwhich management domain the VLAN is in.")
vtpVlanIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 1), VlanIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vtpVlanIndex.setDescription("The VLAN-id of this VLAN on ISL or 802.1q trunks.")
vtpVlanState = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,)).subtype(namedValues=NamedValues(("operational", 1), ("suspended", 2), ("mtuTooBigForDevice", 3), ("mtuTooBigForTrunk", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanState.setDescription("The state of this VLAN.\n\nThe state 'mtuTooBigForDevice' indicates that this device\ncannot participate in this VLAN because the VLAN's MTU is\nlarger than the device can support.\n\nThe state 'mtuTooBigForTrunk' indicates that while this\nVLAN's MTU is supported by this device, it is too large for\none or more of the device's trunk ports.")
vtpVlanType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 3), VlanType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanType.setDescription("The type of this VLAN.")
vtpVlanName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanName.setDescription("The name of this VLAN.  This name is used as the ELAN-name\nfor an ATM LAN-Emulation segment of this VLAN.")
vtpVlanMtu = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1500, 18190))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanMtu.setDescription("The MTU size on this VLAN, defined as the size of largest\nMAC-layer (information field portion of the) data frame\nwhich can be transmitted on the VLAN.")
vtpVlanDot10Said = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanDot10Said.setDescription("The value of the 802.10 SAID field for this VLAN.")
vtpVlanRingNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanRingNumber.setDescription("The ring number of this VLAN.  This object is only\ninstantiated when the value of the corresponding instance of\nvtpVlanType has a value of 'fddi' or 'tokenRing' and Source\nRouting is in use on this VLAN.")
vtpVlanBridgeNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanBridgeNumber.setDescription("The bridge number of the VTP-capable switches for this\nVLAN.  This object is only instantiated for VLANs that are\ninvolved with emulating token ring segments.")
vtpVlanStpType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("ieee", 1), ("ibm", 2), ("hybrid", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanStpType.setDescription("The type of the Spanning Tree Protocol (STP) running on\nthis VLAN.  This object is only instanciated when the\nvalue of the corresponding instance of vtpVlanType has a\nvalue of 'fddiNet' or 'trNet'.\n\nThe value returned by this object depends upon the value\nof the corresponding instance of vtpVlanEditStpType.\n\n- 'ieee' indicates IEEE STP is running exclusively.\n\n- 'ibm' indicates IBM STP is running exclusively.\n\n- 'hybrid' indicates a STP that allows a combination of\n  IEEE and IBM is running.\n\nThe 'hybrid' STP type results from tokenRing/fddi VLANs\nthat are children of this trNet/fddiNet parent VLAN being\nconfigured in a combination of SRT and SRB\nvtpVlanBridgeTypes while the instance of\nvtpVlanEditStpType that corresponds to this object is set\nto 'auto'.")
vtpVlanParentVlan = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 10), VlanIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanParentVlan.setDescription("The parent VLAN for this VLAN.  This object is only\ninstantiated when the value of the corresponding instance of\nvtpVlanType has a value of 'fddi' or 'tokenRing' and Source\nRouting is in use on this VLAN.  The parent VLAN must have \na vtpVlanType value of fddiNet(4) or trNet(5), \nrespectively.")
vtpVlanTranslationalVlan1 = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 11), VlanIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanTranslationalVlan1.setDescription("A VLAN to which this VLAN is being translational-bridged.\nIf this value and the corresponding instance of\nvtpVlanTranslationalVlan2 are both zero, then this VLAN is\nnot being translational-bridged.")
vtpVlanTranslationalVlan2 = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 12), VlanIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanTranslationalVlan2.setDescription("Another VLAN, i.e., other than that indicated by\nvtpVlanTranslationalVlan1, to which this VLAN is being\ntranslational-bridged.  If this value and the corresponding\ninstance of vtpVlanTranslationalVlan1 are both zero, then\nthis VLAN is not being translational-bridged.")
vtpVlanBridgeType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("srt", 1), ("srb", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanBridgeType.setDescription("The type of the Source Route bridging mode in use on this\nVLAN.  This object is only instantiated when the value of \nthe corresponding instance of vtpVlanType has a value of \nfddi(2) or tokenRing(3) and Source Routing is in use on\nthis VLAN.")
vtpVlanAreHopCount = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 13))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanAreHopCount.setDescription("The maximum number of bridge hops allowed in\nAll Routes Explorer frames on this VLAN.  This\nobject is only instantiated when the value of the\ncorresponding instance of vtpVlanType has a value of fddi(2)\nor tokenRing(3) and Source Routing is in use on this VLAN.")
vtpVlanSteHopCount = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 13))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanSteHopCount.setDescription("The maximum number of bridge hops allowed in\nSpanning Tree Explorer frames on this VLAN.  This\nobject is only instantiated when the value of the\ncorresponding instance of vtpVlanType has a value of fddi(2)\nor tokenRing(3) and Source Routing is in use on this VLAN.")
vtpVlanIsCRFBackup = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanIsCRFBackup.setDescription("True if this VLAN is of type trCrf and also is acting as\na backup trCrf for the ISL distributed BRF")
vtpVlanTypeExt = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 17), VlanTypeExt()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanTypeExt.setDescription("The additional type information of this VLAN.")
vtpVlanIfIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 1, 1, 18), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanIfIndex.setDescription("The value of the ifIndex corresponding to this VLAN ID.\nIf the VLAN ID does not have its corresponding interface, \nthis object has the value of zero.")
internalVlanInfo = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 2))
vtpInternalVlanAllocPolicy = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 2, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("ascending", 1), ("descending", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpInternalVlanAllocPolicy.setDescription("The internal VLAN allocation policy.\n\n'ascending'  - internal VLANs are allocated\n               starting from a lowwer VLAN ID and \n               upwards.\n'descending' - internal VLANs are allocated\n               starting from a higher VLAN ID and\n               downwards.")
vtpInternalVlanTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 2, 2))
if mibBuilder.loadTexts: vtpInternalVlanTable.setDescription("A vtpInternalVlanTable entry contains\ninformation on an existing internal\nVLAN. It is internally created by the\ndevice for a specific application program \nand hence owned by the application.  \nIt cannot be modified or deleted by (local \nor network) management.")
vtpInternalVlanEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 2, 2, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpVlanIndex"))
if mibBuilder.loadTexts: vtpInternalVlanEntry.setDescription("Information about one current internal\nVLAN.")
vtpInternalVlanOwner = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 3, 2, 2, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpInternalVlanOwner.setDescription("The program name of the internal VLAN's\nowner application. This internal VLAN\nis allocated by the device specifically\nfor this application and no one else\ncould create, modify or delete this \nVLAN.")
vlanEdit = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4))
vtpEditControlTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1))
if mibBuilder.loadTexts: vtpEditControlTable.setDescription("This table provides the means to control the editing of the\nVLANs for a particular management domain.  Each and every\nentry in this table augments its corresponding entry in the\nmanagementDomainTable; thus, an entry in this table is\ncreated/deleted only as a by-product of creating/deleting an\nentry in the managementDomainTable.")
vtpEditControlEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1))
if mibBuilder.loadTexts: vtpEditControlEntry.setDescription("Control information for editing the VLANs in one management\ndomain.")
vtpVlanEditOperation = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,5,)).subtype(namedValues=NamedValues(("none", 1), ("copy", 2), ("apply", 3), ("release", 4), ("restartTimer", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditOperation.setDescription("This object always has the value 'none' when read.  When\nwritten, each value causes the appropriate action:\n\n 'copy' - causes the creation of rows in the\nvtpVlanEditTable exactly corresponding to the current global\nVLAN information for this management domain.  If the Edit\nBuffer (for this management domain) is not currently empty,\na copy operation fails.  A successful copy operation starts\nthe deadman-timer.\n\n 'apply' - first performs a consistent check on the the\nmodified information contained in the Edit Buffer, and if\nconsistent, then tries to instanciate the modified\ninformation as the new global VLAN information.  Note that\nan empty Edit Buffer (for the management domain) would\nalways result in an inconsistency since the default VLANs\nare required to be present.\n\n 'release' - flushes the Edit Buffer (for this management\ndomain), clears the Owner information, and aborts the\ndeadman-timer.  A release is generated automatically if the\ndeadman-timer ever expires.\n\n 'restartTimer' - restarts the deadman-timer.\n\n 'none' - no operation is performed.")
vtpVlanApplyStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,6,5,8,10,9,7,)).subtype(namedValues=NamedValues(("inProgress", 1), ("notPrimaryServer", 10), ("succeeded", 2), ("configNumberError", 3), ("inconsistentEdit", 4), ("tooBig", 5), ("localNVStoreFail", 6), ("remoteNVStoreFail", 7), ("editBufferEmpty", 8), ("someOtherError", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanApplyStatus.setDescription("The current status of an 'apply' operation to instanciate\nthe Edit Buffer as the new global VLAN information (for this\nmanagement domain).  If no apply is currently active, the\nstatus represented is that of the most recently completed\napply.  The possible values are:\n\n   inProgress - 'apply' operation in progress;\n\n   succeeded - the 'apply' was successful (this value is\n          also used when no apply has been invoked since the\n          last time the local system restarted);\n\n   configNumberError - the apply failed because the value of\n          vtpVlanEditConfigRevNumber was less or equal to\n          the value of current value of \n          managementDomainConfigRevNumber;\n\n   inconsistentEdit - the apply failed because the modified\n          information was not self-consistent;\n\n   tooBig - the apply failed because the modified\n          information was too large to fit in this VTP\n          Server's non-volatile storage location;\n\n   localNVStoreFail - the apply failed in trying to store\n          the new information in a local non-volatile\n          storage location;\n\n   remoteNVStoreFail - the apply failed in trying to store\n          the new information in a remote non-volatile\n          storage location;\n\n   editBufferEmpty - the apply failed because the Edit\n          Buffer was empty (for this management domain).\n\n   someOtherError - the apply failed for some other reason\n          (e.g., insufficient memory).\n\n   notPrimaryServer - the apply failed because the local \n          device is not a VTP primary server for VLAN \n          database type when managementDomainVersionInUse\n          is version3(4).")
vtpVlanEditBufferOwner = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1, 3), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditBufferOwner.setDescription("The management station which is currently using the Edit\nBuffer for this management domain.  When the Edit Buffer for\na management domain is not currently in use, the value of\nthis object is the zero-length string.  Note that it is also\nthe zero-length string if a manager fails to set this object\nwhen invoking a copy operation.")
vtpVlanEditConfigRevNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1, 4), Gauge32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditConfigRevNumber.setDescription("The Configuration Revision Number to be used for the next\napply operation.  This value is initialized (by the agent)\non a copy operation to be one greater than the value of\nmanagementDomainConfigRevNumber. On an apply, if the \nnumber is less or equal to the value of \nmanagementDomainConfigRevNumber, then the apply fails.\nThe value can be modified (increased) by network management\nbefore an apply to ensure that an apply does not fail for \nthis reason.\n\nThis object is used to allow management control over whether\na configuration revision received via a VTP advertisement\nafter a copy operation but before the succeeding apply\noperation is lost by being overwritten by the (local) edit\noperation.  By default, the apply operation will fail in\nthis situation.  By increasing this object's value after the\ncopy but before the apply, management can control whether\nthe apply is to succeed (with the update via VTP\nadvertisement being lost).")
vtpVlanEditModifiedVlan = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 1, 1, 5), VlanIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanEditModifiedVlan.setDescription("The VLAN-id of the modified VLAN in the Edit Buffer.\nIf the object has the value of zero, any VLAN can \nbe edited. If the value of the object is not zero,\nonly this VLAN can be edited.\n\nThe object's value is reset to zero after a successful\n'apply' operation or a 'release' operation. \n\nThis object is only supported for devices which allow \nonly one VLAN editing for each 'apply' operation. For\ndevices which allow multiple VLAN editing for each\n'apply' operation, this object is not supported.")
vtpVlanEditTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2))
if mibBuilder.loadTexts: vtpVlanEditTable.setDescription("The table which contains the information in the Edit\nBuffers, one Edit Buffer per management domain.  The\ninformation for a particular management domain is\ninitialized, by a 'copy' operation, to be the current global\nVLAN information for that management domain.  After\ninitialization, editing can be performed to add VLANs,\ndelete VLANs, or modify their global parameters.  The\ninformation as modified through editing is local to this\nEdit Buffer.  An apply operation using the\nvtpVlanEditOperation object is necessary to instanciate the\nmodified information as the new global VLAN information for\nthat management domain.\n\nTo use the Edit Buffer, a manager acts as follows:\n\n1. ensures the Edit Buffer for a management domain is empty,\ni.e., there are no rows in this table for this management\ndomain.\n\n2. issues a SNMP set operation which sets\nvtpVlanEditOperation to 'copy', and vtpVlanEditBufferOwner\nto its own identifier (e.g., its own IP address).\n\n3. if this set operation is successful, proceeds to edit the\ninformation in the vtpVlanEditTable.\n\n4. if and when the edited information is to be instantiated,\nissues a SNMP set operation which sets vtpVlanEditOperation\nto 'apply'.\n\n5. issues retrieval requests to obtain the value of\nvtpVlanApplyStatus, until the result of the apply is\ndetermined.\n\n6. releases the Edit Buffer by issuing a SNMP set operation\nwhich sets vtpVlanEditOperation to 'release'.\n\nNote that the information contained in this table is not\nsaved across agent reboots.")
vtpVlanEditEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpVlanEditIndex"))
if mibBuilder.loadTexts: vtpVlanEditEntry.setDescription("Information about one VLAN in the Edit Buffer for a\nparticular management domain.")
vtpVlanEditIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 1), VlanIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vtpVlanEditIndex.setDescription("The VLAN-id which this VLAN would have on ISL or\n802.1q trunks.")
vtpVlanEditState = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("operational", 1), ("suspended", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditState.setDescription("The state which this VLAN would have.")
vtpVlanEditType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 3), VlanType().clone('ethernet')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditType.setDescription("The type which this VLAN would have.\nAn implementation may restrict access to this object.")
vtpVlanEditName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 4), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditName.setDescription("The name which this VLAN would have.  This name would be\nused as the ELAN-name for an ATM LAN-Emulation segment of\nthis VLAN.\n\nAn implementation may restrict access to this object.")
vtpVlanEditMtu = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1500, 18190)).clone(1500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditMtu.setDescription("The MTU size which this VLAN would have, defined as the\nsize of largest MAC-layer (information field portion of the)\ndata frame which can be transmitted on the VLAN.\n\nAn implementation may restrict access to this object.")
vtpVlanEditDot10Said = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditDot10Said.setDescription("The value of the 802.10 SAID field which would be used for\nthis VLAN.\n\nAn implementation may restrict access to this object.")
vtpVlanEditRingNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 4095))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditRingNumber.setDescription("The ring number which would be used for this VLAN.  This\nobject is only instantiated when the value of the\ncorresponding instance of vtpVlanEditType has a value of\n'fddi' or 'tokenRing' and Source Routing is in use on \nthis VLAN.")
vtpVlanEditBridgeNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditBridgeNumber.setDescription("The bridge number of the VTP-capable switches which would\nbe used for this VLAN.  This object is only instantiated\nwhen the value of the corresponding instance of\nvtpVlanEditType has a value of fddiNet(4) or trNet(5).")
vtpVlanEditStpType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("ieee", 1), ("ibm", 2), ("auto", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditStpType.setDescription("The type of the Spanning Tree Protocol which would be\nrunning on this VLAN.  This object is only instantiated\nwhen the value of the corresponding instance of\nvtpVlanEditType has a value of fddiNet(4) or trNet(5).\n\nIf 'ieee' is selected, the STP that runs will be IEEE.\n\nIf 'ibm' is selected, the STP that runs will be IBM.\n\nIf 'auto' is selected, the STP that runs will be\ndependant on the values of vtpVlanEditBridgeType for all\nchildren tokenRing/fddi type VLANs.  This will result in\na 'hybrid' STP (see vtpVlanStpType).")
vtpVlanEditParentVlan = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 10), VlanIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditParentVlan.setDescription("The VLAN index of the VLAN which would be the parent for\nthis VLAN.  This object is only instantiated when the value\nof the corresponding instance of vtpVlanEditType has a value\nof 'fddi' or 'tokenRing' and Source Routing is in use on\nthis VLAN.  The parent VLAN must have a vtpVlanEditType \nvalue of fddiNet(4) or trNet(5), respectively.")
vtpVlanEditRowStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditRowStatus.setDescription("The status of this row.  Any and all columnar objects in an\nexisting row can be modified irrespective of the status of\nthe row.\n\nA row is not qualified for activation until instances of at\nleast its vtpVlanEditType, vtpVlanEditName and\nvtpVlanEditDot10Said columns have appropriate values.\n\nThe management station should endeavor to make all rows\nconsistent in the table before 'apply'ing the buffer.  An\ninconsistent entry in the table will cause the entire\nbuffer to be rejected with the vtpVlanApplyStatus object\nset to the appropriate error value.")
vtpVlanEditTranslationalVlan1 = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 12), VlanIndex().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditTranslationalVlan1.setDescription("A VLAN to which this VLAN would be translational-bridged.\nIf this value and the corresponding instance of\nvtpVlanTranslationalVlan2 are both zero, then this VLAN\nwould not be translational-bridged.\n\nAn implementation may restrict access to this object.")
vtpVlanEditTranslationalVlan2 = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 13), VlanIndex().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditTranslationalVlan2.setDescription("Another VLAN, i.e., other than that indicated by\nvtpVlanEditTranslationalVlan1, to which this VLAN would be\ntranslational-bridged.  If this value and the corresponding\ninstance of vtpVlanTranslationalVlan1 are both zero, then\nthis VLAN would not be translational-bridged.\n\nAn implementation may restrict access to this object.")
vtpVlanEditBridgeType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("srt", 1), ("srb", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditBridgeType.setDescription("The type of Source Route bridging mode which would be in\nuse on this VLAN.  This object is only instantiated when \nthe value of  the corresponding instance of vtpVlanEditType\nhas a value of fddi(2) or tokenRing(3) and Source Routing \nis in use on this VLAN.")
vtpVlanEditAreHopCount = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 13))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditAreHopCount.setDescription("The maximum number of bridge hops allowed in\nAll Routes Explorer frames on this VLAN.  This\nobject is only instantiated when the value of the\ncorresponding instance of vtpVlanType has a value of fddi(2)\nor tokenRing(3) and Source Routing is in use on this VLAN.")
vtpVlanEditSteHopCount = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 13))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditSteHopCount.setDescription("The maximum number of bridge hops allowed in\nSpanning Tree Explorer frames on this VLAN.  This\nobject is only instantiated when the value of the\ncorresponding instance of vtpVlanType has a value of fddi(2)\nor tokenRing(3) and Source Routing is in use on this VLAN.")
vtpVlanEditIsCRFBackup = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 17), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditIsCRFBackup.setDescription("True if this VLAN is of type trCrf and also is acting as\na backup trCrf for the ISL distributed BRF.  This object is\nonly instantiated when the value of the corresponding\ninstance of vtpVlanEditType has a value of tokenRing(3).")
vtpVlanEditTypeExt = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 18), VlanTypeExt()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpVlanEditTypeExt.setDescription("The additional type information of this VLAN.\nvtpVlanEditTypeExt object is superseded by vtpVlanEditTypeExt2.")
vtpVlanEditTypeExt2 = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 2, 1, 19), VlanTypeExt()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlanEditTypeExt2.setDescription("The additional type information of this VLAN.\nThe VlanTypeExt TC specifies which bits may\nbe written by a management application.\nThe agent should provide a default value.")
vtpVlanLocalShutdownTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 3))
if mibBuilder.loadTexts: vtpVlanLocalShutdownTable.setDescription("Ths table contains the VLAN local shutdown\ninformation within management domain.")
vtpVlanLocalShutdownEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 3, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpVlanIndex"))
if mibBuilder.loadTexts: vtpVlanLocalShutdownEntry.setDescription("An entry containing VLAN local shutdown information for a\nparticular VLAN in the management domain.\n\nAn entry is created if a VLAN which supports local shutdown\nhas been created.\n\nAn entry is deleted if a VLAN which supports local shutdown\nhas been removed.")
vtpVlanLocalShutdown = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 4, 3, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpVlanLocalShutdown.setDescription("The object specifies the VLAN local shutdown state.")
vtpStats = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5))
vtpStatsTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1))
if mibBuilder.loadTexts: vtpStatsTable.setDescription("A table of VTP statistics.")
vtpStatsEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1))
if mibBuilder.loadTexts: vtpStatsEntry.setDescription("VTP statistics for one management domain.")
vtpInSummaryAdverts = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpInSummaryAdverts.setDescription("The total number of VTP Summary Adverts received for this\nmanagement domain.")
vtpInSubsetAdverts = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpInSubsetAdverts.setDescription("The total number of VTP Subset Adverts received for this\nmanagement domain.")
vtpInAdvertRequests = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpInAdvertRequests.setDescription("The total number of VTP Advert Requests received for this\nmanagement domain.")
vtpOutSummaryAdverts = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpOutSummaryAdverts.setDescription("The total number of VTP Summary Adverts sent for this\nmanagement domain.")
vtpOutSubsetAdverts = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpOutSubsetAdverts.setDescription("The total number of VTP Subset Adverts sent for this\nmanagement domain.")
vtpOutAdvertRequests = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpOutAdvertRequests.setDescription("The total number of VTP Advert Requests sent for this\nmanagement domain.")
vtpConfigRevNumberErrors = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpConfigRevNumberErrors.setDescription("The number of occurrences of configuration revision number\nerrors for this management domain.  A configuration revision\nnumber error occurs when a device receives a VTP\nadvertisement for which:\n\n- the advertisement's Configuration Revision Number is the\n  same as the current locally-held value, and\n\n- the advertisement's digest value is different from the\n  current locally-held value.")
vtpConfigDigestErrors = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 5, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpConfigDigestErrors.setDescription("The number of occurrences of configuration digest errors\nfor this management domain.  A configuration digest error\noccurs when a device receives a VTP advertisement for which:\n\n- the advertisement's Configuration Revision Number is\n  greater than the current locally-held value, and\n\n-  the advertisement's digest value computed by the\n receiving device does not match the checksum in the\n summary advertisement that was received earlier. This\n can happen, for example, if there is a mismatch in VTP\n passwords between the VTP devices.")
vlanTrunkPorts = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6))
vlanTrunkPortTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1))
if mibBuilder.loadTexts: vlanTrunkPortTable.setDescription("The table containing information on the local system's VLAN\ntrunk ports.")
vlanTrunkPortEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "vlanTrunkPortIfIndex"))
if mibBuilder.loadTexts: vlanTrunkPortEntry.setDescription("Information about one trunk port.")
vlanTrunkPortIfIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vlanTrunkPortIfIndex.setDescription("The value of ifIndex for the interface corresponding to\nthis trunk port.")
vlanTrunkPortManagementDomain = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 2), ManagementDomainIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortManagementDomain.setDescription("The value of managementDomainIndex for the management\ndomain on this trunk port.  Devices which support only one\nmanagement domain will support this object read-only.")
vlanTrunkPortEncapsulationType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,5,1,)).subtype(namedValues=NamedValues(("isl", 1), ("dot10", 2), ("lane", 3), ("dot1Q", 4), ("negotiate", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortEncapsulationType.setDescription("The type of VLAN encapsulation desired to be used on this\ntrunk port. It is either a particular type, or 'negotiate'\nmeaning whatever type results from the negotiation.\nnegotiate(5) is not allowed if the port does not support\nnegotiation or if its vlanTrunkPortDynamicState is set to\non(1) or onNoNegotiate(5). Whether writing to this object\nin order to modify the encapsulation is supported is both\ndevice and interface specific.")
vlanTrunkPortVlansEnabled = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(128, 128)).setFixedLength(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVlansEnabled.setDescription("A string of octets containing one bit per VLAN in the\nmanagement domain on this trunk port.  The first octet\ncorresponds to VLANs with VlanIndex values of 0 through 7;\nthe second octet to VLANs 8 through 15; etc.  The most\nsignificant bit of each octet corresponds to the lowest\nvalue VlanIndex in that octet.  If the bit corresponding to\na VLAN is set to '1', then the local system is enabled for\nsending and receiving frames on that VLAN; if the bit is set\nto '0', then the system is disabled from sending and\nreceiving frames on that VLAN.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vlanTrunkPortNativeVlan = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 5), VlanIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortNativeVlan.setDescription("The VlanIndex of the VLAN which is represented by native\nframes on this trunk port.  For trunk ports not supporting\nthe sending and receiving of native frames, this value\nshould be set to zero.")
vlanTrunkPortRowStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortRowStatus.setDescription("The status of this row.  In some circumstances, the\ncreation of a row in this table is needed to enable the\nappropriate trunking/tagging protocol on the port, to enable\nthe use of VTP on the port, and to assign the port to the\nappropriate management domain.  In other circumstances, rows\nin this table will be created as a by-product of other\noperations.")
vlanTrunkPortInJoins = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortInJoins.setDescription("The number of VTP Join messages received on this trunk\nport.")
vlanTrunkPortOutJoins = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortOutJoins.setDescription("The number of VTP Join messages sent on this trunk port.")
vlanTrunkPortOldAdverts = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortOldAdverts.setDescription("The number of VTP Advertisement messages which indicated\nthe sender does not support VLAN-pruning received on this\ntrunk port.")
vlanTrunkPortVlansPruningEligible = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(128, 128)).setFixedLength(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVlansPruningEligible.setDescription("A string of octets containing one bit per VLAN in the\nmanagement domain on this trunk port.  The first octet\ncorresponds to VLANs with VlanIndex values of 0 through 7;\nthe second octet to VLANs 8 through 15; etc.  The most\nsignificant bit of each octet corresponds to the lowest\nvalue VlanIndex in that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal system is permitted to prune that VLAN on this trunk\nport; if the bit is set to '0', then the system must not\nprune that VLAN on this trunk port.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vlanTrunkPortVlansXmitJoined = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(128, 128)).setFixedLength(128)).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansXmitJoined.setDescription("A string of octets containing one bit per VLAN in the\nmanagement domain on this trunk port.  The first octet\ncorresponds to VLANs with VlanIndex values of 0 through 7;\nthe second octet to VLANs 8 through 15; etc.  The most\nsignificant bit of each octet corresponds to the lowest\nvalue VlanIndex in that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then this\nVLAN is presently being forwarded on this trunk port, i.e.,\nit is not pruned; if the bit is set to '0', then this VLAN\nis presently not being forwarded on this trunk port, either\nbecause it is pruned or for some other reason.")
vlanTrunkPortVlansRcvJoined = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(128, 128)).setFixedLength(128)).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansRcvJoined.setDescription("A string of octets containing one bit per VLAN in the\nmanagement domain on this trunk port.  The first octet\ncorresponds to VLANs with VlanIndex values of 0 through 7;\nthe second octet to VLANs 8 through 15; etc.  The most\nsignificant bit of each octet corresponds to the lowest\nvalue VlanIndex in that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal switch is currently sending joins for this VLAN on\nthis trunk port, i.e., it is asking to receive frames for\nthis VLAN; if the bit is set to '0', then the local switch\nis not currently sending joins for this VLAN on this trunk\nport.")
vlanTrunkPortDynamicState = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=NamedValues(("on", 1), ("off", 2), ("desirable", 3), ("auto", 4), ("onNoNegotiate", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortDynamicState.setDescription("For devices that allows dynamic determination of whether\na link between two switches should be a trunk or not, this\nobject allows the operator to mandate the behavior of that\ndynamic mechanism.\n\non(1) dictates that the interface will always be a\ntrunk. This is the value for static entries (those that\nshow no dynamic behavior). If the negotiation is supported\non this port, negotiation will take place with the far end\nto attempt to bring the far end into trunking state.\n\noff(2) allows an operator to specify that the specified\ninterface is never to be trunk, regardless of any dynamic\nmechanisms to the contrary.  This value is useful for\noverriding the default behavior of some switches. If the\nnegotiation is supported on this port, negotiation will take\nplace with the far end to attempt on the link to bring the\nfar end into non-trunking state.\n\ndesirable(3) is used to indicate that it is desirable for\nthe interface to become a trunk.  The device will initiate\nany negotiation necessary to become a trunk but will not\nbecome a trunk unless it receives confirmation from the far\nend on the link.\n\nauto(4) is used to indicate that the interface is capable\nand willing to become a trunk but will not initiate\ntrunking negotiations.  The far end on the link are\nrequired to either start negotiations or start sending\nencapsulated packets, on which event the specified\ninterface will become a trunk.\n\nonNoNegotiate(5) is used to indicate that the interface is\npermanently set to be a trunk, and no negotiation takes\nplace with the far end on the link to ensure consistent\noperation. This is similar to on(1) except no negotiation\ntakes place with the far end.\n\nIf the port does not support negotiation or its\nvlanTrunkPortEncapsulationType is set to negotiate(5),\nonNoNegotiate(5) is not allowed.\n\nDevices that do no support dynamic determination (for just\na particular interface, encapsulation or for the whole\ndevice) need only support the 'on', and 'off' values.")
vlanTrunkPortDynamicStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("trunking", 1), ("notTrunking", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortDynamicStatus.setDescription("Indicates whether the specified interface is either\nacting as a trunk or not. This is a result of the\nvlanTrunkPortDynamicState and the ifOperStatus of the\ntrunk port itself.")
vlanTrunkPortVtpEnabled = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 15), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVtpEnabled.setDescription("Some trunk interface modules allow VTP to be\nenabled/disabled seperately from that of the central\ndevice.  In such a case this object provides management a\nway to remotely enable VTP on that module.  If a module\ndoes not support a seperate VTP enabled state then this\nobject shall always return 'true' and will accept no other\nvalue during a SET operation.")
vlanTrunkPortEncapsulationOperType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,2,5,6,1,)).subtype(namedValues=NamedValues(("isl", 1), ("dot10", 2), ("lane", 3), ("dot1Q", 4), ("negotiating", 5), ("notApplicable", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortEncapsulationOperType.setDescription("The type of VLAN encapsulation in use on this trunk port.\nFor intefaces with vlanTrunkPortDynamicStatus of\nnotTrunking(2) the vlanTrunkPortEncapsulationOperType shall\nbe notApplicable(6).")
vlanTrunkPortVlansEnabled2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVlansEnabled2k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 1024 through 2047 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 1024 through 1031; the second\noctet to VLANs 1032 through 1039; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet. If the bit corresponding to a VLAN is set to\n'1', then the local system is enabled for sending and\nreceiving frames on that VLAN; if the bit is set to '0',\nthen the system is disabled from sending and receiving\nframes on that VLAN. The default value is zero length\nstring.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vlanTrunkPortVlansEnabled3k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 18), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVlansEnabled3k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 2048 through 3071 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 2048 through 2055; the second\noctet to VLANs 2056 through 2063; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet. If the bit corresponding to a VLAN is set to\n'1', then the local system is enabled for sending and\nreceiving frames on that VLAN; if the bit is set to '0',\nthen the system is disabled from sending and receiving\nframes on that VLAN. The default value is zero length\nstring.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vlanTrunkPortVlansEnabled4k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 19), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortVlansEnabled4k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 3072 through 4095 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 3072 through 3079; the second\noctet to VLANs 3080 through 3087; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet. If the bit corresponding to a VLAN is set to\n'1', then the local system is enabled for sending and\nreceiving frames on that VLAN; if the bit is set to '0',\nthen the system is disabled from sending and receiving\nframes on that VLAN. The default value is zero length\nstring.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vtpVlansPruningEligible2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 20), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlansPruningEligible2k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 1024 through 2047 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 1024 through 1031; the second\noctet to VLANs 1032 through 1039; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal system is permitted to prune that VLAN on this trunk\nport; if the bit is set to '0', then the system must not\nprune that VLAN on this trunk port.\nThe default value is zero length string.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vtpVlansPruningEligible3k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 21), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlansPruningEligible3k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 2048 through 3071 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 2048 through 2055; the second\noctet to VLANs 2056 through 2063; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal system is permitted to prune that VLAN on this trunk\nport; if the bit is set to '0', then the system must not\nprune that VLAN on this trunk port.\nThe default value is zero length string.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vtpVlansPruningEligible4k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vtpVlansPruningEligible4k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 3072 through 4095 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 3072 through 3079; the second\noctet to VLANs 3080 through 3087; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal system is permitted to prune that VLAN on this trunk\nport; if the bit is set to '0', then the system must not\nprune that VLAN on this trunk port.\nThe default value is zero length string.\n\nTo avoid conflicts between overlapping partial updates by\nmultiple managers, i.e., updates which modify only a portion\nof an instance of this object (e.g., enable/disable a single\nVLAN on the trunk port), any SNMP Set operation accessing an\ninstance of this object should also write the value of\nvlanTrunkPortSetSerialNo.")
vlanTrunkPortVlansXmitJoined2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 23), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansXmitJoined2k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 1024 through 2047 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 1024 through 1031; the second\noctet to VLANs 1032 through 1039; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then this\nVLAN is presently being forwarded on this trunk port, i.e.,\nit is not pruned; if the bit is set to '0', then this VLAN\nis presently not being forwarded on this trunk port, either\nbecause it is pruned or for some other reason.")
vlanTrunkPortVlansXmitJoined3k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 24), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansXmitJoined3k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 2048 through 3071 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 2048 through 2055; the second\noctet to VLANs 2056 through 2063; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then this\nVLAN is presently being forwarded on this trunk port, i.e.,\nit is not pruned; if the bit is set to '0', then this VLAN\nis presently not being forwarded on this trunk port, either\nbecause it is pruned or for some other reason.")
vlanTrunkPortVlansXmitJoined4k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 25), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansXmitJoined4k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 3072 through 4095 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 3072 through 3079; the second\noctet to VLANs 3080 through 3087; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then this\nVLAN is presently being forwarded on this trunk port, i.e.,\nit is not pruned; if the bit is set to '0', then this VLAN\nis presently not being forwarded on this trunk port, either\nbecause it is pruned or for some other reason.")
vlanTrunkPortVlansRcvJoined2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 26), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansRcvJoined2k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 1024 through 2047 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 1024 through 1031; the second\noctet to VLANs 1032 through 1039; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal switch is currently sending joins for this VLAN on\nthis trunk port, i.e., it is asking to receive frames for\nthis VLAN; if the bit is set to '0', then the local switch\nis not currently sending joins for this VLAN on this trunk\nport.")
vlanTrunkPortVlansRcvJoined3k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 27), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansRcvJoined3k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 2048 through 3071 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 2048 through 2055; the second\noctet to VLANs 2056 through 2063; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal switch is currently sending joins for this VLAN on\nthis trunk port, i.e., it is asking to receive frames for\nthis VLAN; if the bit is set to '0', then the local switch\nis not currently sending joins for this VLAN on this trunk\nport.")
vlanTrunkPortVlansRcvJoined4k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 28), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansRcvJoined4k.setDescription("A string of octets containing one bit per VLAN for VLANS\nwith VlanIndex values of 3072 through 4095 in the management\ndomain on this trunk port.  The first octet corresponds to\nVLANs with VlanIndex values of 3072 through 3079; the second\noctet to VLANs 3080 through 3087; etc.  The most significant\nbit of each octet corresponds to the lowest value VlanIndex\nin that octet.\n\nIf the bit corresponding to a VLAN is set to '1', then the\nlocal switch is currently sending joins for this VLAN on\nthis trunk port, i.e., it is asking to receive frames for\nthis VLAN; if the bit is set to '0', then the local switch\nis not currently sending joins for this VLAN on this trunk\nport.")
vlanTrunkPortDot1qTunnel = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 29), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("trunk", 1), ("access", 2), ("disabled", 3), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vlanTrunkPortDot1qTunnel.setDescription("Indicates dot1qtunnel mode of the port.\n\nIf the portDot1qTunnel  is set to 'trunk' mode, the port's\nvlanTrunkPortDynamicState will be changed to 'onNoNegotiate'\nand the vlanTrunkPortEncapsulationType will be set to\n'dot1Q'. These values cannot be changed unless dot1q tunnel\nis disabled on this port.\n\nIf the portDot1qTunnel mode is set to 'access' mode, the\nport's vlanTrunkPortDynamicState will be set to 'off'.And\nthe value of vlanTrunkPortDynamicState cannot be changed\nunless dot1q tunnel is disabled on this port. 1Q packets\nreceived on this access port will remain.\n\nSetting the port to dot1q tunnel 'disabled' mode causes the\ndot1q tunnel feature to be disabled on this port.  This\nobject can't be set to 'trunk' or 'access' mode, when\nvlanTrunkPortsDot1qTag  object is set to 'false'.\n\nThis object has been deprecated and is replaced by the\nobject 'cltcDot1qTunnelMode' in the\nCISCO-L2-TUNNEL-CONFIG-MIB")
vlanTrunkPortVlansActiveFirst2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 30), Cisco2KVlanList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansActiveFirst2k.setDescription("A string of octets containing one bit per VLAN\nwith VlanIndex values of 0 through 2047.\n\nIf the bit corresponding to a VLAN is set to 1,\nit indicates that vlan is allowed and active in\nmanagement domain.\n\nIf the bit corresponding to a VLAN is set to 0,\nit indicates that vlan is not allowed or not active\nin management domain.")
vlanTrunkPortVlansActiveSecond2k = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 1, 1, 31), Cisco2KVlanList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanTrunkPortVlansActiveSecond2k.setDescription("A string of octets containing one bit per VLAN\nwith VlanIndex values of 2048 through 4095.\n\nIf the bit corresponding to a VLAN is set to 1,\nit indicates that vlan is allowed and active in\nmanagement domain.\n\nIf the bit corresponding to a VLAN is set to 0,\nit indicates that vlan is not allowed or not active\nin management domain.")
vlanTrunkPortSetSerialNo = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vlanTrunkPortSetSerialNo.setDescription("An advisory lock used to allow several cooperating SNMPv2\nmanagers to coordinate their use of the SNMPv2 set operation\nacting upon any instance of vlanTrunkPortVlansEnabled.")
vlanTrunkPortsDot1qTag = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 6, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vlanTrunkPortsDot1qTag.setDescription("An indication of whether the tagging on all VLANs including\nnative VLAN for all 802.1q trunks is enabled.\n\nIf this object has a value of true(1) then all VLANs\nincluding native VLAN are tagged.  If the value is false(2)\nthen all VLANs excluding native VLAN are tagged.\n\nThis object has been deprecated and is replaced by the\nobject 'cltcDot1qAllTaggedEnabled' in the\nCISCO-L2-TUNNEL-CONFIG-MIB")
vtpDiscover = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7))
vtpDiscoverTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 1))
if mibBuilder.loadTexts: vtpDiscoverTable.setDescription("This table contains information related to the discovery\nof the VTP members in the designated management\ndomain. This table is not instantiated when \nmanagementDomainVersionInUse is version1(1), version2(3)\nor none(3).")
vtpDiscoverEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"))
if mibBuilder.loadTexts: vtpDiscoverEntry.setDescription("Information related to the discovery of the\nVTP members in one management domain.")
vtpDiscoverAction = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 1, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("discover", 1), ("noOperation", 2), ("purgeResult", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpDiscoverAction.setDescription("When this object is set to discover(1), all the\nentries in vtpDiscoverResultTable for the\ncorresponding management domain will be removed \nand the local device will begin to discover all\nVTP members in the management domain. Upon the\nsuccessful completion of discovery, the discovered\nresult will be stored in the vtpDiscoverResultTable.\n\nIf vtpDiscoverStatus is inProgress(1), setting \nvtpDiscoverAction to discover(1) will fail. \n\nWhen this object is set to purgeResult(3), \nall the entries of vtpDiscoverResultTable for \nthe corresponding management domain will be\nremoved from vtpDiscoverResultTable.\n\nWhen this object is set to noOperation(2), no\naction will be taken. When read, this object\nalways returns noOperation(2).")
vtpDiscoverStatus = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("inProgress", 1), ("succeeded", 2), ("resourceUnavailable", 3), ("someOtherError", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverStatus.setDescription("The current status of VTP discovery.\n\ninProgress - a discovery is in progress;\n\nsucceeded - the discovery was completed successfully\n            (this value is also used when \n            no discover has been invoked since the\n            last time the local system restarted);\n\nresourceUnavailable - the discovery failed because\n            the required allocation of a resource is\n            presently unavailable.\n\nsomeOtherError - 'the discovery failed due to a\n            reason no listed.")
vtpLastDiscoverTime = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 1, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpLastDiscoverTime.setDescription("The value of sysUpTime at which the last discovery\nwas completed.\n\nA value of zero indicates that no discovery has been\ninvoked since last time the local system restarted.")
vtpDiscoverResultTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2))
if mibBuilder.loadTexts: vtpDiscoverResultTable.setDescription("The table containing information of discovered VTP members\nin the management domain in which the local system is\nparticipating. This table is not instantiated when \nmanagementDomainVersionInUse is version1(1), version2(2) or\nnone(3).")
vtpDiscoverResultEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpDiscoverResultIndex"))
if mibBuilder.loadTexts: vtpDiscoverResultEntry.setDescription("A conceptual row is created for each VTP member which\nis found through successful discovery.")
vtpDiscoverResultIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 1), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultIndex.setDescription("A value assigned by the system which identifies\na VTP member and the associated database in the \nmanagement domain.")
vtpDiscoverResultDatabaseName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultDatabaseName.setDescription("The database name associated with the\ndiscovered VTP member.")
vtpDiscoverResultConflicting = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultConflicting.setDescription("Indicates whether this VTP member contains\nconflicting information.\n\ntrue(1) indicates that this member has conflicting \ninformation of the database type in the management domain.\n\nfalse(2) indicates that there is no conflicting information\nof the database type in the management domain.")
vtpDiscoverResultDeviceId = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultDeviceId.setDescription("The unique identifier of the device for this VTP member.")
vtpDiscoverResultPrimaryServer = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 5), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultPrimaryServer.setDescription("The unique identifier of the primary server for this VTP\nmember and the associated database type.\n\nThere are two different VTP servers, the primary server\nand the secondary server.  When a local device is\nconfigured as a server for a certain database type,\nit becomes secondary server by default. \nPrimary server is an operational role under which a\nserver can initiate or change the VTP configuration of the\ndatabase type.\n\nIf this VTP member itself is the primary server, the   \nvalue of this object is the same as the value of \nvtpDiscoverResultDeviceId of the instance.")
vtpDiscoverResultRevNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultRevNumber.setDescription("The current configuration revision number as known by the\nVTP member. When the database type is unknown for\nthe VTP member, this value is 0.")
vtpDiscoverResultSystemName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 7, 2, 1, 7), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDiscoverResultSystemName.setDescription("sysName of the VTP member.")
vtpDatabase = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8))
vtpDatabaseTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1))
if mibBuilder.loadTexts: vtpDatabaseTable.setDescription("This table contains information of the VTP\ndatabases. It is not instantiated when\nmanagementDomainVersionInUse is version1(1), \nversion2(3) or none(3).")
vtpDatabaseEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"), (0, "CISCO-VTP-MIB", "vtpDatabaseIndex"))
if mibBuilder.loadTexts: vtpDatabaseEntry.setDescription("Information about the status of the VTP database\nin the domain.  Each VTP database type known to the\nlocal device type has an entry in this table.\nAn entry is also created for unknown database which is\nnotified through VTP advertisements from other VTP\nservers.")
vtpDatabaseIndex = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 1), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vtpDatabaseIndex.setDescription("A value assigned by the system which uniquely identifies\na VTP database in the local system.")
vtpDatabaseName = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDatabaseName.setDescription("The name of the database.")
vtpDatabaseLocalMode = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,3,2,)).subtype(namedValues=NamedValues(("client", 1), ("server", 2), ("transparent", 3), ("off", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpDatabaseLocalMode.setDescription("The local VTP mode for a particular database type\nin this administrative domain.\n\n- 'client' indicates that the local system is acting\n  as a VTP client of the database type.\n\n- 'server' indicates that the local system is acting\n  as a VTP server of the database type.\n\n- 'transparent' indicates that the local system does\n  not generate or listen to VTP messages of this \n  database type, but forwards\n  messages. This mode can also be set by the device\n  itself when the size of database is too large for it\n  to hold in DRAM.\n\n- 'off' indicates that the local system does not\n  generate, listen to or forward any VTP messages\n  of this database type.\n\nThe default mode is 'client' for the database type \nknown to the local device and 'transparent' for the\nunknown database type.")
vtpDatabaseRevNumber = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDatabaseRevNumber.setDescription("The current configuration revision number as known by the\nlocal device for this VTP 3 database type in the management\ndomain.  This value is updated (if necessary) whenever a \nVTP advertisement for the database type is received \nor generated. When the database type is unknown to the \nlocal device or no VTP advertisement for the database\ntype is received or generated, its value is 0.")
vtpDatabasePrimaryServer = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 5), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDatabasePrimaryServer.setDescription("There are two kinds of VTP version 3 servers for a certain\ndatabase type - the primary server and the secondary server.\nWhen a local device is configured as a server for a certain\ndatabase type, it becomes secondary server by default.\nPrimary server is an operational role under which a\nserver can initiate or change the VTP configuration of the\ndatabase type.\n\nA true(1) value indicates that the local device is the \nprimary server of the database type in the management\ndomain. A false(2) value indicates that the local device\nis not the primary server, or the database type is unknown\nto the local device.")
vtpDatabasePrimaryServerId = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 6), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vtpDatabasePrimaryServerId.setDescription("The unique identifier of the primary server in the\nmanagement domain for the database type. \n\nIf no primary server is discovered for the database\ntype, the object has a value of zero length string.")
vtpDatabaseTakeOverPrimary = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 7), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpDatabaseTakeOverPrimary.setDescription("There are two kinds of VTP version 3 servers for a certain\ndatabase type - the primary server and the secondary server.\nWhen a local device is configured as a server for a certain\ndatabase type, it becomes secondary server by default.\nPrimary server is an operational role under which a\nserver can initiate or change the VTP configuration of the\ndatabase type.\n\nSetting this object to a true(1) value will advertise the\nconfiguration of this database type to the whole domain.\n\nIn order to successfully setting this object to true(1),\nthe value of vtpDatabaseLocalMode must be server(2). Besides\nthat, when the VTP password is hidden from the configuration\nfile, the password (vtpDatabaseTakeOverPassword) which \nmatches  the secret key (vtpAuthSecretKey) must be provided\nin the same data packet. \n\nWhen read, the object always returns false(2).")
vtpDatabaseTakeOverPassword = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 8, 1, 1, 8), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpDatabaseTakeOverPassword.setDescription("When read, this object always returns the value of a\nzero-length octet string.\n\nIn the case that the VTP password is hidden from the \nconfiguration and the local device intends\nto take over the whole domain, this object must be \nset to the matching password with the secret key \n(vtpAuthSecretKey) in the same data packet as which \nthe vtpDatabaseTakeOverPrimary is in. In all the \nother situations, setting a valid value to this object \nhas no impact on the system.")
vtpAuthentication = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9))
vtpAuthenticationTable = MibTable((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9, 1))
if mibBuilder.loadTexts: vtpAuthenticationTable.setDescription("The table contains the authentication information of VTP\nin which the local system participates.\n\nThe security mechanism of VTP relies on a secret key\nthat is used to alter the MD5 digest of the packets\ntransmitted on the wire.  The secret value is\ncreated from a password that may be saved in plain text\nin the configuration or hidden from the configuration.\n\nThe device creating or modifying the VTP configuration\nsigns it using the MD5 digest generated from the secret\nkey before advertising it. Other devices in the domain\nreceive this configuration use the same secret key\nto accept it if correctly signed or drop it otherwise.\n\nThe user has the option to hide the password from the\nconfiguration. Once the password is hidden, the secret\nkey generated from the password is shown in the \nconfiguration instead, and there is no other way to \nshow the password in plain text again but clearing \nit or resetting it. \n\nIn an un-trusted area, the password on a device can \nbe configured without being unveiled. After that,\nit has to be provided again by setting the same \nvalue to vtpDatabaseTakeOverPassword if the user \nwants to take over the whole VTP management domain\nof the database type.\n\nWhen managementDomainVersionInUse is version3(4), the \nauthentication mechanism is common to all VTP\ndatabase type.")
vtpAuthEntry = MibTableRow((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9, 1, 1)).setIndexNames((0, "CISCO-VTP-MIB", "managementDomainIndex"))
if mibBuilder.loadTexts: vtpAuthEntry.setDescription("Information about the status of the VTP\nauthentication information in one domain.")
vtpAuthPassword = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9, 1, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpAuthPassword.setDescription("By default, this object has a value of a zero-length\ncharacter string and is considered to be not\nconfigured.\n\nThe device uses the password to generate the \nsecret key. It can be stored in the configuration in \nplain text or hidden from the configuration. If a VTP \nserver intends to modify the database's configuration\nin the domain but the password was hidden from the\nconfiguration, the same password\n(vtpDatabaseTakeOverPassword) as the hidden one\nhas to be provided.\n\nWhen this object is set alone, vtpAuthPasswordType is\nset to plaintext(1) automatically by the system.\nSetting this object to a zero length character string\nresets the password to its default value and the\npassword is considered as not configured.\n\nThis object is not allowed to be set at the same time\nwhen  vtpAuthSecretKey is set.\n\nWhen the vtpAuthPasswordType is hidden(2), this object \nwill return a zero-length character string when read.")
vtpAuthPasswordType = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("plaintext", 1), ("hidden", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpAuthPasswordType.setDescription("By default this object has the value as plaintext(1)\nand the VTP password is stored in the configuration\nfile in plain text.\n\nSetting this object to hidden(2) will hide the\npassword from the configuration.\n\nOnce this object is set to hidden(2), it cannot\nbe set to plaintext(1) alone. However, it may\nbe set to plaintext(1) at the same time the\npassword is set.")
vtpAuthSecretKey = MibTableColumn((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 9, 1, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(16,16),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vtpAuthSecretKey.setDescription("The device creating or modifying the VTP configuration\nsigns it using the MD5 digest generated from the secret\nkey before advertising it. Other devices in the domain\nreceiving this configuration use the same secret key\nto accept it if it was correctly signed or drop it \notherwise.\n\nBy default, the object has the value as a zero-length\nstring and this value is read only. It is set \nto this value automatically when the password \n(vtpAuthPassword) is set to a zero-length octet string.\n\nThe secret key can be either generated using\nthe password or configured by the user. Once\nthe secret key is configured by the user, it is\nstored as a hexadecimal string in the device's\nconfiguration and the password is considered to be\nthe secret key's matching password and hidden\nfrom the configuration automatically.\n\nThis object is not allowed to be set at the same\ntime when vtpAuthPassword is set.\n\nThe secret key is overwritten by a newly generated\nsecret key when the password is re-configured.")
vlanStatistics = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 10))
vlanStatsVlans = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 10, 1), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanStatsVlans.setDescription("This object indicates the number of the existing\nmanageable VLANs with VLAN indices from 1 to\n1024 in the system.")
vlanStatsExtendedVlans = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 10, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanStatsExtendedVlans.setDescription("This object indicates the number of the\nexisting manageable VLANs with VLAN indices\ngreater than 1024 in the system.")
vlanStatsInternalVlans = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 10, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanStatsInternalVlans.setDescription("This object indicates the number of the\ninternal VLANs existing in the system.")
vlanStatsFreeVlans = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 1, 10, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vlanStatsFreeVlans.setDescription("This object indicates the number of the\nfree or unused VLANs in the system.")
vtpNotifications = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 2))
vtpNotificationsPrefix = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0))
vtpNotificationsObjects = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 1))
vtpVlanPortLocalSegment = MibScalar((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: vtpVlanPortLocalSegment.setDescription("The ring (segment) number in use on a 802.5 ring.  For\nbridges supporting RFC 1525, this value is the same as given\nby dot1dSrPortLocalSegment for the bridge port attached to\nthat ring.  When tokenRing VLANs are in use, each 'trNet'\nVLAN can/does have a different instance of\ndot1dSrPortLocalSegment for each physical port.  Note that\naccess to the particuler instance of dot1dSrPortLocalSegment\nrequires knowledge of how the agent supports the multiple\n'contexts' required to implement RFC 1525 for multiple\nVLANs; also note that the assignment of ifIndex values may\nbe different in different 'contexts'.")
vtpMIBConformance = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 3))
vtpMIBCompliances = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1))
vtpMIBGroups = MibIdentifier((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2))

# Augmentions
managementDomainEntry.registerAugmentions(("CISCO-VTP-MIB", "vtpStatsEntry"))
vtpStatsEntry.setIndexNames(*managementDomainEntry.getIndexNames())
managementDomainEntry.registerAugmentions(("CISCO-VTP-MIB", "vtpEditControlEntry"))
vtpEditControlEntry.setIndexNames(*managementDomainEntry.getIndexNames())

# Notifications

vtpConfigRevNumberError = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 1)).setObjects(*(("CISCO-VTP-MIB", "managementDomainConfigRevNumber"), ) )
if mibBuilder.loadTexts: vtpConfigRevNumberError.setDescription("A configuration revision number error notification\nsignifies that a device has incremented its\nvtpConfigRevNumberErrors counter.\n\nGeneration of this notification is suppressed if the\nvtpNotificationsEnabled has the value 'false'.\n\nThe device must throttle the generation of consecutive\nvtpConfigRevNumberError notifications so that there is at\nleast a five-second gap between notification of this type.\nWhen notification are throttled, they are dropped, not\nqueued for sending at a future time.  (Note that\n'generating' a notification means sending to all configured\nrecipients.)")
vtpConfigDigestError = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 2)).setObjects(*(("CISCO-VTP-MIB", "managementDomainConfigRevNumber"), ) )
if mibBuilder.loadTexts: vtpConfigDigestError.setDescription("A configuration digest error notification signifies that a\ndevice has incremented its vtpConfigDigestErrors counter.\n\nGeneration of this notification is suppressed if the\nvtpNotificationsEnabled has the value 'false'.\n\nThe device must throttle the generation of consecutive\nvtpConfigDigestError notifications so that there is at least\na five-second gap between notification of this type.  When\nnotification are throttled, they are dropped, not queued for\nsending at a future time.  (Note that 'generating' a\nnotification means sending to all configured recipients.)")
vtpServerDisabled = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 3)).setObjects(*(("CISCO-VTP-MIB", "managementDomainConfigRevNumber"), ("CISCO-VTP-MIB", "vtpMaxVlanStorage"), ) )
if mibBuilder.loadTexts: vtpServerDisabled.setDescription("A VTP Server disabled notification is generated when the\nlocal system is no longer able to function as a VTP Server\nbecause the number of defined VLANs is greater than\nvtpMaxVlanStorage or the local system is not able to\nrecover complete VTP information after a reboot.\n\nGeneration of this notification is suppressed if the\nvtpNotificationsEnabled has the value 'false'.")
vtpMtuTooBig = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 4)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanState"), ("CISCO-VTP-MIB", "vlanTrunkPortManagementDomain"), ) )
if mibBuilder.loadTexts: vtpMtuTooBig.setDescription("A VTP MTU tooBig notification is generated when a VLAN's\nMTU size is larger than can be supported either:\n\n- by one or more of its trunk ports:\n  the included vtpVlanState has the value\n  'mtuTooBigForTrunk' and the included\n  vlanTrunkPortManagementDomain is for the first (or only)\n  trunk port,\n  or\n\n- by the device itself:\n  vtpVlanState has the value 'mtuTooBigForDevice' and any\n  instance of vlanTrunkPortManagementDomain is included.\n\nDevices which have no trunk ports do not send vtpMtuTooBig\nnotifications.\n\nGeneration of this notification is suppressed if the\nvtpNotificationsEnabled has the value 'false'.")
vtpVersionOneDeviceDetected = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 6)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortManagementDomain"), ) )
if mibBuilder.loadTexts: vtpVersionOneDeviceDetected.setDescription("A VTP version one device detected notification is\ngenerated by a device when:\n\na) a management domain has been put into version 2 mode\n   (as accessed by managementDomainVersionInUse).\nb) 15 minutes has passed since a).\nc) a version 1 PDU is detected on a trunk on the device\n   that is in that management domain which has a lower\n   revision number than the current configuration.")
vlanTrunkPortDynamicStatusChange = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 7)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortDynamicStatus"), ) )
if mibBuilder.loadTexts: vlanTrunkPortDynamicStatusChange.setDescription("A vlanTrunkPortDynamicStatusChange notification is\ngenerated by a device when the value of\nvlanTrunkPortDynamicStatus object has been changed.")
vtpLocalModeChanged = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 8)).setObjects(*(("CISCO-VTP-MIB", "managementDomainLocalMode"), ) )
if mibBuilder.loadTexts: vtpLocalModeChanged.setDescription("A vtpLocalModeChanged notification is generated\nby a device when the value of the object \nmanagementDomainLocalMode is changed.")
vtpVersionInUseChanged = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 9)).setObjects(*(("CISCO-VTP-MIB", "managementDomainVersionInUse"), ) )
if mibBuilder.loadTexts: vtpVersionInUseChanged.setDescription("A vtpVersionInUseChanged notification is\ngenerated by a device when the value of the  \nobject managementDomainVersionInUse is \nchanged.")
vtpVlanCreated = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 10)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanName"), ) )
if mibBuilder.loadTexts: vtpVlanCreated.setDescription("A vtpVlanCreated notification is generated by a\ndevice when a VLAN is created.")
vtpVlanDeleted = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 11)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanName"), ) )
if mibBuilder.loadTexts: vtpVlanDeleted.setDescription("A vtpVlanDeleted notification is generated by a\ndevice when a VLAN is deleted.")
vtpVlanRingNumberConflict = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 12)).setObjects(*(("IF-MIB", "ifIndex"), ("CISCO-VTP-MIB", "vtpVlanRingNumber"), ("CISCO-VTP-MIB", "vtpVlanPortLocalSegment"), ) )
if mibBuilder.loadTexts: vtpVlanRingNumberConflict.setDescription("A VTP ring number configuration conflict notification is\ngenerated if, and only at the time when, a device learns of\na conflict between:\n\na) the ring number (vtpVlanPortLocalSegment) being used on a\n   token ring segment attached to the port identified by\n   ifIndex, and\n\nb) the VTP-obtained ring number (vtpVlanRingNumber) for the\n   VLAN identified by vtpVlanIndex.\n\nWhen such a conflict occurs, the bridge port is put into an\nadministrative down position until the conflict is resolved\nthrough local/network management intervention.\n\nThis notification is only applicable to VLANs of type\n'tokenRing'.")
vtpPruningStateOperChange = NotificationType((1, 3, 6, 1, 4, 1, 9, 9, 46, 2, 0, 13)).setObjects(*(("CISCO-VTP-MIB", "managementDomainPruningStateOper"), ) )
if mibBuilder.loadTexts: vtpPruningStateOperChange.setDescription("A vtpPruningStateOperChange notification is generated\nby the device when the instance value of\nmanagementDomainPruningStateOper is changed.")

# Groups

vtpBasicGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 1)).setObjects(*(("CISCO-VTP-MIB", "vtpMaxVlanStorage"), ("CISCO-VTP-MIB", "vtpVersion"), ("CISCO-VTP-MIB", "vtpNotificationsEnabled"), ("CISCO-VTP-MIB", "managementDomainName"), ("CISCO-VTP-MIB", "managementDomainConfigRevNumber"), ("CISCO-VTP-MIB", "managementDomainRowStatus"), ("CISCO-VTP-MIB", "managementDomainTftpPathname"), ("CISCO-VTP-MIB", "managementDomainTftpServer"), ("CISCO-VTP-MIB", "managementDomainLastChange"), ("CISCO-VTP-MIB", "managementDomainLastUpdater"), ("CISCO-VTP-MIB", "managementDomainLocalMode"), ) )
if mibBuilder.loadTexts: vtpBasicGroup.setDescription("A collection of objects providing basic status and control\nof a VTP implementation.")
vtpStatsGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 4)).setObjects(*(("CISCO-VTP-MIB", "vtpInAdvertRequests"), ("CISCO-VTP-MIB", "vtpInSubsetAdverts"), ("CISCO-VTP-MIB", "vtpConfigRevNumberErrors"), ("CISCO-VTP-MIB", "vtpOutSummaryAdverts"), ("CISCO-VTP-MIB", "vtpConfigDigestErrors"), ("CISCO-VTP-MIB", "vtpOutAdvertRequests"), ("CISCO-VTP-MIB", "vtpOutSubsetAdverts"), ("CISCO-VTP-MIB", "vtpInSummaryAdverts"), ) )
if mibBuilder.loadTexts: vtpStatsGroup.setDescription("A collection of objects providing VTP statistics.")
vtpTrunkPortGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 5)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortEncapsulationType"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled"), ("CISCO-VTP-MIB", "vlanTrunkPortRowStatus"), ("CISCO-VTP-MIB", "vlanTrunkPortManagementDomain"), ("CISCO-VTP-MIB", "vlanTrunkPortSetSerialNo"), ("CISCO-VTP-MIB", "vlanTrunkPortNativeVlan"), ) )
if mibBuilder.loadTexts: vtpTrunkPortGroup.setDescription("A collection of objects providing information on trunk\nports.")
vtpConfigNotificationsGroup = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 6)).setObjects(*(("CISCO-VTP-MIB", "vtpVersionOneDeviceDetected"), ("CISCO-VTP-MIB", "vtpConfigDigestError"), ("CISCO-VTP-MIB", "vlanTrunkPortDynamicStatusChange"), ("CISCO-VTP-MIB", "vtpConfigRevNumberError"), ("CISCO-VTP-MIB", "vtpServerDisabled"), ("CISCO-VTP-MIB", "vtpMtuTooBig"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup.setDescription("The notifications which a VTP implementation is\nrequired to implement.\nvtpConfigNotificationsGroup object is superseded by vtpConfigNotificationsGroupRev1, vtpConfigNotificationsGroup5.")
vtpTrunkPruningGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 7)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortOutJoins"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined"), ("CISCO-VTP-MIB", "vlanTrunkPortInJoins"), ("CISCO-VTP-MIB", "vlanTrunkPortOldAdverts"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansPruningEligible"), ) )
if mibBuilder.loadTexts: vtpTrunkPruningGroup.setDescription("A collection of objects providing information on VLAN\npruning.")
vtpTrunkPruningGroup2 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 10)).setObjects(*(("CISCO-VTP-MIB", "managementDomainPruningState"), ) )
if mibBuilder.loadTexts: vtpTrunkPruningGroup2.setDescription("A collection of object providing information on whether\nVLAN pruning is enabled.")
vtpTrunkPortGroup2 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 11)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortVtpEnabled"), ("CISCO-VTP-MIB", "vlanTrunkPortDynamicState"), ("CISCO-VTP-MIB", "vlanTrunkPortDynamicStatus"), ) )
if mibBuilder.loadTexts: vtpTrunkPortGroup2.setDescription("Additional functionality added to the\nvlanTrunkPortTable.")
vtpVersion2BasicGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 12)).setObjects(*(("CISCO-VTP-MIB", "managementDomainVersionInUse"), ) )
if mibBuilder.loadTexts: vtpVersion2BasicGroup.setDescription("The object required to indicate the version of VTP in\nuse by a management domain.")
vtpVlanInfoGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 13)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanSteHopCount"), ("CISCO-VTP-MIB", "vtpVlanTranslationalVlan2"), ("CISCO-VTP-MIB", "vtpVlanTranslationalVlan1"), ("CISCO-VTP-MIB", "vtpVlanParentVlan"), ("CISCO-VTP-MIB", "vtpVlanName"), ("CISCO-VTP-MIB", "vtpVlanStpType"), ("CISCO-VTP-MIB", "vtpVlanIsCRFBackup"), ("CISCO-VTP-MIB", "vtpVlanBridgeNumber"), ("CISCO-VTP-MIB", "vtpVlanBridgeType"), ("CISCO-VTP-MIB", "vtpVlanType"), ("CISCO-VTP-MIB", "vtpVlanMtu"), ("CISCO-VTP-MIB", "vtpVlanDot10Said"), ("CISCO-VTP-MIB", "vtpVlanState"), ("CISCO-VTP-MIB", "vtpVlanRingNumber"), ("CISCO-VTP-MIB", "vtpVlanAreHopCount"), ) )
if mibBuilder.loadTexts: vtpVlanInfoGroup.setDescription("A collection of objects for monitoring VLAN information.")
vtpVlanInfoEditGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 14)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanEditState"), ("CISCO-VTP-MIB", "vtpVlanEditRingNumber"), ("CISCO-VTP-MIB", "vtpVlanEditType"), ("CISCO-VTP-MIB", "vtpVlanEditAreHopCount"), ("CISCO-VTP-MIB", "vtpVlanApplyStatus"), ("CISCO-VTP-MIB", "vtpVlanEditBufferOwner"), ("CISCO-VTP-MIB", "vtpVlanEditConfigRevNumber"), ("CISCO-VTP-MIB", "vtpVlanEditIsCRFBackup"), ("CISCO-VTP-MIB", "vtpVlanEditBridgeType"), ("CISCO-VTP-MIB", "vtpVlanEditSteHopCount"), ("CISCO-VTP-MIB", "vtpVlanEditOperation"), ("CISCO-VTP-MIB", "vtpVlanEditParentVlan"), ("CISCO-VTP-MIB", "vtpVlanEditBridgeNumber"), ("CISCO-VTP-MIB", "vtpVlanEditTranslationalVlan1"), ("CISCO-VTP-MIB", "vtpVlanEditRowStatus"), ("CISCO-VTP-MIB", "vtpVlanEditStpType"), ("CISCO-VTP-MIB", "vtpVlanEditName"), ("CISCO-VTP-MIB", "vtpVlanEditMtu"), ("CISCO-VTP-MIB", "vtpVlanEditDot10Said"), ("CISCO-VTP-MIB", "vtpVlanEditTranslationalVlan2"), ) )
if mibBuilder.loadTexts: vtpVlanInfoEditGroup.setDescription("A collection of objects for editing VLAN information in VTP\nServers.")
vtpTrunkPortGroup3 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 15)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortEncapsulationOperType"), ) )
if mibBuilder.loadTexts: vtpTrunkPortGroup3.setDescription("Additional functionality added to the\nvlanTrunkPortTable.")
vtp4kVlanGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 16)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined4k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined2k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined4k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled2k"), ("CISCO-VTP-MIB", "vtpVlanEditTypeExt"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled4k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible3k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible2k"), ("CISCO-VTP-MIB", "vtpVlanTypeExt"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined2k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible4k"), ) )
if mibBuilder.loadTexts: vtp4kVlanGroup.setDescription("A collection of objects providing information\nfor VLANS with VlanIndex from 1024 to 4095.\nvtp4kVlanGroup object is superseded by vtp4kVlanGroupRev1.")
vtpDot1qTunnelGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 17)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortDot1qTunnel"), ("CISCO-VTP-MIB", "vlanTrunkPortsDot1qTag"), ) )
if mibBuilder.loadTexts: vtpDot1qTunnelGroup.setDescription("A collection of objects providing information\nfor dot1qtunnel feature.\nvtpDot1qTunnelGroup object is superseded by vtpDot1qTunnelGroup2.")
vtpVlanIfIndexGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 18)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanIfIndex"), ) )
if mibBuilder.loadTexts: vtpVlanIfIndexGroup.setDescription("A collection of objects providing information\nfor mapping of VLAN ID to its corresponding\nifIndex.")
vtpVlanInfoEditGroup2 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 19)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanEditModifiedVlan"), ) )
if mibBuilder.loadTexts: vtpVlanInfoEditGroup2.setDescription("A collection of objects for editing VLAN information when\nonly one VLAN is allowed to be edited for each 'apply'\noperation.")
vtp4kVlanGroupRev1 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 20)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanEditTypeExt2"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined2k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansXmitJoined4k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled2k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined4k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansEnabled4k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible3k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible2k"), ("CISCO-VTP-MIB", "vtpVlanTypeExt"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined3k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansRcvJoined2k"), ("CISCO-VTP-MIB", "vtpVlansPruningEligible4k"), ) )
if mibBuilder.loadTexts: vtp4kVlanGroupRev1.setDescription("A collection of objects providing information\nfor VLANS with VlanIndex from 1024 to 4095.")
vtpNotificationObjectsGroup = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 21)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanPortLocalSegment"), ) )
if mibBuilder.loadTexts: vtpNotificationObjectsGroup.setDescription("A collection of objects included in VTP notifications.")
vtpDot1qTunnelGroup2 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 22)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortsDot1qTag"), ) )
if mibBuilder.loadTexts: vtpDot1qTunnelGroup2.setDescription("A collection of objects providing information\nfor dot1qtunnel feature.")
vtpConfigNotificationsGroup2 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 23)).setObjects(*(("CISCO-VTP-MIB", "vtpLocalModeChanged"), ("CISCO-VTP-MIB", "vtpVersionInUseChanged"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup2.setDescription("The notifications which a VTP implementation is\nrequired to implement.")
vtpVlanNotifEnabledGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 24)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanCreatedNotifEnabled"), ("CISCO-VTP-MIB", "vtpVlanDeletedNotifEnabled"), ) )
if mibBuilder.loadTexts: vtpVlanNotifEnabledGroup.setDescription("A collection of objects to indicate whether a\ncertain group of notifications are enabled.")
vtpConfigNotificationsGroup3 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 25)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanCreated"), ("CISCO-VTP-MIB", "vtpVlanDeleted"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup3.setDescription("The notifications implemented by a device which\nsupports these features.")
vtpConfigNotificationsGroup4 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 26)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanRingNumberConflict"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup4.setDescription("The notifications implemented by a device which\nsupports these features.")
vtpDiscoverGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 27)).setObjects(*(("CISCO-VTP-MIB", "vtpDiscoverStatus"), ("CISCO-VTP-MIB", "vtpDiscoverResultSystemName"), ("CISCO-VTP-MIB", "vtpDiscoverResultPrimaryServer"), ("CISCO-VTP-MIB", "vtpLastDiscoverTime"), ("CISCO-VTP-MIB", "vtpDiscoverAction"), ("CISCO-VTP-MIB", "vtpDiscoverResultIndex"), ("CISCO-VTP-MIB", "vtpDiscoverResultDeviceId"), ("CISCO-VTP-MIB", "vtpDiscoverResultRevNumber"), ("CISCO-VTP-MIB", "vtpDiscoverResultConflicting"), ("CISCO-VTP-MIB", "vtpDiscoverResultDatabaseName"), ) )
if mibBuilder.loadTexts: vtpDiscoverGroup.setDescription("A collection of objects providing information of\nVTP discovery.")
vtpDatabaseGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 28)).setObjects(*(("CISCO-VTP-MIB", "vtpDatabasePrimaryServer"), ("CISCO-VTP-MIB", "vtpDatabaseRevNumber"), ("CISCO-VTP-MIB", "vtpDatabaseTakeOverPrimary"), ("CISCO-VTP-MIB", "vtpDatabaseLocalMode"), ("CISCO-VTP-MIB", "vtpDatabaseName"), ("CISCO-VTP-MIB", "vtpDatabasePrimaryServerId"), ("CISCO-VTP-MIB", "vtpDatabaseTakeOverPassword"), ) )
if mibBuilder.loadTexts: vtpDatabaseGroup.setDescription("A collection of objects providing information of\nVTP databases.")
vtpAuthGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 29)).setObjects(*(("CISCO-VTP-MIB", "vtpAuthPassword"), ("CISCO-VTP-MIB", "vtpAuthPasswordType"), ("CISCO-VTP-MIB", "vtpAuthSecretKey"), ) )
if mibBuilder.loadTexts: vtpAuthGroup.setDescription("A collection of objects providing information of\nVTP authentication mechanism.")
vtpConfigNotificationsGroupRev1 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 30)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortDynamicStatusChange"), ("CISCO-VTP-MIB", "vtpConfigRevNumberError"), ("CISCO-VTP-MIB", "vtpConfigDigestError"), ("CISCO-VTP-MIB", "vtpVersionOneDeviceDetected"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroupRev1.setDescription("The notifications which a VTP implementation is\nrequired to implement.")
vtpConfigNotificationsGroup5 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 31)).setObjects(*(("CISCO-VTP-MIB", "vtpServerDisabled"), ("CISCO-VTP-MIB", "vtpMtuTooBig"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup5.setDescription("The additional notifications that may be\nrelated to a VTP implementation.\nvtpConfigNotificationsGroup5 object is superseded by vtpConfigNotificationsGroup6, vtpConfigNotificationsGroup7.")
vtpInternalVlanGrp = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 32)).setObjects(*(("CISCO-VTP-MIB", "vtpInternalVlanOwner"), ("CISCO-VTP-MIB", "vtpInternalVlanAllocPolicy"), ) )
if mibBuilder.loadTexts: vtpInternalVlanGrp.setDescription("A collection of objects providing information of\ninternal VLANs.")
vlanStatsGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 33)).setObjects(*(("CISCO-VTP-MIB", "vlanStatsExtendedVlans"), ("CISCO-VTP-MIB", "vlanStatsVlans"), ("CISCO-VTP-MIB", "vlanStatsFreeVlans"), ("CISCO-VTP-MIB", "vlanStatsInternalVlans"), ) )
if mibBuilder.loadTexts: vlanStatsGroup.setDescription("A collection of objects providing VLAN statistics\ninformation in the system.")
vtpConfigNotificationsGroup6 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 34)).setObjects(*(("CISCO-VTP-MIB", "vtpServerDisabled"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup6.setDescription("The additional notifications that may be\nrelated to a VTP implementation.")
vtpConfigNotificationsGroup7 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 35)).setObjects(*(("CISCO-VTP-MIB", "vtpMtuTooBig"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup7.setDescription("The additional notifications that may be\nrelated to a VTP implementation.")
vtpTrunkPruningGroup3 = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 36)).setObjects(*(("CISCO-VTP-MIB", "managementDomainPruningStateOper"), ) )
if mibBuilder.loadTexts: vtpTrunkPruningGroup3.setDescription("A collection of objects providing information on\noperational VTP pruning state in a manamgement domain.")
vtpConfigNotificationsGroup8 = NotificationGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 37)).setObjects(*(("CISCO-VTP-MIB", "vtpPruningStateOperChange"), ) )
if mibBuilder.loadTexts: vtpConfigNotificationsGroup8.setDescription("The additional notifications for operational\nVTP pruning state change in a management domain.")
vlanTrunkPortActiveVlansGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 38)).setObjects(*(("CISCO-VTP-MIB", "vlanTrunkPortVlansActiveFirst2k"), ("CISCO-VTP-MIB", "vlanTrunkPortVlansActiveSecond2k"), ) )
if mibBuilder.loadTexts: vlanTrunkPortActiveVlansGroup.setDescription("A collection of objects providing active vlan\ninformation for a trunking port in a management\ndomain.")
vtpSourceInterfaceGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 39)).setObjects(*(("CISCO-VTP-MIB", "managementDomainOperSrcIf"), ("CISCO-VTP-MIB", "managementDomainAdminSrcIf"), ("CISCO-VTP-MIB", "managementDomainSourceOnlyMode"), ) )
if mibBuilder.loadTexts: vtpSourceInterfaceGroup.setDescription("A collection of object providing the preferred source\ninterface for the VTP IP updater address.")
vtpConfigFileGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 40)).setObjects(*(("CISCO-VTP-MIB", "managementDomainConfigFile"), ) )
if mibBuilder.loadTexts: vtpConfigFileGroup.setDescription("A collection of object providing the location of VTP\nconfiguration file.")
vtpVlanLocalShutdownGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 41)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanLocalShutdown"), ) )
if mibBuilder.loadTexts: vtpVlanLocalShutdownGroup.setDescription("A collection of object providing the VLAN local shutdown\nstate.")
vtpLocalUpdaterGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 42)).setObjects(*(("CISCO-VTP-MIB", "managementDomainLocalUpdater"), ("CISCO-VTP-MIB", "managementDomainLocalUpdaterType"), ) )
if mibBuilder.loadTexts: vtpLocalUpdaterGroup.setDescription("A collection of object providing the local updater IP address.")
vtpDeviceIdGroup = ObjectGroup((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 2, 43)).setObjects(*(("CISCO-VTP-MIB", "managementDomainDeviceID"), ) )
if mibBuilder.loadTexts: vtpDeviceIdGroup.setDescription("A collection of object providing the device id.")

# Compliances

vtpMIBCompliance = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 1)).setObjects(*(("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance2 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 2)).setObjects(*(("CISCO-VTP-MIB", "vtp4kVlanGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance2.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance3 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 3)).setObjects(*(("CISCO-VTP-MIB", "vtp4kVlanGroup"), ("CISCO-VTP-MIB", "vtpDot1qTunnelGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance3.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance4 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 4)).setObjects(*(("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpDot1qTunnelGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance4.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance5 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 5)).setObjects(*(("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpDot1qTunnelGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance5.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance6 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 6)).setObjects(*(("CISCO-VTP-MIB", "vtpDot1qTunnelGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance6.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance7 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 7)).setObjects(*(("CISCO-VTP-MIB", "vtpDot1qTunnelGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance7.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance8 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 8)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup"), ("CISCO-VTP-MIB", "vtpDot1qTunnelGroup2"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance8.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance9 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 9)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance9.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance10 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 10)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance10.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance11 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 11)).setObjects(*(("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance11.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance12 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 12)).setObjects(*(("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpInternalVlanGrp"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance12.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance13 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 13)).setObjects(*(("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup6"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vlanStatsGroup"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup7"), ("CISCO-VTP-MIB", "vtpInternalVlanGrp"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance13.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance14 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 14)).setObjects(*(("CISCO-VTP-MIB", "vtpTrunkPruningGroup"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup2"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup3"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vlanStatsGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup3"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup2"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup7"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup6"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup2"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup4"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup3"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup8"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpInternalVlanGrp"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance14.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance15 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 15)).setObjects(*(("CISCO-VTP-MIB", "vtpTrunkPruningGroup"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup2"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup3"), ("CISCO-VTP-MIB", "vlanTrunkPortActiveVlansGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vlanStatsGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup3"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup2"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup7"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup6"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup2"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup4"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup3"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup8"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpInternalVlanGrp"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance15.setDescription("The compliance statement for VTP implementations.")
vtpMIBCompliance16 = ModuleCompliance((1, 3, 6, 1, 4, 1, 9, 9, 46, 3, 1, 16)).setObjects(*(("CISCO-VTP-MIB", "vtpTrunkPruningGroup3"), ("CISCO-VTP-MIB", "vlanTrunkPortActiveVlansGroup"), ("CISCO-VTP-MIB", "vtpDeviceIdGroup"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup"), ("CISCO-VTP-MIB", "vtpVlanNotifEnabledGroup"), ("CISCO-VTP-MIB", "vtpConfigFileGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup"), ("CISCO-VTP-MIB", "vlanStatsGroup"), ("CISCO-VTP-MIB", "vtpVlanLocalShutdownGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroupRev1"), ("CISCO-VTP-MIB", "vtpAuthGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup3"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup2"), ("CISCO-VTP-MIB", "vtpVlanInfoGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup7"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup6"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup2"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup3"), ("CISCO-VTP-MIB", "vtpDiscoverGroup"), ("CISCO-VTP-MIB", "vtpTrunkPruningGroup2"), ("CISCO-VTP-MIB", "vtp4kVlanGroupRev1"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup4"), ("CISCO-VTP-MIB", "vtpDatabaseGroup"), ("CISCO-VTP-MIB", "vtpLocalUpdaterGroup"), ("CISCO-VTP-MIB", "vtpVersion2BasicGroup"), ("CISCO-VTP-MIB", "vtpBasicGroup"), ("CISCO-VTP-MIB", "vtpStatsGroup"), ("CISCO-VTP-MIB", "vtpConfigNotificationsGroup8"), ("CISCO-VTP-MIB", "vtpNotificationObjectsGroup"), ("CISCO-VTP-MIB", "vtpSourceInterfaceGroup"), ("CISCO-VTP-MIB", "vtpTrunkPortGroup"), ("CISCO-VTP-MIB", "vtpInternalVlanGrp"), ("CISCO-VTP-MIB", "vtpVlanIfIndexGroup"), ("CISCO-VTP-MIB", "vtpVlanInfoEditGroup2"), ) )
if mibBuilder.loadTexts: vtpMIBCompliance16.setDescription("The compliance statement for VTP implementations.")

# Exports

# Module identity
mibBuilder.exportSymbols("CISCO-VTP-MIB", PYSNMP_MODULE_ID=ciscoVtpMIB)

# Types
mibBuilder.exportSymbols("CISCO-VTP-MIB", ManagementDomainIndex=ManagementDomainIndex, VlanIndex=VlanIndex, VlanType=VlanType, VlanTypeExt=VlanTypeExt)

# Objects
mibBuilder.exportSymbols("CISCO-VTP-MIB", ciscoVtpMIB=ciscoVtpMIB, vtpMIBObjects=vtpMIBObjects, vtpStatus=vtpStatus, vtpVersion=vtpVersion, vtpMaxVlanStorage=vtpMaxVlanStorage, vtpNotificationsEnabled=vtpNotificationsEnabled, vtpVlanCreatedNotifEnabled=vtpVlanCreatedNotifEnabled, vtpVlanDeletedNotifEnabled=vtpVlanDeletedNotifEnabled, vlanManagementDomains=vlanManagementDomains, managementDomainTable=managementDomainTable, managementDomainEntry=managementDomainEntry, managementDomainIndex=managementDomainIndex, managementDomainName=managementDomainName, managementDomainLocalMode=managementDomainLocalMode, managementDomainConfigRevNumber=managementDomainConfigRevNumber, managementDomainLastUpdater=managementDomainLastUpdater, managementDomainLastChange=managementDomainLastChange, managementDomainRowStatus=managementDomainRowStatus, managementDomainTftpServer=managementDomainTftpServer, managementDomainTftpPathname=managementDomainTftpPathname, managementDomainPruningState=managementDomainPruningState, managementDomainVersionInUse=managementDomainVersionInUse, managementDomainPruningStateOper=managementDomainPruningStateOper, managementDomainAdminSrcIf=managementDomainAdminSrcIf, managementDomainSourceOnlyMode=managementDomainSourceOnlyMode, managementDomainOperSrcIf=managementDomainOperSrcIf, managementDomainConfigFile=managementDomainConfigFile, managementDomainLocalUpdaterType=managementDomainLocalUpdaterType, managementDomainLocalUpdater=managementDomainLocalUpdater, managementDomainDeviceID=managementDomainDeviceID, vlanInfo=vlanInfo, vtpVlanTable=vtpVlanTable, vtpVlanEntry=vtpVlanEntry, vtpVlanIndex=vtpVlanIndex, vtpVlanState=vtpVlanState, vtpVlanType=vtpVlanType, vtpVlanName=vtpVlanName, vtpVlanMtu=vtpVlanMtu, vtpVlanDot10Said=vtpVlanDot10Said, vtpVlanRingNumber=vtpVlanRingNumber, vtpVlanBridgeNumber=vtpVlanBridgeNumber, vtpVlanStpType=vtpVlanStpType, vtpVlanParentVlan=vtpVlanParentVlan, vtpVlanTranslationalVlan1=vtpVlanTranslationalVlan1, vtpVlanTranslationalVlan2=vtpVlanTranslationalVlan2, vtpVlanBridgeType=vtpVlanBridgeType, vtpVlanAreHopCount=vtpVlanAreHopCount, vtpVlanSteHopCount=vtpVlanSteHopCount, vtpVlanIsCRFBackup=vtpVlanIsCRFBackup, vtpVlanTypeExt=vtpVlanTypeExt, vtpVlanIfIndex=vtpVlanIfIndex, internalVlanInfo=internalVlanInfo, vtpInternalVlanAllocPolicy=vtpInternalVlanAllocPolicy, vtpInternalVlanTable=vtpInternalVlanTable, vtpInternalVlanEntry=vtpInternalVlanEntry, vtpInternalVlanOwner=vtpInternalVlanOwner, vlanEdit=vlanEdit, vtpEditControlTable=vtpEditControlTable, vtpEditControlEntry=vtpEditControlEntry, vtpVlanEditOperation=vtpVlanEditOperation, vtpVlanApplyStatus=vtpVlanApplyStatus, vtpVlanEditBufferOwner=vtpVlanEditBufferOwner, vtpVlanEditConfigRevNumber=vtpVlanEditConfigRevNumber, vtpVlanEditModifiedVlan=vtpVlanEditModifiedVlan, vtpVlanEditTable=vtpVlanEditTable, vtpVlanEditEntry=vtpVlanEditEntry, vtpVlanEditIndex=vtpVlanEditIndex, vtpVlanEditState=vtpVlanEditState, vtpVlanEditType=vtpVlanEditType, vtpVlanEditName=vtpVlanEditName, vtpVlanEditMtu=vtpVlanEditMtu, vtpVlanEditDot10Said=vtpVlanEditDot10Said, vtpVlanEditRingNumber=vtpVlanEditRingNumber, vtpVlanEditBridgeNumber=vtpVlanEditBridgeNumber, vtpVlanEditStpType=vtpVlanEditStpType, vtpVlanEditParentVlan=vtpVlanEditParentVlan, vtpVlanEditRowStatus=vtpVlanEditRowStatus, vtpVlanEditTranslationalVlan1=vtpVlanEditTranslationalVlan1, vtpVlanEditTranslationalVlan2=vtpVlanEditTranslationalVlan2, vtpVlanEditBridgeType=vtpVlanEditBridgeType, vtpVlanEditAreHopCount=vtpVlanEditAreHopCount, vtpVlanEditSteHopCount=vtpVlanEditSteHopCount, vtpVlanEditIsCRFBackup=vtpVlanEditIsCRFBackup, vtpVlanEditTypeExt=vtpVlanEditTypeExt, vtpVlanEditTypeExt2=vtpVlanEditTypeExt2, vtpVlanLocalShutdownTable=vtpVlanLocalShutdownTable, vtpVlanLocalShutdownEntry=vtpVlanLocalShutdownEntry, vtpVlanLocalShutdown=vtpVlanLocalShutdown, vtpStats=vtpStats, vtpStatsTable=vtpStatsTable, vtpStatsEntry=vtpStatsEntry, vtpInSummaryAdverts=vtpInSummaryAdverts, vtpInSubsetAdverts=vtpInSubsetAdverts, vtpInAdvertRequests=vtpInAdvertRequests, vtpOutSummaryAdverts=vtpOutSummaryAdverts, vtpOutSubsetAdverts=vtpOutSubsetAdverts, vtpOutAdvertRequests=vtpOutAdvertRequests, vtpConfigRevNumberErrors=vtpConfigRevNumberErrors, vtpConfigDigestErrors=vtpConfigDigestErrors, vlanTrunkPorts=vlanTrunkPorts, vlanTrunkPortTable=vlanTrunkPortTable, vlanTrunkPortEntry=vlanTrunkPortEntry, vlanTrunkPortIfIndex=vlanTrunkPortIfIndex, vlanTrunkPortManagementDomain=vlanTrunkPortManagementDomain, vlanTrunkPortEncapsulationType=vlanTrunkPortEncapsulationType, vlanTrunkPortVlansEnabled=vlanTrunkPortVlansEnabled, vlanTrunkPortNativeVlan=vlanTrunkPortNativeVlan, vlanTrunkPortRowStatus=vlanTrunkPortRowStatus, vlanTrunkPortInJoins=vlanTrunkPortInJoins, vlanTrunkPortOutJoins=vlanTrunkPortOutJoins, vlanTrunkPortOldAdverts=vlanTrunkPortOldAdverts, vlanTrunkPortVlansPruningEligible=vlanTrunkPortVlansPruningEligible, vlanTrunkPortVlansXmitJoined=vlanTrunkPortVlansXmitJoined, vlanTrunkPortVlansRcvJoined=vlanTrunkPortVlansRcvJoined, vlanTrunkPortDynamicState=vlanTrunkPortDynamicState, vlanTrunkPortDynamicStatus=vlanTrunkPortDynamicStatus, vlanTrunkPortVtpEnabled=vlanTrunkPortVtpEnabled, vlanTrunkPortEncapsulationOperType=vlanTrunkPortEncapsulationOperType, vlanTrunkPortVlansEnabled2k=vlanTrunkPortVlansEnabled2k, vlanTrunkPortVlansEnabled3k=vlanTrunkPortVlansEnabled3k, vlanTrunkPortVlansEnabled4k=vlanTrunkPortVlansEnabled4k, vtpVlansPruningEligible2k=vtpVlansPruningEligible2k, vtpVlansPruningEligible3k=vtpVlansPruningEligible3k, vtpVlansPruningEligible4k=vtpVlansPruningEligible4k, vlanTrunkPortVlansXmitJoined2k=vlanTrunkPortVlansXmitJoined2k, vlanTrunkPortVlansXmitJoined3k=vlanTrunkPortVlansXmitJoined3k)
mibBuilder.exportSymbols("CISCO-VTP-MIB", vlanTrunkPortVlansXmitJoined4k=vlanTrunkPortVlansXmitJoined4k, vlanTrunkPortVlansRcvJoined2k=vlanTrunkPortVlansRcvJoined2k, vlanTrunkPortVlansRcvJoined3k=vlanTrunkPortVlansRcvJoined3k, vlanTrunkPortVlansRcvJoined4k=vlanTrunkPortVlansRcvJoined4k, vlanTrunkPortDot1qTunnel=vlanTrunkPortDot1qTunnel, vlanTrunkPortVlansActiveFirst2k=vlanTrunkPortVlansActiveFirst2k, vlanTrunkPortVlansActiveSecond2k=vlanTrunkPortVlansActiveSecond2k, vlanTrunkPortSetSerialNo=vlanTrunkPortSetSerialNo, vlanTrunkPortsDot1qTag=vlanTrunkPortsDot1qTag, vtpDiscover=vtpDiscover, vtpDiscoverTable=vtpDiscoverTable, vtpDiscoverEntry=vtpDiscoverEntry, vtpDiscoverAction=vtpDiscoverAction, vtpDiscoverStatus=vtpDiscoverStatus, vtpLastDiscoverTime=vtpLastDiscoverTime, vtpDiscoverResultTable=vtpDiscoverResultTable, vtpDiscoverResultEntry=vtpDiscoverResultEntry, vtpDiscoverResultIndex=vtpDiscoverResultIndex, vtpDiscoverResultDatabaseName=vtpDiscoverResultDatabaseName, vtpDiscoverResultConflicting=vtpDiscoverResultConflicting, vtpDiscoverResultDeviceId=vtpDiscoverResultDeviceId, vtpDiscoverResultPrimaryServer=vtpDiscoverResultPrimaryServer, vtpDiscoverResultRevNumber=vtpDiscoverResultRevNumber, vtpDiscoverResultSystemName=vtpDiscoverResultSystemName, vtpDatabase=vtpDatabase, vtpDatabaseTable=vtpDatabaseTable, vtpDatabaseEntry=vtpDatabaseEntry, vtpDatabaseIndex=vtpDatabaseIndex, vtpDatabaseName=vtpDatabaseName, vtpDatabaseLocalMode=vtpDatabaseLocalMode, vtpDatabaseRevNumber=vtpDatabaseRevNumber, vtpDatabasePrimaryServer=vtpDatabasePrimaryServer, vtpDatabasePrimaryServerId=vtpDatabasePrimaryServerId, vtpDatabaseTakeOverPrimary=vtpDatabaseTakeOverPrimary, vtpDatabaseTakeOverPassword=vtpDatabaseTakeOverPassword, vtpAuthentication=vtpAuthentication, vtpAuthenticationTable=vtpAuthenticationTable, vtpAuthEntry=vtpAuthEntry, vtpAuthPassword=vtpAuthPassword, vtpAuthPasswordType=vtpAuthPasswordType, vtpAuthSecretKey=vtpAuthSecretKey, vlanStatistics=vlanStatistics, vlanStatsVlans=vlanStatsVlans, vlanStatsExtendedVlans=vlanStatsExtendedVlans, vlanStatsInternalVlans=vlanStatsInternalVlans, vlanStatsFreeVlans=vlanStatsFreeVlans, vtpNotifications=vtpNotifications, vtpNotificationsPrefix=vtpNotificationsPrefix, vtpNotificationsObjects=vtpNotificationsObjects, vtpVlanPortLocalSegment=vtpVlanPortLocalSegment, vtpMIBConformance=vtpMIBConformance, vtpMIBCompliances=vtpMIBCompliances, vtpMIBGroups=vtpMIBGroups)

# Notifications
mibBuilder.exportSymbols("CISCO-VTP-MIB", vtpConfigRevNumberError=vtpConfigRevNumberError, vtpConfigDigestError=vtpConfigDigestError, vtpServerDisabled=vtpServerDisabled, vtpMtuTooBig=vtpMtuTooBig, vtpVersionOneDeviceDetected=vtpVersionOneDeviceDetected, vlanTrunkPortDynamicStatusChange=vlanTrunkPortDynamicStatusChange, vtpLocalModeChanged=vtpLocalModeChanged, vtpVersionInUseChanged=vtpVersionInUseChanged, vtpVlanCreated=vtpVlanCreated, vtpVlanDeleted=vtpVlanDeleted, vtpVlanRingNumberConflict=vtpVlanRingNumberConflict, vtpPruningStateOperChange=vtpPruningStateOperChange)

# Groups
mibBuilder.exportSymbols("CISCO-VTP-MIB", vtpBasicGroup=vtpBasicGroup, vtpStatsGroup=vtpStatsGroup, vtpTrunkPortGroup=vtpTrunkPortGroup, vtpConfigNotificationsGroup=vtpConfigNotificationsGroup, vtpTrunkPruningGroup=vtpTrunkPruningGroup, vtpTrunkPruningGroup2=vtpTrunkPruningGroup2, vtpTrunkPortGroup2=vtpTrunkPortGroup2, vtpVersion2BasicGroup=vtpVersion2BasicGroup, vtpVlanInfoGroup=vtpVlanInfoGroup, vtpVlanInfoEditGroup=vtpVlanInfoEditGroup, vtpTrunkPortGroup3=vtpTrunkPortGroup3, vtp4kVlanGroup=vtp4kVlanGroup, vtpDot1qTunnelGroup=vtpDot1qTunnelGroup, vtpVlanIfIndexGroup=vtpVlanIfIndexGroup, vtpVlanInfoEditGroup2=vtpVlanInfoEditGroup2, vtp4kVlanGroupRev1=vtp4kVlanGroupRev1, vtpNotificationObjectsGroup=vtpNotificationObjectsGroup, vtpDot1qTunnelGroup2=vtpDot1qTunnelGroup2, vtpConfigNotificationsGroup2=vtpConfigNotificationsGroup2, vtpVlanNotifEnabledGroup=vtpVlanNotifEnabledGroup, vtpConfigNotificationsGroup3=vtpConfigNotificationsGroup3, vtpConfigNotificationsGroup4=vtpConfigNotificationsGroup4, vtpDiscoverGroup=vtpDiscoverGroup, vtpDatabaseGroup=vtpDatabaseGroup, vtpAuthGroup=vtpAuthGroup, vtpConfigNotificationsGroupRev1=vtpConfigNotificationsGroupRev1, vtpConfigNotificationsGroup5=vtpConfigNotificationsGroup5, vtpInternalVlanGrp=vtpInternalVlanGrp, vlanStatsGroup=vlanStatsGroup, vtpConfigNotificationsGroup6=vtpConfigNotificationsGroup6, vtpConfigNotificationsGroup7=vtpConfigNotificationsGroup7, vtpTrunkPruningGroup3=vtpTrunkPruningGroup3, vtpConfigNotificationsGroup8=vtpConfigNotificationsGroup8, vlanTrunkPortActiveVlansGroup=vlanTrunkPortActiveVlansGroup, vtpSourceInterfaceGroup=vtpSourceInterfaceGroup, vtpConfigFileGroup=vtpConfigFileGroup, vtpVlanLocalShutdownGroup=vtpVlanLocalShutdownGroup, vtpLocalUpdaterGroup=vtpLocalUpdaterGroup, vtpDeviceIdGroup=vtpDeviceIdGroup)

# Compliances
mibBuilder.exportSymbols("CISCO-VTP-MIB", vtpMIBCompliance=vtpMIBCompliance, vtpMIBCompliance2=vtpMIBCompliance2, vtpMIBCompliance3=vtpMIBCompliance3, vtpMIBCompliance4=vtpMIBCompliance4, vtpMIBCompliance5=vtpMIBCompliance5, vtpMIBCompliance6=vtpMIBCompliance6, vtpMIBCompliance7=vtpMIBCompliance7, vtpMIBCompliance8=vtpMIBCompliance8, vtpMIBCompliance9=vtpMIBCompliance9, vtpMIBCompliance10=vtpMIBCompliance10, vtpMIBCompliance11=vtpMIBCompliance11, vtpMIBCompliance12=vtpMIBCompliance12, vtpMIBCompliance13=vtpMIBCompliance13, vtpMIBCompliance14=vtpMIBCompliance14, vtpMIBCompliance15=vtpMIBCompliance15, vtpMIBCompliance16=vtpMIBCompliance16)