# Copyright 2010-2011 Isotoma Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from yay.nodes import Node
from yay.errors import NoMatching


class Undefined(Node):

    def __init__(self):
        pass

    def resolve(self):
        self.error(NoMatching("Undefined!"))

    def clone(self):
        c = Undefined()

        c.file = self.name        
        c.line = self.line
        c.column = self.column
        c.snippet = self.snippet

        return c

